/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central;

import ibis.ipl.registry.central.Event;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventList {
    private static final Logger logger = LoggerFactory.getLogger(EventList.class);
    private final SortedSet<Event> events = new TreeSet<Event>();
    private int minimum = 0;

    public Event get(int time) {
        if (logger.isDebugEnabled()) {
            logger.debug("getting event " + time);
        }
        for (Event event : this.events) {
            if (event.getTime() == time) {
                if (logger.isDebugEnabled()) {
                    logger.debug("getting event " + time + ", returning " + event);
                }
                return event;
            }
            if (event.getTime() <= time) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("getting event " + time + ", returning <null>");
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getting event " + time + ", returning <null>");
        }
        return null;
    }

    public Event[] getList(int start) {
        if (logger.isDebugEnabled()) {
            logger.debug("getting events from " + start);
        }
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : this.events) {
            int time;
            if (logger.isDebugEnabled()) {
                logger.debug("considering " + event);
            }
            if ((time = event.getTime()) < start) continue;
            if (result.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("adding " + event);
                }
                result.add(event);
                continue;
            }
            Event previous = (Event)result.get(result.size() - 1);
            if (time != previous.getTime() + 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("NOT adding " + event + " time should be " + (previous.getTime() + 1));
                }
                return result.toArray(new Event[0]);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("adding " + event);
            }
            result.add(event);
        }
        return result.toArray(new Event[0]);
    }

    public Event[] getSignalEvents(int from, int to) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : this.events) {
            if (event.getTime() > to) {
                return result.toArray(new Event[0]);
            }
            if (event.getType() != 3 || event.getTime() < from) continue;
            result.add(event);
        }
        return result.toArray(new Event[0]);
    }

    public void add(Event ... newEvents) {
        for (Event event : newEvents) {
            this.events.add(event);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("adding event to list: " + event + ", list now " + this.toString());
        }
    }

    public void setMinimum(int time) {
        this.minimum = time;
        if (logger.isDebugEnabled()) {
            logger.debug("purging upto " + time);
        }
        while (!this.events.isEmpty() && this.events.first().getTime() < time) {
            Event first = this.events.first();
            if (logger.isDebugEnabled()) {
                logger.debug("removing " + first);
            }
            this.events.remove(first);
        }
    }

    public int getNextRequiredEvent() {
        int result = this.minimum;
        for (Event event : this.events) {
            if (event.getTime() != result + 1) continue;
            ++result;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("next required event: " + result);
        }
        return result;
    }

    public String toString() {
        String message = "eventList: ";
        for (Event event : this.events) {
            message = message + event + " ";
        }
        return message;
    }
}

