/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry;

import ibis.ipl.Credentials;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.NullRegistry;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public abstract class Registry
implements ibis.ipl.Registry {
    public abstract void leave() throws IOException;

    public abstract long getSequenceNumber(String var1) throws IOException;

    public static Registry createRegistry(IbisCapabilities capabilities, RegistryEventHandler handler, Properties properties, byte[] data, String implementationVersion, byte[] tag, Credentials credentials) throws Throwable {
        String registryName = properties.getProperty("ibis.registry.implementation");
        if (registryName == null) {
            throw new IbisConfigurationException("Could not create registry: property ibis.registry.implementation  is not set.");
        }
        if (registryName.equalsIgnoreCase("central")) {
            return new ibis.ipl.registry.central.client.Registry(capabilities, handler, properties, data, implementationVersion, credentials, tag);
        }
        if (registryName.equalsIgnoreCase("gossip")) {
            return new ibis.ipl.registry.gossip.Registry(capabilities, handler, properties, data, implementationVersion, credentials, tag);
        }
        if (registryName.equalsIgnoreCase("null")) {
            return new NullRegistry(capabilities, handler, properties, data, implementationVersion, credentials, tag);
        }
        Class<?> c = Class.forName(registryName);
        try {
            return (Registry)c.getConstructor(IbisCapabilities.class, RegistryEventHandler.class, Properties.class, byte[].class, String.class, Credentials.class, byte[].class).newInstance(capabilities, handler, properties, data, implementationVersion, credentials, tag);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public abstract IbisIdentifier getIbisIdentifier();

    public abstract IbisIdentifier getRandomPoolMember();

    public abstract String[] wonElections();
}

