/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile;

import ibis.compile.ASMWrapper;
import ibis.compile.BCELWrapper;
import ibis.compile.ByteCodeWrapper;
import ibis.compile.ClassInfo;
import ibis.compile.IbiscComponent;
import ibis.compile.IbiscEntry;
import ibis.compile.JarEntryInfo;
import ibis.compile.JarInfo;
import ibis.util.ClassLister;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipOutputStream;

public class Ibisc {
    public static HashMap<String, IbiscEntry> allClasses = new HashMap();
    private static ArrayList<JarInfo> jarFiles = new ArrayList();
    private static boolean verbose = false;
    private static boolean compress = true;
    static boolean debug = false;
    static ByteCodeWrapper w;
    static ByteCodeWrapper bcelWrapper;
    static ByteCodeWrapper asmWrapper;
    private static ArrayList<IbiscComponent> ibiscComponents;

    private Ibisc() {
    }

    private static void getClassesFromDirectory(File f, String prefix) {
        File[] list = f.listFiles();
        prefix = !prefix.equals("") ? prefix + f.getName() + File.separator : f.getName() + File.separator;
        for (int i = 0; i < list.length; ++i) {
            String fname = list[i].getName();
            if (list[i].isDirectory()) {
                Ibisc.getClassesFromDirectory(list[i], prefix);
                continue;
            }
            if (fname.endsWith(".class")) {
                Ibisc.getClassFromClassFile(prefix + fname);
                continue;
            }
            if (!fname.endsWith(".jar")) continue;
            Ibisc.getClassesFromJarFile(list[i], prefix + fname);
        }
    }

    private static void getClassFromClassFile(String fileName) {
        ClassInfo cl = null;
        try {
            cl = w.parseClassFile(fileName);
        }
        catch (IOException e) {
            System.err.println("Ibisc: warning: could not read class " + fileName);
        }
        if (cl != null) {
            allClasses.put(cl.getClassName(), new IbiscEntry(cl, fileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getClassesFromJarFile(File f, String fileName) {
        JarFile jf = null;
        JarInfo jarInfo = null;
        try {
            jf = new JarFile(f, true);
            jarInfo = new JarInfo(jf);
        }
        catch (IOException e) {
            System.err.println("Ibisc: warning: could not read jarfile " + fileName);
            return;
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException e) {}
            }
        }
        jarFiles.add(jarInfo);
    }

    private static void verifyClasses(IbiscComponent ic) {
        for (IbiscEntry e : allClasses.values()) {
            if (!e.getModified() || e.getClassInfo().doVerify()) continue;
            System.out.println("Ibisc: verification failed after component " + ic.getClass().getName());
            System.exit(1);
        }
    }

    private static void writeClasses() {
        for (IbiscEntry e : allClasses.values()) {
            if (!e.getModified() || e.getJarInfo() != null) continue;
            File temp = null;
            try {
                File file = new File(e.fileName);
                File canonicalDir = file.getCanonicalFile().getParentFile();
                temp = File.createTempFile("Ibisc_", null, canonicalDir);
                e.getClassInfo().dump(temp.getCanonicalPath());
                Ibisc.rename(file, temp, canonicalDir);
            }
            catch (Exception ex) {
                System.err.println("Ibisc: got exception while writing " + e.fileName + ": " + ex);
                ex.printStackTrace(System.err);
                if (temp != null) {
                    temp.delete();
                }
                System.exit(1);
            }
            e.setModified(false);
        }
    }

    private static void rename(File dest, File src, File dir) throws IOException {
        File temp = File.createTempFile("Ibc_", null, dir);
        temp.delete();
        if (dest.exists() && !dest.renameTo(temp)) {
            throw new IOException("Could not rename " + dest.getPath() + " to temporary " + temp.getPath());
        }
        if (!src.renameTo(dest)) {
            if (temp.exists()) {
                temp.renameTo(dest);
            }
            throw new IOException("Could not rename " + src.getPath() + "to " + dest.getPath());
        }
        temp.delete();
    }

    private static void writeJars() {
        for (IbiscEntry e : allClasses.values()) {
            JarInfo j;
            if (!e.getModified() || (j = e.getJarInfo()) == null) continue;
            j.setModified(true);
        }
        for (int i = 0; i < jarFiles.size(); ++i) {
            JarInfo ji = jarFiles.get(i);
            if (!ji.getModified()) continue;
            String name = ji.getName();
            File temp = null;
            try {
                File file = new File(name);
                File canonicalDir = file.getCanonicalFile().getParentFile();
                temp = File.createTempFile("Ibisc_", null, canonicalDir);
                FileOutputStream out = new FileOutputStream(temp);
                BufferedOutputStream bo = new BufferedOutputStream(out, 16384);
                ZipOutputStream zo = new ZipOutputStream(bo);
                zo.setMethod(8);
                if (!compress) {
                    zo.setLevel(0);
                }
                Enumeration<JarEntryInfo> iitems = ji.entries();
                while (iitems.hasMoreElements()) {
                    JarEntryInfo ient = iitems.nextElement();
                    ient.write(zo);
                }
                zo.close();
                Ibisc.rename(file, temp, canonicalDir);
            }
            catch (Exception e) {
                System.err.println("Ibisc: got exception while writing " + name + ": " + e);
                e.printStackTrace();
                if (temp != null) {
                    temp.delete();
                }
                System.exit(1);
            }
            ji.setModified(false);
        }
    }

    static void writeAll() {
        Ibisc.writeClasses();
        Ibisc.writeJars();
    }

    static void readAll(ArrayList<String> leftArgs) {
        for (String arg : leftArgs) {
            File f = new File(arg);
            if (f.isDirectory()) {
                Ibisc.getClassesFromDirectory(f, "");
                continue;
            }
            if (arg.endsWith(".class")) {
                Ibisc.getClassFromClassFile(arg);
                continue;
            }
            if (arg.endsWith(".jar")) {
                Ibisc.getClassesFromJarFile(f, arg);
                continue;
            }
            System.err.println("Ibisc: illegal argument: " + arg + " is not a jar or class file.");
            System.exit(1);
        }
    }

    private static String usage() {
        String rval = "Usage: java ibis.compile.Ibisc [-verbose] [-verify] [-keep] [-help] ";
        for (int i = 0; i < ibiscComponents.size(); ++i) {
            IbiscComponent ic = ibiscComponents.get(i);
            String s = ic.getUsageString();
            if (s.equals("")) continue;
            rval = rval + s + " ";
        }
        return rval + " <jar-file|dir|class-file>+";
    }

    public static void main(String[] args) {
        IbiscComponent ic;
        boolean keep = false;
        boolean verify = false;
        boolean help = false;
        ArrayList<String> leftArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v") || args[i].equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-no-verbose")) {
                verbose = false;
                continue;
            }
            if (args[i].equals("-d") || args[i].equals("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].equals("-no-debug")) {
                debug = false;
                continue;
            }
            if (args[i].equals("-verify")) {
                verify = true;
                continue;
            }
            if (args[i].equals("-no-verify")) {
                verify = false;
                continue;
            }
            if (args[i].equals("-keep")) {
                keep = true;
                continue;
            }
            if (args[i].equals("-no-keep")) {
                keep = false;
                continue;
            }
            if (args[i].equals("-compress")) {
                compress = true;
                continue;
            }
            if (args[i].equals("-no-compress")) {
                compress = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("--help") || args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("/?")) {
                help = true;
                continue;
            }
            leftArgs.add(args[i]);
        }
        bcelWrapper = new BCELWrapper(leftArgs);
        asmWrapper = new ASMWrapper(leftArgs);
        ClassLister clstr = ClassLister.getClassLister(null);
        List clcomponents = clstr.getClassList("Ibisc-Component", IbiscComponent.class);
        ArrayList<IbiscComponent> components = new ArrayList<IbiscComponent>();
        for (Class cl : clcomponents) {
            ic = null;
            try {
                ic = (IbiscComponent)cl.newInstance();
                ic.setVerbose(verbose);
                ic.fromIbisc = true;
                ic.setKeep(keep);
                if (ic.processArgs(leftArgs)) {
                    components.add(ic);
                }
                ibiscComponents.add(ic);
            }
            catch (Exception e) {
                System.err.println("Ibisc: warning: could not instantiate " + cl.getName());
            }
        }
        for (String arg : leftArgs) {
            if (!arg.startsWith("-")) continue;
            System.err.println("Ibisc: unrecognized argument: " + arg);
            System.err.println(Ibisc.usage());
            System.exit(1);
        }
        if (help) {
            System.out.println(Ibisc.usage());
            System.exit(0);
        }
        if (leftArgs.size() == 0) {
            System.err.println("Ibisc: no files to process?");
            System.err.println(Ibisc.usage());
            System.exit(1);
        }
        int szm1 = components.size() - 1;
        for (int i = 0; i < szm1; ++i) {
            ic = (IbiscComponent)components.get(i);
            String cn = ic.getClass().getName();
            if (!cn.equals("ibis.io.rewriter.IOGenerator") && !cn.equals("ibis.io.rewriter.ASMIOGenerator")) continue;
            components.set(i, (IbiscComponent)components.get(szm1));
            components.set(szm1, ic);
            break;
        }
        if (components.size() == 0) {
            System.err.println("Ibisc: warning: no components found!");
        }
        String wrapperKind = null;
        for (int i = 0; i < components.size(); ++i) {
            IbiscComponent ic2 = (IbiscComponent)components.get(i);
            String knd = ic2.rewriterImpl();
            if (wrapperKind == null || !knd.equals(wrapperKind)) {
                if (wrapperKind != null) {
                    Ibisc.writeAll();
                }
                allClasses.clear();
                wrapperKind = knd;
                if (knd.equals("BCEL")) {
                    w = bcelWrapper;
                } else if (knd.equals("ASM")) {
                    w = asmWrapper;
                } else {
                    System.err.println("Ibisc: component " + ic2.getClass().getName() + ": unsupported bytecode rewriter: " + knd);
                }
                Ibisc.readAll(leftArgs);
            }
            ic2.setWrapper(w);
            System.out.println("Ibisc: applying rewriter " + ic2.getClass().getName() + " to " + allClasses.size() + " classes.");
            ic2.processClasses(allClasses);
            if (!verify) continue;
            Ibisc.verifyClasses(ic2);
        }
        Ibisc.writeAll();
    }

    static {
        ibiscComponents = new ArrayList();
    }
}

