/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.nio.NioAccumulator;
import ibis.ipl.impl.nio.NioAccumulatorConnection;
import ibis.ipl.impl.nio.NioSendPort;
import ibis.ipl.impl.nio.SendBuffer;
import ibis.ipl.impl.nio.SendReceiveThread;
import ibis.ipl.impl.nio.ThreadNioAccumulatorConnection;
import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectableChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThreadNioAccumulator
extends NioAccumulator {
    static final int LOST_CONNECTION_SIZE = 8;
    private static Logger logger = LoggerFactory.getLogger(ThreadNioAccumulator.class);
    SendReceiveThread thread;

    ThreadNioAccumulator(NioSendPort port, SendReceiveThread thread) {
        super(port);
        this.thread = thread;
    }

    @Override
    NioAccumulatorConnection newConnection(GatheringByteChannel channel, ReceivePortIdentifier peer) throws IOException {
        SelectableChannel sChannel = (SelectableChannel)((Object)channel);
        sChannel.configureBlocking(false);
        if (logger.isDebugEnabled()) {
            logger.debug("creating new ThreadNioAccumulatorConnection");
        }
        return new ThreadNioAccumulatorConnection(this.port, this.thread, channel, peer);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    boolean doSend(SendBuffer buffer) throws IOException {
        if (ThreadNioAccumulator.logger.isDebugEnabled()) {
            ThreadNioAccumulator.logger.debug("doing send");
        }
        if (this.nrOfConnections == 0) {
            if (ThreadNioAccumulator.logger.isInfoEnabled()) {
                ThreadNioAccumulator.logger.info("no connections to send to");
            }
            return true;
        }
        if (this.nrOfConnections == 1) {
            if (ThreadNioAccumulator.logger.isDebugEnabled()) {
                ThreadNioAccumulator.logger.debug("sending to one(1) connection");
            }
            connection = (ThreadNioAccumulatorConnection)this.connections[0];
            try {
                connection.addToThreadSendList(buffer);
            }
            catch (IOException e) {
                this.port.lostConnection(connection.target, e);
                if (!ThreadNioAccumulator.logger.isInfoEnabled()) ** GOTO lbl37
                ThreadNioAccumulator.logger.error("(only) connection lost");
                return false;
            }
        } else {
            if (ThreadNioAccumulator.logger.isDebugEnabled()) {
                ThreadNioAccumulator.logger.debug("sending to " + this.nrOfConnections + " connections");
            }
            copies = SendBuffer.replicate(buffer, this.nrOfConnections);
            for (i = 0; i < this.nrOfConnections; ++i) {
                connection = (ThreadNioAccumulatorConnection)this.connections[i];
                try {
                    connection.addToThreadSendList(copies[i]);
                    continue;
                }
                catch (IOException e) {
                    if (ThreadNioAccumulator.logger.isInfoEnabled()) {
                        ThreadNioAccumulator.logger.info("connection lost");
                    }
                    SendBuffer.recycle(copies[i]);
                    this.port.lostConnection(connection.target, e);
                    --this.nrOfConnections;
                    this.connections[i] = this.connections[this.nrOfConnections];
                    this.connections[this.nrOfConnections] = null;
                    --i;
                }
            }
        }
lbl37:
        // 3 sources

        if (ThreadNioAccumulator.logger.isDebugEnabled()) {
            ThreadNioAccumulator.logger.debug("done send");
        }
        return false;
    }

    @Override
    void doFlush() throws IOException {
    }
}

