/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.io.DataOutputStream;
import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.nio.Config;
import ibis.ipl.impl.nio.NioAccumulatorConnection;
import ibis.ipl.impl.nio.NioSendPort;
import ibis.ipl.impl.nio.SendBuffer;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.GatheringByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NioAccumulator
extends DataOutputStream
implements Config {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    static final int INITIAL_CONNECTIONS_SIZE = 8;
    private static Logger logger = LoggerFactory.getLogger(NioAccumulator.class);
    private SendBuffer buffer;
    private ByteBuffer bytes;
    private CharBuffer chars;
    private ShortBuffer shorts;
    private IntBuffer ints;
    private LongBuffer longs;
    private FloatBuffer floats;
    private DoubleBuffer doubles;
    NioAccumulatorConnection[] connections = new NioAccumulatorConnection[8];
    int nrOfConnections = 0;
    NioSendPort port;
    long count = 0L;

    protected NioAccumulator(NioSendPort port) {
        this.port = port;
        this.buffer = SendBuffer.get();
        this.bytes = this.buffer.bytes;
        this.chars = this.buffer.chars;
        this.shorts = this.buffer.shorts;
        this.ints = this.buffer.ints;
        this.longs = this.buffer.longs;
        this.floats = this.buffer.floats;
        this.doubles = this.buffer.doubles;
    }

    public int bufferSize() {
        return 6144;
    }

    public synchronized long bytesWritten() {
        return this.count;
    }

    public synchronized void resetBytesWritten() {
        this.count = 0L;
    }

    public synchronized long getAndResetBytesWritten() {
        long result = this.count;
        this.count = 0L;
        return result;
    }

    synchronized NioAccumulatorConnection add(GatheringByteChannel channel, ReceivePortIdentifier receiver) throws IOException {
        NioAccumulatorConnection c;
        if (this.nrOfConnections == this.connections.length) {
            NioAccumulatorConnection[] newConnections = new NioAccumulatorConnection[this.connections.length * 2];
            for (int i = 0; i < this.connections.length; ++i) {
                newConnections[i] = this.connections[i];
            }
            this.connections = newConnections;
        }
        this.connections[this.nrOfConnections] = c = this.newConnection(channel, receiver);
        ++this.nrOfConnections;
        return c;
    }

    synchronized void removeConnection(ReceivePortIdentifier receiver) throws IOException {
        for (int i = 0; i < this.nrOfConnections; ++i) {
            if (this.connections[i].target != receiver) continue;
            --this.nrOfConnections;
            this.connections[i] = this.connections[this.nrOfConnections];
            this.connections[this.nrOfConnections] = null;
            return;
        }
        throw new IOException("tried to remove non existing connections");
    }

    private synchronized void send() throws IOException {
        if (this.buffer.isEmpty()) {
            return;
        }
        this.buffer.flip();
        this.count += this.buffer.remaining();
        if (this.doSend(this.buffer)) {
            this.buffer.clear();
        } else {
            this.buffer = SendBuffer.get();
            this.bytes = this.buffer.bytes;
            this.chars = this.buffer.chars;
            this.shorts = this.buffer.shorts;
            this.ints = this.buffer.ints;
            this.longs = this.buffer.longs;
            this.floats = this.buffer.floats;
            this.doubles = this.buffer.doubles;
        }
    }

    public synchronized void flush() throws IOException {
        this.send();
        this.doFlush();
    }

    public synchronized void close() throws IOException {
        if (!this.buffer.isEmpty()) {
            this.doSend(this.buffer);
            this.doFlush();
        } else {
            SendBuffer.recycle(this.buffer);
            this.doFlush();
        }
        this.buffer = null;
    }

    public void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.writeByte((byte)1);
        } else {
            this.writeByte((byte)0);
        }
    }

    public void writeByte(byte value) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("writeByte(" + value + ")");
        }
        try {
            this.bytes.put(value);
        }
        catch (BufferOverflowException e) {
            this.send();
            this.bytes.put(value);
        }
    }

    public void write(int value) throws IOException {
        this.writeByte((byte)value);
    }

    public void writeChar(char value) throws IOException {
        try {
            this.chars.put(value);
        }
        catch (BufferOverflowException e) {
            this.send();
            this.chars.put(value);
        }
    }

    public void writeShort(short value) throws IOException {
        try {
            this.shorts.put(value);
        }
        catch (BufferOverflowException e) {
            this.send();
            this.shorts.put(value);
        }
    }

    public void writeInt(int value) throws IOException {
        try {
            this.ints.put(value);
        }
        catch (BufferOverflowException e) {
            this.send();
            this.ints.put(value);
        }
    }

    public void writeLong(long value) throws IOException {
        try {
            this.longs.put(value);
        }
        catch (BufferOverflowException e) {
            this.send();
            this.longs.put(value);
        }
    }

    public void writeFloat(float value) throws IOException {
        try {
            this.floats.put(value);
        }
        catch (BufferOverflowException e) {
            this.send();
            this.floats.put(value);
        }
    }

    public void writeDouble(double value) throws IOException {
        try {
            this.doubles.put(value);
        }
        catch (BufferOverflowException e) {
            this.send();
            this.doubles.put(value);
        }
    }

    public void writeArray(boolean[] array, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            if (array[i]) {
                this.writeByte((byte)1);
                continue;
            }
            this.writeByte((byte)0);
        }
    }

    public void writeArray(byte[] array, int off, int len) throws IOException {
        if (logger.isDebugEnabled()) {
            String message = "NioAccumulator.writeArray(byte[], off = " + off + " len = " + len + ") Contents: ";
            for (int i = off; i < off + len; ++i) {
                message = message + array[i] + " ";
            }
            if (logger.isDebugEnabled()) {
                logger.debug(message);
            }
        }
        try {
            this.bytes.put(array, off, len);
        }
        catch (BufferOverflowException e) {
            while (len > 0) {
                if (!this.bytes.hasRemaining()) {
                    this.send();
                }
                int size = Math.min(len, this.bytes.remaining());
                this.bytes.put(array, off, size);
                off += size;
                len -= size;
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.writeArray(b, off, len);
    }

    public void writeArray(char[] array, int off, int len) throws IOException {
        try {
            this.chars.put(array, off, len);
        }
        catch (BufferOverflowException e) {
            while (len > 0) {
                if (!this.chars.hasRemaining()) {
                    this.send();
                }
                int size = Math.min(len, this.chars.remaining());
                this.chars.put(array, off, size);
                off += size;
                len -= size;
            }
        }
    }

    public void writeArray(short[] array, int off, int len) throws IOException {
        try {
            this.shorts.put(array, off, len);
        }
        catch (BufferOverflowException e) {
            while (len > 0) {
                if (!this.shorts.hasRemaining()) {
                    this.send();
                }
                int size = Math.min(len, this.shorts.remaining());
                this.shorts.put(array, off, size);
                off += size;
                len -= size;
            }
        }
    }

    public void writeArray(int[] array, int off, int len) throws IOException {
        try {
            this.ints.put(array, off, len);
        }
        catch (BufferOverflowException e) {
            while (len > 0) {
                if (!this.ints.hasRemaining()) {
                    this.send();
                }
                int size = Math.min(len, this.ints.remaining());
                this.ints.put(array, off, size);
                off += size;
                len -= size;
            }
        }
    }

    public void writeArray(long[] array, int off, int len) throws IOException {
        try {
            this.longs.put(array, off, len);
        }
        catch (BufferOverflowException e) {
            while (len > 0) {
                if (!this.longs.hasRemaining()) {
                    this.send();
                }
                int size = Math.min(len, this.longs.remaining());
                this.longs.put(array, off, size);
                off += size;
                len -= size;
            }
        }
    }

    public void writeArray(float[] array, int off, int len) throws IOException {
        try {
            this.floats.put(array, off, len);
        }
        catch (BufferOverflowException e) {
            while (len > 0) {
                if (!this.floats.hasRemaining()) {
                    this.send();
                }
                int size = Math.min(len, this.floats.remaining());
                this.floats.put(array, off, size);
                off += size;
                len -= size;
            }
        }
    }

    public void writeArray(double[] array, int off, int len) throws IOException {
        try {
            this.doubles.put(array, off, len);
        }
        catch (BufferOverflowException e) {
            while (len > 0) {
                if (!this.doubles.hasRemaining()) {
                    this.send();
                }
                int size = Math.min(len, this.doubles.remaining());
                this.doubles.put(array, off, size);
                off += size;
                len -= size;
            }
        }
    }

    public void writeByteBuffer(ByteBuffer b) throws IOException {
        try {
            this.bytes.put(b);
        }
        catch (BufferOverflowException e) {
            int size;
            for (int len = b.limit() - b.position(); len > 0; len -= size) {
                if (!this.bytes.hasRemaining()) {
                    this.send();
                }
                size = Math.min(len, this.bytes.remaining());
                b.limit(b.position() + size);
                b.put(b);
            }
        }
    }

    abstract NioAccumulatorConnection newConnection(GatheringByteChannel var1, ReceivePortIdentifier var2) throws IOException;

    abstract boolean doSend(SendBuffer var1) throws IOException;

    abstract void doFlush() throws IOException;
}

