/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import ibis.io.rewriter.Failed;
import ibis.util.RunProcess;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Scan {
    public static final int BATCH_SIZE = 20;
    private static Vector<String> classes = new Vector();
    private static Vector<Failed> failed = new Vector();

    public static String[] getClassPath() {
        int i = 0;
        String cp = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
        String[] entries = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            entries[i++] = st.nextToken();
        }
        return entries;
    }

    public static String path2qualified(String name) {
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - 6);
        }
        name = name.replace('/', '.');
        return name;
    }

    public static void handleClasses(String[] class_names) {
        int result = 0;
        RunProcess p = null;
        try {
            String command = "java ibis.io.rewriter.IOGenerator ";
            for (int i = 0; i < 20; ++i) {
                if (class_names[i] == null) continue;
                command = command + class_names[i] + " ";
            }
            p = new RunProcess(new String[]{command});
            p.run();
            result = p.getExitStatus();
        }
        catch (Exception e) {
            result = -1;
        }
        if (result != 0) {
            int i;
            Failed f = new Failed();
            f.class_names = class_names;
            f.error = new StringBuffer("");
            f.exit = result;
            f.error.append("stdout:\n");
            f.error.append("      : ");
            if (p != null) {
                byte[] o = p.getStdout();
                for (i = 0; i < o.length; ++i) {
                    f.error.append((char)o[i]);
                    if (o[i] != 10) continue;
                    f.error.append("      : ");
                }
            }
            f.error.append("\nstderr: \n");
            f.error.append("      : ");
            if (p != null) {
                byte[] e = p.getStderr();
                for (i = 0; i < e.length; ++i) {
                    f.error.append((char)e[i]);
                    if (e[i] != 10) continue;
                    f.error.append("      : ");
                }
            }
            failed.add(f);
        }
    }

    public static void scanJar(String jarfile) throws IOException {
        JarFile jarf = new JarFile(jarfile);
        Enumeration<JarEntry> e = jarf.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            classes.add(Scan.path2qualified(entry.getName()));
        }
        jarf.close();
        System.out.println("Jarfile " + jarfile + " contains " + classes.size() + " classes.");
        System.out.println("Starting rewrite");
        long start = System.currentTimeMillis();
        int total = classes.size();
        String[] batch = new String[20];
        for (int i = 0; i < total; i += 20) {
            for (int j = 0; j < 20; ++j) {
                if (i + j < total) {
                    batch[j] = classes.get(i + j);
                    System.out.println(batch[j] + " (" + (i + j) + " of " + total + ")");
                    continue;
                }
                batch[j] = null;
            }
            long temp1 = System.currentTimeMillis();
            Scan.handleClasses(batch);
            long temp2 = System.currentTimeMillis();
            System.out.println("Handled in " + (double)(temp2 - temp1) / 1000.0 + " seconds.");
        }
        long end = System.currentTimeMillis();
        System.out.println("Done rewrite in " + (double)(end - start) / 1000.0 + " seconds.");
        total = failed.size();
        if (total > 0) {
            System.out.println("The following batch failed to rewrite properly:");
            for (int i = 0; i < total; ++i) {
                Failed f = failed.get(i);
                for (int j = 0; j < 20; ++j) {
                    System.out.println(f.class_names[j]);
                }
                System.out.println("errorcode " + f.exit + "\n" + f.error.toString());
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args[0].endsWith(".jar")) {
                Scan.scanJar(args[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

