/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import ibis.io.rewriter.IOGenerator;
import ibis.io.rewriter.RewriterConstants;
import ibis.io.rewriter.SerializationInfo;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.StackMapTable;
import org.apache.bcel.classfile.StackMapTableEntry;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.Type;

class CodeGenerator
implements RewriterConstants {
    protected JavaClass clazz;
    protected ClassGen gen;
    protected String classname;
    protected String super_classname;
    protected JavaClass super_class;
    protected boolean super_is_serializable;
    protected boolean super_is_ibis_serializable;
    protected boolean super_has_ibis_constructor;
    protected boolean is_externalizable;
    protected boolean has_serial_persistent_fields;
    protected boolean has_final_fields;
    protected Field[] fields;
    protected Method[] methods;
    protected InstructionFactory factory;
    protected ConstantPoolGen constantpool;
    protected IOGenerator generator;
    private boolean is_abstract;
    InstructionHandle[] localStart = new InstructionHandle[10];

    public static JavaClass lookupClass(String name) {
        try {
            return Repository.lookupClass((String)name);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Warning: class " + name + " not found");
            return null;
        }
    }

    CodeGenerator(IOGenerator generator, JavaClass cl) {
        this.generator = generator;
        this.clazz = cl;
        this.gen = new ClassGen(this.clazz);
        this.classname = this.clazz.getClassName();
        this.super_classname = this.clazz.getSuperclassName();
        this.super_class = CodeGenerator.lookupClass(this.super_classname);
        this.fields = this.gen.getFields();
        this.methods = this.gen.getMethods();
        this.factory = new InstructionFactory(this.gen);
        this.constantpool = this.gen.getConstantPool();
        this.versionUID();
        Arrays.sort(this.fields, SerializationInfo.fieldComparator);
        this.super_is_serializable = SerializationInfo.isSerializable(this.super_class);
        this.is_externalizable = SerializationInfo.isExternalizable(cl);
        this.is_abstract = cl.isAbstract();
        this.super_is_ibis_serializable = SerializationInfo.isIbisSerializable(this.super_class);
        this.super_has_ibis_constructor = SerializationInfo.hasIbisConstructor(this.super_class);
        this.has_serial_persistent_fields = SerializationInfo.hasSerialPersistentFields(this.fields);
        this.has_final_fields = SerializationInfo.hasFinalFields(this.fields);
    }

    private void versionUID() {
        for (int i = 0; i < this.fields.length; ++i) {
            Field f = this.fields[i];
            if (!f.getName().equals("serialVersionUID") || !f.isFinal() || !f.isStatic()) continue;
            return;
        }
        long uid = 0L;
        uid = SerializationInfo.getSerialVersionUID(this.classname, this.clazz);
        if (uid != 0L) {
            FieldGen f = new FieldGen(26, (Type)Type.LONG, "serialVersionUID", this.constantpool);
            f.setInitValue(uid);
            this.gen.addField(f.getField());
            this.fields = this.gen.getFields();
        }
    }

    private Instruction createGeneratedWriteObjectInvocation(String name, short invmode) {
        return this.factory.createInvoke(name, "generated_WriteObject", (Type)Type.VOID, ibis_output_stream_arrtp, invmode);
    }

    private Instruction createGeneratedDefaultReadObjectInvocation(String name, InstructionFactory fac, short invmode) {
        return fac.createInvoke(name, "generated_DefaultReadObject", (Type)Type.VOID, new Type[]{ibis_input_stream, Type.INT}, invmode);
    }

    private Instruction createInitInvocation(String name, InstructionFactory f) {
        return f.createInvoke(name, "<init>", (Type)Type.VOID, ibis_input_stream_arrtp, (short)183);
    }

    private Instruction createGeneratedDefaultWriteObjectInvocation(String name) {
        return this.factory.createInvoke(name, "generated_DefaultWriteObject", (Type)Type.VOID, new Type[]{ibis_output_stream, Type.INT}, (short)183);
    }

    private Instruction createWriteObjectInvocation() {
        return this.factory.createInvoke(this.classname, "writeObject", (Type)Type.VOID, new Type[]{sun_output_stream}, (short)183);
    }

    private int getClassDepth(JavaClass cl) {
        if (!SerializationInfo.isSerializable(cl)) {
            return 0;
        }
        return 1 + this.getClassDepth(CodeGenerator.lookupClass(cl.getSuperclassName()));
    }

    void generateEmptyMethods() {
        if (this.has_serial_persistent_fields) {
            return;
        }
        if (this.generator.isVerbose()) {
            System.out.println("  Generating empty methods for class : " + this.classname);
            System.out.println("    " + this.classname + " implements java.io.Serializable -> adding " + "ibis.io.Serializable");
        }
        this.gen.addInterface("ibis.io.Serializable");
        InstructionList il = new InstructionList();
        il.append((Instruction)new RETURN());
        int flags = 1 | (this.gen.isFinal() ? 16 : 0);
        MethodGen write_method = new MethodGen(flags, (Type)Type.VOID, ibis_output_stream_arrtp, new String[]{"os"}, "generated_WriteObject", this.classname, il, this.constantpool);
        write_method.addException("java.io.IOException");
        this.gen.addMethod(write_method.getMethod());
        il = new InstructionList();
        il.append((Instruction)new RETURN());
        MethodGen default_write_method = new MethodGen(flags, (Type)Type.VOID, new Type[]{ibis_output_stream, Type.INT}, new String[]{"os", "lvl"}, "generated_DefaultWriteObject", this.classname, il, this.constantpool);
        default_write_method.addException("java.io.IOException");
        this.gen.addMethod(default_write_method.getMethod());
        il = new InstructionList();
        il.append((Instruction)new RETURN());
        MethodGen default_read_method = new MethodGen(flags, (Type)Type.VOID, new Type[]{ibis_input_stream, Type.INT}, new String[]{"os", "lvl"}, "generated_DefaultReadObject", this.classname, il, this.constantpool);
        default_read_method.addException("java.io.IOException");
        default_read_method.addException("java.lang.ClassNotFoundException");
        this.gen.addMethod(default_read_method.getMethod());
        if (this.is_externalizable || !this.super_is_serializable || this.generator.forceGeneratedCalls() || this.super_has_ibis_constructor) {
            il = new InstructionList();
            il.append((Instruction)new RETURN());
            MethodGen read_cons = new MethodGen(1, (Type)Type.VOID, ibis_input_stream_arrtp, new String[]{"is"}, "<init>", this.classname, il, this.constantpool);
            read_cons.addException("java.io.IOException");
            read_cons.addException("java.lang.ClassNotFoundException");
            this.gen.addMethod(read_cons.getMethod());
        } else if (SerializationInfo.hasReadObject(this.methods)) {
            il = new InstructionList();
            il.append((Instruction)new RETURN());
            MethodGen readobjectWrapper = new MethodGen(1, (Type)Type.VOID, ibis_input_stream_arrtp, new String[]{"is"}, "$readObjectWrapper$", this.classname, il, this.constantpool);
            readobjectWrapper.addException("java.io.IOException");
            readobjectWrapper.addException("java.lang.ClassNotFoundException");
            this.gen.addMethod(readobjectWrapper.getMethod());
        }
        JavaClass newclazz = this.gen.getJavaClass();
        this.generator.replace(this.clazz, newclazz);
        this.clazz = newclazz;
    }

    private InstructionList writeInstructions(Field field) {
        String field_sig = field.getSignature();
        Type field_type = Type.getType((String)field_sig);
        SerializationInfo info = SerializationInfo.getSerializationInfo(field_type);
        Type t = info.tp;
        InstructionList temp = new InstructionList();
        if (!info.primitive) {
            t = Type.getType((String)field_sig);
        }
        temp.append((Instruction)new ALOAD(1));
        temp.append((Instruction)new ALOAD(0));
        temp.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), t, (short)180));
        temp.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", info.write_name, (Type)Type.VOID, info.param_tp_arr, (short)182));
        return temp;
    }

    private InstructionList readInstructions(Field field, boolean from_constructor) {
        String field_sig = field.getSignature();
        Type field_type = Type.getType((String)field_sig);
        SerializationInfo info = SerializationInfo.getSerializationInfo(field_type);
        Type t = info.tp;
        InstructionList temp = new InstructionList();
        if (!info.primitive) {
            t = Type.getType((String)field_sig);
        }
        if (from_constructor || !field.isFinal()) {
            temp.append((Instruction)new ALOAD(0));
            temp.append((Instruction)new ALOAD(1));
            temp.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", info.read_name, info.tp, Type.NO_ARGS, (short)182));
            if (!info.primitive) {
                temp.append((Instruction)this.factory.createCheckCast((ReferenceType)t));
            }
            temp.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), t, (short)181));
        } else {
            Type[] typeArray;
            temp.append((Instruction)new ALOAD(1));
            temp.append((Instruction)new ALOAD(0));
            int ind = this.constantpool.addString(field.getName());
            temp.append((Instruction)new LDC(ind));
            ind = this.constantpool.addString(this.classname);
            temp.append((Instruction)new LDC(ind));
            if (!info.primitive) {
                int ind2 = this.constantpool.addString(field_sig);
                temp.append((Instruction)new LDC(ind2));
            }
            String string = info.final_read_name;
            if (info.primitive) {
                Type[] typeArray2 = new Type[3];
                typeArray2[0] = Type.OBJECT;
                typeArray2[1] = Type.STRING;
                typeArray = typeArray2;
                typeArray2[2] = Type.STRING;
            } else {
                Type[] typeArray3 = new Type[4];
                typeArray3[0] = Type.OBJECT;
                typeArray3[1] = Type.STRING;
                typeArray3[2] = Type.STRING;
                typeArray = typeArray3;
                typeArray3[3] = Type.STRING;
            }
            temp.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", string, (Type)Type.VOID, typeArray, (short)182));
        }
        return temp;
    }

    private String writeCallName(String name) {
        return "writeArray" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private InstructionList writeReferenceField(Field field) {
        Type field_type = Type.getType((String)field.getSignature());
        InstructionList write_il = new InstructionList();
        boolean isfinal = false;
        boolean isarray = false;
        JavaClass field_class = null;
        String basicname = null;
        if (this.generator.isVerbose()) {
            System.out.println("    writing reference field " + field.getName() + " of type " + field_type.getSignature());
        }
        if (field_type instanceof ObjectType) {
            field_class = CodeGenerator.lookupClass(((ObjectType)field_type).getClassName());
            if (field_class != null && field_class.isFinal()) {
                isfinal = true;
            }
        } else if (field_type instanceof ArrayType) {
            isarray = true;
            Type el_type = ((ArrayType)field_type).getElementType();
            if (el_type instanceof ObjectType) {
                field_class = CodeGenerator.lookupClass(((ObjectType)el_type).getClassName());
                if (field_class != null && field_class.isFinal()) {
                    isfinal = true;
                }
            } else if (el_type instanceof BasicType) {
                basicname = el_type.toString();
            }
        }
        if (basicname != null || isfinal && (SerializationInfo.hasIbisConstructor(field_class) || SerializationInfo.isSerializable(field_class) && this.generator.forceGeneratedCalls())) {
            write_il.append((Instruction)new ICONST(0));
            write_il.append((Instruction)new ISTORE(2));
            if (this.localStart[2] == null) {
                this.localStart[2] = write_il.getEnd();
            }
            write_il.append((Instruction)new ICONST(0));
            write_il.append((Instruction)new ISTORE(3));
            if (this.localStart[3] == null) {
                this.localStart[3] = write_il.getEnd();
            }
            write_il.append((Instruction)new ICONST(0));
            write_il.append((Instruction)new ISTORE(4));
            if (this.localStart[4] == null) {
                this.localStart[4] = write_il.getEnd();
            }
            write_il.append((Instruction)new ACONST_NULL());
            write_il.append((Instruction)new ALOAD(1));
            write_il.append((Instruction)this.factory.createFieldAccess("ibis.io.IbisSerializationOutputStream", "replacer", (Type)new ObjectType("ibis.io.Replacer"), (short)180));
            IF_ACMPEQ replacertest = new IF_ACMPEQ(null);
            write_il.append((BranchInstruction)replacertest);
            write_il.append(this.writeInstructions(field));
            GOTO toEnd = new GOTO(null);
            write_il.append((BranchInstruction)toEnd);
            replacertest.setTarget(write_il.append((Instruction)new ALOAD(1)));
            write_il.append((Instruction)new ALOAD(0));
            write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
            if (basicname != null) {
                write_il.append((Instruction)this.factory.createFieldAccess("ibis.io.Constants", "TYPE_" + basicname.toUpperCase(), (Type)Type.INT, (short)178));
                write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeKnownArrayHeader", (Type)Type.INT, new Type[]{Type.OBJECT, Type.INT}, (short)182));
            } else {
                write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeKnownObjectHeader", (Type)Type.INT, new Type[]{Type.OBJECT}, (short)182));
            }
            write_il.append((Instruction)new ISTORE(2));
            write_il.append((Instruction)new ILOAD(2));
            write_il.append((Instruction)new ICONST(1));
            IF_ICMPNE ifcmp = new IF_ICMPNE(null);
            write_il.append((BranchInstruction)ifcmp);
            if (isarray) {
                write_il.append((Instruction)new ALOAD(1));
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                write_il.append((Instruction)new ARRAYLENGTH());
                write_il.append((Instruction)new DUP());
                write_il.append((Instruction)new ISTORE(3));
                write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeInt", (Type)Type.VOID, new Type[]{Type.INT}, (short)182));
                if (basicname != null) {
                    write_il.append((Instruction)new ALOAD(1));
                    write_il.append((Instruction)new ALOAD(0));
                    write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    write_il.append((Instruction)new ICONST(0));
                    write_il.append((Instruction)new ILOAD(3));
                    write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", this.writeCallName(basicname), (Type)Type.VOID, new Type[]{field_type, Type.INT, Type.INT}, (short)182));
                } else {
                    write_il.append((Instruction)new ICONST(0));
                    write_il.append((Instruction)new ISTORE(4));
                    GOTO gto = new GOTO(null);
                    write_il.append((BranchInstruction)gto);
                    InstructionHandle loop_body_start = write_il.append((Instruction)new ALOAD(1));
                    write_il.append((Instruction)new ALOAD(0));
                    write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    write_il.append((Instruction)new ILOAD(4));
                    write_il.append((Instruction)new AALOAD());
                    write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeKnownObjectHeader", (Type)Type.INT, new Type[]{Type.OBJECT}, (short)182));
                    write_il.append((Instruction)new ISTORE(2));
                    write_il.append((Instruction)new ILOAD(2));
                    write_il.append((Instruction)new ICONST(1));
                    IF_ICMPNE ifcmp1 = new IF_ICMPNE(null);
                    write_il.append((BranchInstruction)ifcmp1);
                    write_il.append((Instruction)new ALOAD(0));
                    write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    write_il.append((Instruction)new ILOAD(4));
                    write_il.append((Instruction)new AALOAD());
                    write_il.append((Instruction)new ALOAD(1));
                    write_il.append(this.createGeneratedWriteObjectInvocation(field_class.getClassName(), (short)182));
                    ifcmp1.setTarget(write_il.append((Instruction)new IINC(4, 1)));
                    gto.setTarget(write_il.append((Instruction)new ILOAD(3)));
                    write_il.append((Instruction)new ILOAD(4));
                    write_il.append((BranchInstruction)new IF_ICMPGT(loop_body_start));
                }
            } else {
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                write_il.append((Instruction)new ALOAD(1));
                write_il.append(this.createGeneratedWriteObjectInvocation(field_class.getClassName(), (short)182));
            }
            InstructionHandle target = write_il.append((Instruction)new NOP());
            ifcmp.setTarget(target);
            toEnd.setTarget(target);
        } else {
            write_il.append(this.writeInstructions(field));
        }
        return write_il;
    }

    private InstructionList generateDefaultWrites(MethodGen write_gen) {
        Type field_type;
        Field field;
        int i;
        InstructionList write_il = new InstructionList();
        for (i = 0; i < this.fields.length; ++i) {
            field = this.fields[i];
            if (field.isStatic() || field.isTransient() || !((field_type = Type.getType((String)field.getSignature())) instanceof BasicType)) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    writing basic field " + field.getName() + " of type " + field.getSignature());
            }
            write_il.append(this.writeInstructions(field));
        }
        for (i = 0; i < this.fields.length; ++i) {
            field = this.fields[i];
            if (field.isStatic() || field.isTransient() || !((field_type = Type.getType((String)field.getSignature())) instanceof ReferenceType)) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    writing field " + field.getName() + " of type " + field.getSignature());
            }
            if (!field_type.equals((Object)Type.STRING) && !field_type.equals((Object)java_lang_class_type)) {
                write_il.append(this.writeReferenceField(field));
                continue;
            }
            write_il.append(this.writeInstructions(field));
        }
        return write_il;
    }

    private String readCallName(String name) {
        return "readArray" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private InstructionList readReferenceField(Field field, boolean from_constructor) {
        Type field_type = Type.getType((String)field.getSignature());
        InstructionList read_il = new InstructionList();
        boolean isfinal = false;
        boolean isarray = false;
        JavaClass field_class = null;
        String basicname = null;
        if (this.generator.isVerbose()) {
            System.out.println("    reading reference field " + field.getName() + " of type " + field_type.getSignature());
        }
        if (field_type instanceof ObjectType) {
            field_class = CodeGenerator.lookupClass(((ObjectType)field_type).getClassName());
            if (field_class != null && field_class.isFinal()) {
                isfinal = true;
            }
        } else if (field_type instanceof ArrayType) {
            isarray = true;
            Type el_type = ((ArrayType)field_type).getElementType();
            if (el_type instanceof ObjectType) {
                field_class = CodeGenerator.lookupClass(((ObjectType)el_type).getClassName());
                if (field_class != null && field_class.isFinal()) {
                    isfinal = true;
                }
            } else if (el_type instanceof BasicType) {
                basicname = el_type.toString();
            }
        }
        if (basicname != null || isfinal && (SerializationInfo.hasIbisConstructor(field_class) || SerializationInfo.isSerializable(field_class) && this.generator.forceGeneratedCalls())) {
            read_il.append((Instruction)new ALOAD(1));
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "readKnownTypeHeader", (Type)Type.INT, Type.NO_ARGS, (short)182));
            read_il.append((Instruction)new ISTORE(2));
            if (this.localStart[2] == null) {
                this.localStart[2] = read_il.getEnd();
            }
            read_il.append((Instruction)new ILOAD(2));
            read_il.append((Instruction)new ICONST(-1));
            IF_ICMPNE ifcmp = new IF_ICMPNE(null);
            read_il.append((BranchInstruction)ifcmp);
            if (isarray) {
                if (basicname != null) {
                    String callname = this.readCallName(basicname);
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", callname, field_type, Type.NO_ARGS, (short)182));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)181));
                } else {
                    Type el_type = ((ArrayType)field_type).getElementType();
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "readInt", (Type)Type.INT, Type.NO_ARGS, (short)182));
                    read_il.append((Instruction)new DUP());
                    read_il.append((Instruction)new ISTORE(3));
                    if (this.localStart[3] == null) {
                        this.localStart[3] = read_il.getEnd();
                    }
                    read_il.append(this.factory.createNewArray(el_type, (short)1));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)181));
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "addObjectToCycleCheck", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
                    read_il.append((Instruction)new ICONST(0));
                    read_il.append((Instruction)new ISTORE(4));
                    if (this.localStart[4] == null) {
                        this.localStart[4] = read_il.getEnd();
                    }
                    GOTO gto1 = new GOTO(null);
                    read_il.append((BranchInstruction)gto1);
                    InstructionHandle loop_body_start = read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "readKnownTypeHeader", (Type)Type.INT, Type.NO_ARGS, (short)182));
                    if (this.localStart[2] == null) {
                        this.localStart[2] = read_il.getEnd();
                    }
                    read_il.append((Instruction)new ISTORE(2));
                    read_il.append((Instruction)new ILOAD(2));
                    read_il.append((Instruction)new ICONST(-1));
                    IF_ICMPNE ifcmp1 = new IF_ICMPNE(null);
                    read_il.append((BranchInstruction)ifcmp1);
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    read_il.append((Instruction)new ILOAD(4));
                    read_il.append((Instruction)this.factory.createNew((ObjectType)el_type));
                    read_il.append((Instruction)new DUP());
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append(this.createInitInvocation(field_class.getClassName(), this.factory));
                    read_il.append((Instruction)new AASTORE());
                    GOTO gto2 = new GOTO(null);
                    read_il.append((BranchInstruction)gto2);
                    InstructionHandle cmp_goto2 = read_il.append((Instruction)new ILOAD(2));
                    ifcmp1.setTarget(cmp_goto2);
                    read_il.append((Instruction)new ICONST(0));
                    IF_ICMPEQ ifcmpeq2 = new IF_ICMPEQ(null);
                    read_il.append((BranchInstruction)ifcmpeq2);
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    read_il.append((Instruction)new ILOAD(4));
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)new ILOAD(2));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "getObjectFromCycleCheck", (Type)Type.OBJECT, new Type[]{Type.INT}, (short)182));
                    read_il.append((Instruction)this.factory.createCheckCast((ReferenceType)el_type));
                    read_il.append((Instruction)new AASTORE());
                    InstructionHandle target2 = read_il.append((Instruction)new NOP());
                    ifcmpeq2.setTarget(target2);
                    gto2.setTarget(target2);
                    read_il.append((Instruction)new IINC(4, 1));
                    gto1.setTarget(read_il.append((Instruction)new ILOAD(3)));
                    read_il.append((Instruction)new ILOAD(4));
                    read_il.append((BranchInstruction)new IF_ICMPGT(loop_body_start));
                }
            } else {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)this.factory.createNew((ObjectType)field_type));
                read_il.append((Instruction)new DUP());
                read_il.append((Instruction)new ALOAD(1));
                read_il.append(this.createInitInvocation(field_class.getClassName(), this.factory));
                read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)181));
            }
            GOTO gto = new GOTO(null);
            read_il.append((BranchInstruction)gto);
            InstructionHandle cmp_goto = read_il.append((Instruction)new ILOAD(2));
            ifcmp.setTarget(cmp_goto);
            read_il.append((Instruction)new ICONST(0));
            IF_ICMPEQ ifcmpeq = new IF_ICMPEQ(null);
            read_il.append((BranchInstruction)ifcmpeq);
            read_il.append((Instruction)new ALOAD(0));
            read_il.append((Instruction)new ALOAD(1));
            read_il.append((Instruction)new ILOAD(2));
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "getObjectFromCycleCheck", (Type)Type.OBJECT, new Type[]{Type.INT}, (short)182));
            read_il.append((Instruction)this.factory.createCheckCast((ReferenceType)field_type));
            read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)181));
            InstructionHandle target = read_il.append((Instruction)new NOP());
            ifcmpeq.setTarget(target);
            gto.setTarget(target);
        } else {
            read_il.append(this.readInstructions(field, from_constructor));
        }
        return read_il;
    }

    private InstructionHandle generateReadField(String tpname, Type tp, InstructionList read_il, GOTO gto, boolean from_constructor) {
        if (from_constructor || !this.has_final_fields) {
            InstructionHandle h = read_il.append((Instruction)new ALOAD(4));
            read_il.append((Instruction)new ALOAD(0));
            read_il.append((Instruction)new ALOAD(1));
            if (tpname.equals("")) {
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "readObject", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
            } else {
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "read" + tpname, tp, Type.NO_ARGS, (short)182));
            }
            read_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "set" + tpname, (Type)Type.VOID, new Type[]{Type.OBJECT, tp}, (short)182));
            read_il.append((BranchInstruction)gto);
            return h;
        }
        InstructionHandle h = read_il.append((Instruction)new ILOAD(5));
        read_il.append((CompoundInstruction)new PUSH(this.constantpool, 16));
        read_il.append((Instruction)new IAND());
        IFEQ eq = new IFEQ(null);
        read_il.append((BranchInstruction)eq);
        read_il.append((Instruction)new ALOAD(1));
        read_il.append((Instruction)new ALOAD(0));
        read_il.append((Instruction)new ALOAD(3));
        if (tpname.equals("")) {
            read_il.append((Instruction)new ALOAD(4));
            read_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getType", (Type)new ObjectType("java.lang.Class"), Type.NO_ARGS, (short)182));
            read_il.append((Instruction)this.factory.createInvoke("java.lang.Class", "getName", (Type)Type.STRING, Type.NO_ARGS, (short)182));
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "readFieldObject", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING, Type.STRING}, (short)182));
        } else {
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "readField" + tpname, (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)182));
        }
        GOTO gto2 = new GOTO(null);
        read_il.append((BranchInstruction)gto2);
        eq.setTarget(read_il.append((Instruction)new ALOAD(4)));
        read_il.append((Instruction)new ALOAD(0));
        read_il.append((Instruction)new ALOAD(1));
        if (tpname.equals("")) {
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "readObject", tp, Type.NO_ARGS, (short)182));
        } else {
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "read" + tpname, tp, Type.NO_ARGS, (short)182));
        }
        read_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "set" + tpname, (Type)Type.VOID, new Type[]{Type.OBJECT, tp}, (short)182));
        gto2.setTarget((InstructionHandle)read_il.append((BranchInstruction)gto));
        return h;
    }

    private InstructionList generateDefaultReads(boolean from_constructor, MethodGen read_gen) {
        Type field_type;
        Field field;
        int i;
        InstructionList read_il = new InstructionList();
        for (i = 0; i < this.fields.length; ++i) {
            field = this.fields[i];
            if (field.isStatic() || field.isTransient() || !((field_type = Type.getType((String)field.getSignature())) instanceof BasicType)) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    writing basic field " + field.getName() + " of type " + field_type.getSignature());
            }
            read_il.append(this.readInstructions(field, from_constructor));
        }
        for (i = 0; i < this.fields.length; ++i) {
            field = this.fields[i];
            if (field.isStatic() || field.isTransient()) continue;
            field_type = Type.getType((String)field.getSignature());
            if (this.generator.isVerbose()) {
                System.out.println("    writing field " + field.getName() + " of type " + field.getSignature());
            }
            if (!(field_type instanceof ReferenceType)) continue;
            if (!field_type.equals((Object)Type.STRING) && !field_type.equals((Object)java_lang_class_type)) {
                read_il.append(this.readReferenceField(field, from_constructor));
                continue;
            }
            read_il.append(this.readInstructions(field, from_constructor));
        }
        return read_il;
    }

    private JavaClass generateInstanceGenerator() {
        if (this.generator.isVerbose()) {
            System.out.println("  Generating InstanceGenerator class for " + this.classname);
        }
        String name = this.classname + "_ibis_io_Generator";
        ObjectType class_type = new ObjectType(this.classname);
        String classfilename = name.substring(name.lastIndexOf(46) + 1) + ".class";
        ClassGen iogenGen = new ClassGen(name, "ibis.io.Generator", classfilename, 49, null);
        InstructionFactory iogenFactory = new InstructionFactory(iogenGen);
        InstructionList il = new InstructionList();
        if (!this.is_externalizable && this.super_is_serializable && !this.super_has_ibis_constructor && !this.generator.forceGeneratedCalls()) {
            il.append((Instruction)new ALOAD(1));
            int ind = iogenGen.getConstantPool().addString(this.classname);
            il.append((Instruction)new LDC(ind));
            il.append((Instruction)iogenFactory.createInvoke("ibis.io.IbisSerializationInputStream", "create_uninitialized_object", (Type)Type.OBJECT, new Type[]{Type.STRING}, (short)182));
            il.append((Instruction)iogenFactory.createCheckCast((ReferenceType)class_type));
            il.append((Instruction)new ASTORE(2));
            il.append((Instruction)new ALOAD(1));
            il.append((Instruction)new ALOAD(2));
            ind = iogenGen.getConstantPool().addString(this.super_classname);
            il.append((Instruction)new LDC(ind));
            il.append((Instruction)iogenFactory.createInvoke("ibis.io.IbisSerializationInputStream", "readSerializableObject", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)182));
            if (SerializationInfo.hasReadObject(this.methods)) {
                il.append((Instruction)new ALOAD(2));
                il.append((Instruction)new ALOAD(1));
                il.append((Instruction)iogenFactory.createInvoke(this.classname, "$readObjectWrapper$", (Type)Type.VOID, ibis_input_stream_arrtp, (short)182));
            } else {
                int dpth = this.getClassDepth(this.clazz);
                il.append((Instruction)new ALOAD(2));
                il.append((Instruction)new ALOAD(1));
                il.append((Instruction)new SIPUSH((short)dpth));
                il.append(this.createGeneratedDefaultReadObjectInvocation(this.classname, iogenFactory, (short)182));
            }
            il.append((Instruction)new ALOAD(2));
        } else {
            il.append((Instruction)iogenFactory.createNew(class_type));
            il.append((Instruction)new DUP());
            il.append((Instruction)new ALOAD(1));
            il.append(this.createInitInvocation(this.classname, iogenFactory));
        }
        il.append((Instruction)new ARETURN());
        MethodGen method = new MethodGen(17, (Type)Type.OBJECT, ibis_input_stream_arrtp, new String[]{"is"}, "generated_newInstance", name, il, iogenGen.getConstantPool());
        method.setMaxStack(3);
        method.setMaxLocals();
        method.addException("java.io.IOException");
        method.addException("java.lang.ClassNotFoundException");
        iogenGen.addMethod(method.getMethod());
        il = new InstructionList();
        il.append((Instruction)new ALOAD(0));
        il.append((Instruction)iogenFactory.createInvoke("ibis.io.Generator", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append((Instruction)new RETURN());
        method = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, null, "<init>", name, il, iogenGen.getConstantPool());
        method.setMaxStack(1);
        method.setMaxLocals();
        iogenGen.addMethod(method.getMethod());
        return iogenGen.getJavaClass();
    }

    void generateCode() {
        if (this.generator.isVerbose()) {
            System.out.println("  Generating method code class for class : " + this.classname);
            System.out.println("    Number of fields " + this.fields.length);
        }
        int dpth = this.getClassDepth(this.clazz);
        this.fillInGeneratedDefaultWriteObjectMethod(dpth);
        this.fillInGeneratedDefaultReadObjectMethod(dpth);
        this.fillInGeneratedWriteObjectMethod(dpth);
        this.fillInGeneratedReadObjectMethod(dpth);
        this.clazz = this.gen.getJavaClass();
        Repository.removeClass((String)this.classname);
        Repository.addClass((JavaClass)this.clazz);
        JavaClass instgen = null;
        if (!this.is_abstract) {
            instgen = this.generateInstanceGenerator();
            instgen.setMajor(this.clazz.getMajor());
            instgen.setMinor(this.clazz.getMinor());
            Repository.addClass((JavaClass)instgen);
        }
        this.generator.markRewritten(this.clazz, instgen);
    }

    private void fillInGeneratedReadObjectMethod(int dpth) {
        this.localStart = new InstructionHandle[10];
        MethodGen mgen = null;
        int index = -1;
        InstructionList read_il = null;
        if (this.is_externalizable || this.super_has_ibis_constructor || !this.super_is_serializable || this.generator.forceGeneratedCalls()) {
            read_il = new InstructionList();
            if (this.is_externalizable) {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)this.factory.createInvoke(this.classname, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
            } else if (!this.super_is_serializable) {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)this.factory.createInvoke(this.super_classname, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
            } else {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new ALOAD(1));
                read_il.append(this.createInitInvocation(this.super_classname, this.factory));
            }
            if (this.is_externalizable || !this.super_is_serializable) {
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "addObjectToCycleCheck", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
            }
            int read_cons_index = SerializationInfo.findMethod(this.methods, "<init>", "(Libis/io/IbisSerializationInputStream;)V");
            mgen = new MethodGen(this.methods[read_cons_index], this.classname, this.constantpool);
            index = read_cons_index;
        } else if (SerializationInfo.hasReadObject(this.methods)) {
            int read_wrapper_index = SerializationInfo.findMethod(this.methods, "$readObjectWrapper$", "(Libis/io/IbisSerializationInputStream;)V");
            mgen = new MethodGen(this.methods[read_wrapper_index], this.classname, this.constantpool);
            read_il = new InstructionList();
            index = read_wrapper_index;
        }
        if (read_il != null) {
            read_il.append((Instruction)new ICONST(0));
            read_il.append((Instruction)new ISTORE(2));
            if (this.localStart[2] == null) {
                this.localStart[2] = read_il.getEnd();
            }
            read_il.append((Instruction)new ICONST(0));
            read_il.append((Instruction)new ISTORE(3));
            if (this.localStart[3] == null) {
                this.localStart[3] = read_il.getEnd();
            }
            read_il.append((Instruction)new ICONST(0));
            read_il.append((Instruction)new ISTORE(4));
            if (this.localStart[4] == null) {
                this.localStart[4] = read_il.getEnd();
            }
            if (this.is_externalizable || SerializationInfo.hasReadObject(this.methods)) {
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new SIPUSH((short)dpth));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "push_current_object", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.INT}, (short)182));
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "getJavaObjectInputStream", (Type)sun_input_stream, Type.NO_ARGS, (short)182));
                if (this.is_externalizable) {
                    read_il.append((Instruction)this.factory.createInvoke(this.classname, "readExternal", (Type)Type.VOID, new Type[]{new ObjectType("java.io.ObjectInput")}, (short)182));
                } else {
                    read_il.append((Instruction)this.factory.createInvoke(this.classname, "readObject", (Type)Type.VOID, new Type[]{sun_input_stream}, (short)183));
                }
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "pop_current_object", (Type)Type.VOID, Type.NO_ARGS, (short)182));
            } else {
                read_il.append(this.generateDefaultReads(true, mgen));
            }
            read_il.append(mgen.getInstructionList());
            MethodGen newMethod = null;
            if (this.is_externalizable || !this.super_is_serializable || this.generator.forceGeneratedCalls() || this.super_has_ibis_constructor) {
                newMethod = new MethodGen(1, (Type)Type.VOID, ibis_input_stream_arrtp, new String[]{"is"}, "<init>", this.classname, read_il, this.constantpool);
            } else if (SerializationInfo.hasReadObject(this.methods)) {
                newMethod = new MethodGen(1, (Type)Type.VOID, ibis_input_stream_arrtp, new String[]{"is"}, "$readObjectWrapper$", this.classname, read_il, this.constantpool);
            }
            newMethod.addException("java.io.IOException");
            newMethod.addException("java.lang.ClassNotFoundException");
            newMethod.setMaxStack(MethodGen.getMaxStack((ConstantPoolGen)this.constantpool, (InstructionList)read_il, (CodeExceptionGen[])newMethod.getExceptionHandlers()));
            newMethod.setMaxLocals();
            this.generateStackMapTable(newMethod);
            int i = 2;
            while (this.localStart[i] != null) {
                newMethod.addLocalVariable("local_" + i, (Type)Type.INT, this.localStart[i], null);
                ++i;
            }
            this.gen.setMethodAt(newMethod.getMethod(), index);
        }
    }

    private void fillInGeneratedWriteObjectMethod(int dpth) {
        CodeExceptionGen[] exceptions;
        InstructionList write_il = new InstructionList();
        int flags = 1 | (this.gen.isFinal() ? 16 : 0);
        int write_method_index = SerializationInfo.findMethod(this.methods, "generated_WriteObject", "(Libis/io/IbisSerializationOutputStream;)V");
        MethodGen write_gen = new MethodGen(this.methods[write_method_index], this.classname, this.constantpool);
        this.localStart = new InstructionHandle[10];
        write_il.append((Instruction)new ICONST(0));
        write_il.append((Instruction)new ISTORE(2));
        if (this.localStart[2] == null) {
            this.localStart[2] = write_il.getEnd();
        }
        write_il.append((Instruction)new ICONST(0));
        write_il.append((Instruction)new ISTORE(3));
        if (this.localStart[3] == null) {
            this.localStart[3] = write_il.getEnd();
        }
        write_il.append((Instruction)new ICONST(0));
        write_il.append((Instruction)new ISTORE(4));
        if (this.localStart[4] == null) {
            this.localStart[4] = write_il.getEnd();
        }
        if (!this.is_externalizable) {
            if (this.super_is_ibis_serializable || this.generator.forceGeneratedCalls() && this.super_is_serializable) {
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)new ALOAD(1));
                write_il.append(this.createGeneratedWriteObjectInvocation(this.super_classname, (short)183));
            } else if (this.super_is_serializable) {
                int ind = this.constantpool.addString(this.super_classname);
                write_il.append((Instruction)new ALOAD(1));
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)new LDC(ind));
                write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeSerializableObject", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)182));
            }
        }
        if (this.is_externalizable || SerializationInfo.hasWriteObject(this.methods)) {
            write_il.append((Instruction)new ALOAD(1));
            write_il.append((Instruction)new ALOAD(0));
            write_il.append((Instruction)new SIPUSH((short)dpth));
            write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "push_current_object", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.INT}, (short)182));
            write_il.append((Instruction)new ALOAD(0));
            write_il.append((Instruction)new ALOAD(1));
            write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "getJavaObjectOutputStream", (Type)sun_output_stream, Type.NO_ARGS, (short)182));
            if (this.is_externalizable) {
                write_il.append((Instruction)this.factory.createInvoke(this.classname, "writeExternal", (Type)Type.VOID, new Type[]{new ObjectType("java.io.ObjectOutput")}, (short)182));
            } else {
                write_il.append(this.createWriteObjectInvocation());
            }
            write_il.append((Instruction)new ALOAD(1));
            write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "pop_current_object", (Type)Type.VOID, Type.NO_ARGS, (short)182));
        } else {
            write_il.append(this.generateDefaultWrites(write_gen));
        }
        write_il.append(write_gen.getInstructionList());
        MethodGen new_write_gen = new MethodGen(flags, (Type)Type.VOID, ibis_output_stream_arrtp, new String[]{"os"}, "generated_WriteObject", this.classname, write_il, this.constantpool);
        new_write_gen.addException("java.io.IOException");
        for (CodeExceptionGen ex : exceptions = write_gen.getExceptionHandlers()) {
            new_write_gen.addExceptionHandler(ex.getStartPC(), ex.getEndPC(), ex.getHandlerPC(), ex.getCatchType());
        }
        new_write_gen.setMaxStack(MethodGen.getMaxStack((ConstantPoolGen)this.constantpool, (InstructionList)write_il, (CodeExceptionGen[])write_gen.getExceptionHandlers()));
        new_write_gen.setMaxLocals();
        this.generateStackMapTable(new_write_gen);
        this.gen.setMethodAt(new_write_gen.getMethod(), write_method_index);
    }

    private void fillInGeneratedDefaultWriteObjectMethod(int dpth) {
        int default_write_method_index = SerializationInfo.findMethod(this.methods, "generated_DefaultWriteObject", "(Libis/io/IbisSerializationOutputStream;I)V");
        MethodGen write_gen = new MethodGen(this.methods[default_write_method_index], this.classname, this.constantpool);
        this.localStart = new InstructionHandle[10];
        InstructionList write_il = new InstructionList();
        InstructionHandle end = write_gen.getInstructionList().getStart();
        write_il.append((Instruction)new ICONST(0));
        write_il.append((Instruction)new ISTORE(3));
        if (this.localStart[3] == null) {
            this.localStart[3] = write_il.getEnd();
        }
        write_il.append((Instruction)new ICONST(0));
        write_il.append((Instruction)new ISTORE(4));
        if (this.localStart[4] == null) {
            this.localStart[4] = write_il.getEnd();
        }
        write_il.append((Instruction)new ILOAD(2));
        write_il.append((Instruction)new SIPUSH((short)dpth));
        IF_ICMPNE ifcmpne = new IF_ICMPNE(null);
        write_il.append((BranchInstruction)ifcmpne);
        write_il.append(this.generateDefaultWrites(write_gen));
        write_il.append((BranchInstruction)new GOTO(end));
        if (this.super_is_ibis_serializable || this.super_is_serializable) {
            InstructionHandle i = write_il.append((Instruction)new ILOAD(2));
            ifcmpne.setTarget(i);
            write_il.append((Instruction)new SIPUSH((short)dpth));
            write_il.append((BranchInstruction)new IF_ICMPGT(end));
            if (this.super_is_ibis_serializable || this.generator.forceGeneratedCalls()) {
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)new ALOAD(1));
                write_il.append((Instruction)new ILOAD(2));
                write_il.append(this.createGeneratedDefaultWriteObjectInvocation(this.super_classname));
            } else {
                write_il.append((Instruction)new ALOAD(1));
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)new ILOAD(2));
                write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "defaultWriteSerializableObject", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.INT}, (short)182));
            }
        } else {
            ifcmpne.setTarget(end);
        }
        write_il.append(write_gen.getInstructionList());
        int flags = 1 | (this.gen.isFinal() ? 16 : 0);
        MethodGen default_write_method = new MethodGen(flags, (Type)Type.VOID, new Type[]{ibis_output_stream, Type.INT}, new String[]{"os", "lvl"}, "generated_DefaultWriteObject", this.classname, write_il, this.constantpool);
        default_write_method.addException("java.io.IOException");
        default_write_method.setMaxStack(MethodGen.getMaxStack((ConstantPoolGen)this.constantpool, (InstructionList)write_il, (CodeExceptionGen[])default_write_method.getExceptionHandlers()));
        default_write_method.setMaxLocals();
        this.generateStackMapTable(default_write_method);
        this.gen.setMethodAt(default_write_method.getMethod(), default_write_method_index);
    }

    private void fillInGeneratedDefaultReadObjectMethod(int dpth) {
        CodeExceptionGen[] exceptions;
        int default_read_method_index = SerializationInfo.findMethod(this.methods, "generated_DefaultReadObject", "(Libis/io/IbisSerializationInputStream;I)V");
        MethodGen read_gen = new MethodGen(this.methods[default_read_method_index], this.classname, this.constantpool);
        this.localStart = new InstructionHandle[10];
        InstructionList read_il = new InstructionList();
        InstructionHandle end = read_gen.getInstructionList().getStart();
        read_il.append((Instruction)new ICONST(0));
        read_il.append((Instruction)new ISTORE(3));
        if (this.localStart[3] == null) {
            this.localStart[3] = read_il.getEnd();
        }
        read_il.append((Instruction)new ICONST(0));
        read_il.append((Instruction)new ISTORE(4));
        if (this.localStart[4] == null) {
            this.localStart[4] = read_il.getEnd();
        }
        read_il.append((Instruction)new ILOAD(2));
        read_il.append((Instruction)new SIPUSH((short)dpth));
        IF_ICMPNE ifcmpne = new IF_ICMPNE(null);
        read_il.append((BranchInstruction)ifcmpne);
        read_il.append(this.generateDefaultReads(false, read_gen));
        read_il.append((BranchInstruction)new GOTO(end));
        if (this.super_is_ibis_serializable || this.super_is_serializable) {
            InstructionHandle i = read_il.append((Instruction)new ILOAD(2));
            ifcmpne.setTarget(i);
            read_il.append((Instruction)new SIPUSH((short)dpth));
            read_il.append((BranchInstruction)new IF_ICMPGT(end));
            if (this.super_is_ibis_serializable || this.generator.forceGeneratedCalls()) {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)new ILOAD(2));
                read_il.append(this.createGeneratedDefaultReadObjectInvocation(this.super_classname, this.factory, (short)183));
            } else {
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new ILOAD(2));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "defaultReadSerializableObject", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.INT}, (short)182));
            }
        } else {
            ifcmpne.setTarget(end);
        }
        read_il.append(read_gen.getInstructionList());
        int flags = 1 | (this.gen.isFinal() ? 16 : 0);
        MethodGen default_read_method = new MethodGen(flags, (Type)Type.VOID, new Type[]{ibis_input_stream, Type.INT}, new String[]{"os", "lvl"}, "generated_DefaultReadObject", this.classname, read_il, this.constantpool);
        default_read_method.addException("java.io.IOException");
        default_read_method.addException("java.lang.ClassNotFoundException");
        for (CodeExceptionGen ex : exceptions = read_gen.getExceptionHandlers()) {
            default_read_method.addExceptionHandler(ex.getStartPC(), ex.getEndPC(), ex.getHandlerPC(), ex.getCatchType());
        }
        default_read_method.setMaxStack(MethodGen.getMaxStack((ConstantPoolGen)this.constantpool, (InstructionList)read_il, (CodeExceptionGen[])default_read_method.getExceptionHandlers()));
        default_read_method.setMaxLocals();
        this.generateStackMapTable(default_read_method);
        this.gen.setMethodAt(default_read_method.getMethod(), default_read_method_index);
    }

    private void generateStackMapTable(MethodGen m) {
        if (this.clazz.getMajor() < 50) {
            return;
        }
        LocalVariableTable localtable = m.getLocalVariableTable(this.constantpool);
        int nLocals = localtable.getTableLength();
        m.getInstructionList().setPositions();
        ArrayList<Integer> targets = new ArrayList<Integer>();
        for (InstructionHandle l = m.getInstructionList().getStart(); l != null; l = l.getNext()) {
            BranchInstruction b;
            InstructionHandle target;
            if (!(l.getInstruction() instanceof BranchInstruction) || targets.contains((target = (b = (BranchInstruction)l.getInstruction()).getTarget()).getPosition())) continue;
            targets.add(target.getPosition());
        }
        if (targets.size() == 0) {
            return;
        }
        int[] positions = new int[targets.size()];
        for (int i = 0; i < positions.length; ++i) {
            positions[i] = (Integer)targets.get(i);
        }
        Arrays.sort(positions);
        int prevPosition = 0;
        int size = 2;
        ArrayList<StackMapTableEntry> entries = new ArrayList<StackMapTableEntry>();
        int oldnLocals = nLocals;
        boolean first = true;
        for (int i = 0; i < positions.length; ++i) {
            int pos = positions[i] - prevPosition;
            while (this.localStart[nLocals] != null && this.localStart[nLocals].getPosition() < positions[i]) {
                ++nLocals;
            }
            if (nLocals > oldnLocals) {
                int j;
                StackMapType[] types;
                if (first && m.getName().equals("<init>")) {
                    first = false;
                    types = new StackMapType[nLocals];
                    types[0] = new StackMapType(7, this.constantpool.addClass(this.clazz.getClassName()), null);
                    size += 3;
                    types[1] = new StackMapType(7, this.constantpool.addClass("ibis.io.IbisSerializationInputStream"), null);
                    size += 3;
                    for (j = oldnLocals; j < nLocals; ++j) {
                        types[j] = new StackMapType(1, -1, null);
                        ++size;
                    }
                    entries.add(new StackMapTableEntry(255, pos, nLocals, types, 0, null, null));
                    size += 7;
                } else {
                    types = new StackMapType[nLocals - oldnLocals];
                    for (j = oldnLocals; j < nLocals; ++j) {
                        types[j - oldnLocals] = new StackMapType(1, -1, null);
                        ++size;
                    }
                    entries.add(new StackMapTableEntry(252 + (nLocals - oldnLocals - 1), pos, nLocals - oldnLocals, types, 0, null, null));
                    size += 3;
                }
            } else if (pos < 64) {
                entries.add(new StackMapTableEntry(pos, 0, 0, null, 0, null, null));
                ++size;
            } else {
                entries.add(new StackMapTableEntry(251, pos, 0, null, 0, null, null));
                size += 3;
            }
            prevPosition = positions[i] + 1;
            oldnLocals = nLocals;
        }
        int stringIndex = this.constantpool.addUtf8("StackMapTable");
        StackMapTable table = new StackMapTable(stringIndex, size, entries.toArray(new StackMapTableEntry[entries.size()]), null);
        m.addCodeAttribute((Attribute)table);
    }
}

