/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.BufferedArrayInputStream;
import ibis.io.Conversion;
import ibis.io.DataInputStream;
import ibis.io.IOProperties;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleBufferArrayInputStream
extends DataInputStream {
    private static final boolean DEBUG = IOProperties.DEBUG;
    private static final Logger logger = LoggerFactory.getLogger(BufferedArrayInputStream.class);
    private final int BUF_SIZE;
    private final byte[] buffer;
    private int index;
    private int offset = 0;
    private Conversion conversion;

    public SingleBufferArrayInputStream(byte[] buffer) {
        this.buffer = buffer;
        this.BUF_SIZE = buffer.length;
        this.conversion = Conversion.loadConversion(false);
    }

    @Override
    public long bytesRead() {
        return this.index - this.offset;
    }

    @Override
    public void resetBytesRead() {
        this.offset = this.index;
    }

    @Override
    public final int read() throws IOException {
        try {
            byte b = this.readByte();
            return b & 0xFF;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public final int size() throws IOException {
        return this.BUF_SIZE;
    }

    @Override
    public final int available() throws IOException {
        return this.BUF_SIZE - this.index;
    }

    private final void checkAvailable(int bytes) throws IOException {
        if (this.BUF_SIZE - this.index < bytes) {
            throw new EOFException("EOF encountered");
        }
    }

    @Override
    public void readArray(boolean[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(boolean[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 1;
        this.checkAvailable(to_convert);
        this.conversion.byte2boolean(this.buffer, this.index, a, off, len);
        this.index += to_convert;
    }

    @Override
    public void readArray(byte[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(byte[" + off + " ... " + (off + len) + "])");
        }
        this.checkAvailable(len);
        System.arraycopy(this.buffer, this.index, a, off, len);
        this.index += len;
    }

    @Override
    public void readArray(short[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(char[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 2;
        this.checkAvailable(to_convert);
        this.conversion.byte2short(this.buffer, this.index, a, off, len);
        this.index += to_convert;
    }

    @Override
    public void readArray(char[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(char[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 2;
        this.checkAvailable(to_convert);
        this.conversion.byte2char(this.buffer, this.index, a, off, len);
        this.index += to_convert;
    }

    @Override
    public void readArray(int[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(int[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 4;
        this.checkAvailable(to_convert);
        this.conversion.byte2int(this.buffer, this.index, a, off, len);
        this.index += to_convert;
    }

    @Override
    public void readArray(long[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(long[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 8;
        this.checkAvailable(to_convert);
        this.conversion.byte2long(this.buffer, this.index, a, off, len);
        this.index += to_convert;
    }

    @Override
    public void readArray(float[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(float[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 4;
        this.checkAvailable(to_convert);
        this.conversion.byte2float(this.buffer, this.index, a, off, len);
        this.index += to_convert;
    }

    @Override
    public void readArray(double[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(double[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 8;
        this.checkAvailable(to_convert);
        this.conversion.byte2double(this.buffer, this.index, a, off, len);
        this.index += to_convert;
    }

    @Override
    public byte readByte() throws IOException {
        this.checkAvailable(1);
        return this.buffer[this.index++];
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkAvailable(1);
        return this.conversion.byte2boolean(this.buffer[this.index++]);
    }

    @Override
    public char readChar() throws IOException {
        this.checkAvailable(2);
        char v = this.conversion.byte2char(this.buffer, this.index);
        this.index += 2;
        return v;
    }

    @Override
    public short readShort() throws IOException {
        this.checkAvailable(2);
        short v = this.conversion.byte2short(this.buffer, this.index);
        this.index += 2;
        return v;
    }

    @Override
    public int readInt() throws IOException {
        this.checkAvailable(4);
        int v = this.conversion.byte2int(this.buffer, this.index);
        this.index += 4;
        return v;
    }

    @Override
    public long readLong() throws IOException {
        this.checkAvailable(8);
        long v = this.conversion.byte2long(this.buffer, this.index);
        this.index += 8;
        return v;
    }

    @Override
    public float readFloat() throws IOException {
        this.checkAvailable(4);
        float v = this.conversion.byte2float(this.buffer, this.index);
        this.index += 4;
        return v;
    }

    @Override
    public double readDouble() throws IOException {
        this.checkAvailable(8);
        double v = this.conversion.byte2double(this.buffer, this.index);
        this.index += 8;
        return v;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read(byte[" + off + " ... " + (off + len) + "])");
        }
        this.checkAvailable(len);
        System.arraycopy(this.buffer, this.index, a, off, len);
        this.index += len;
        return len;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int bufferSize() {
        return this.BUF_SIZE;
    }

    @Override
    public void readByteBuffer(ByteBuffer value) throws IOException, ReadOnlyBufferException {
        int len = value.limit() - value.position();
        this.checkAvailable(len);
        value.put(this.buffer, this.index, len);
        this.index += len;
    }
}

