/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.SplitterException;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class OutputStreamSplitter
extends OutputStream {
    private static final int MAXTHREADS = 32;
    private boolean removeOnException = false;
    private boolean saveException = false;
    private SplitterException savedException = null;
    private long bytesWritten = 0L;
    ArrayList<OutputStream> out = new ArrayList();
    private int numSenders = 0;

    void doWrite(byte[] buf, int offset, int len, int index) {
        try {
            OutputStream o = this.out.get(index);
            if (o != null) {
                o.write(buf, offset, len);
            }
        }
        catch (IOException e) {
            this.addException(e, index);
        }
    }

    void doFlush(int index) {
        try {
            OutputStream o = this.out.get(index);
            if (o != null) {
                o.flush();
            }
        }
        catch (IOException e) {
            this.addException(e, index);
        }
    }

    void doClose(int index) {
        try {
            OutputStream o = this.out.get(index);
            if (o != null) {
                o.close();
            }
        }
        catch (IOException e) {
            this.addException(e, index);
        }
    }

    private synchronized void finish() {
        --this.numSenders;
        this.notifyAll();
    }

    private synchronized void addException(IOException e, int index) {
        if (this.savedException == null) {
            this.savedException = new SplitterException();
        }
        this.savedException.add(this.out.get(index), e);
        if (this.removeOnException) {
            this.out.set(index, null);
        }
    }

    public OutputStreamSplitter() {
    }

    public OutputStreamSplitter(boolean removeOnException, boolean saveException) {
        this();
        this.removeOnException = removeOnException;
        this.saveException = saveException;
    }

    public synchronized void add(OutputStream s) {
        this.out.add(s);
    }

    public synchronized void remove(OutputStream s) throws IOException {
        while (this.numSenders != 0) {
            try {
                this.wait();
            }
            catch (Exception e) {}
        }
        int i = this.out.indexOf(s);
        if (i == -1) {
            throw new IOException("Removing unknown stream from splitter.");
        }
        this.out.remove(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        OutputStreamSplitter outputStreamSplitter = this;
        synchronized (outputStreamSplitter) {
            while (this.numSenders != 0) {
                try {
                    this.wait();
                }
                catch (Exception e) {}
            }
            ++this.numSenders;
        }
        this.bytesWritten += (long)this.out.size();
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                OutputStream o = this.out.get(i);
                if (o == null) continue;
                o.write(b);
                continue;
            }
            catch (IOException e2) {
                if (this.savedException == null) {
                    this.savedException = new SplitterException();
                }
                this.savedException.add(this.out.get(i), e2);
                if (!this.removeOnException) continue;
                this.out.remove(i);
                --i;
            }
        }
        OutputStreamSplitter i = this;
        synchronized (i) {
            --this.numSenders;
            this.notifyAll();
        }
        if (this.savedException != null && !this.saveException) {
            SplitterException e = this.savedException;
            this.savedException = null;
            throw e;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out.size() > 0) {
            this.bytesWritten += (long)(len * this.out.size());
            OutputStreamSplitter outputStreamSplitter = this;
            synchronized (outputStreamSplitter) {
                while (this.numSenders != 0) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {}
                }
                ++this.numSenders;
            }
            for (int i = 1; i < this.out.size(); ++i) {
                Sender s = new Sender(b, i, off, len);
                this.runThread(s, "Splitter sender");
            }
            this.doWrite(b, off, len, 0);
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.out.size() > 0) {
            OutputStreamSplitter outputStreamSplitter = this;
            synchronized (outputStreamSplitter) {
                while (this.numSenders != 0) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {}
                }
                ++this.numSenders;
            }
            for (int i = 1; i < this.out.size(); ++i) {
                Flusher f = new Flusher(i);
                this.runThread(f, "Splitter flusher");
            }
            this.doFlush(0);
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.out.size() > 0) {
            OutputStreamSplitter outputStreamSplitter = this;
            synchronized (outputStreamSplitter) {
                while (this.numSenders != 0) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {}
                }
                ++this.numSenders;
            }
            for (int i = 1; i < this.out.size(); ++i) {
                Closer f = new Closer(i);
                this.runThread(f, "Splitter closer");
            }
            this.doClose(0);
            this.done();
        }
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public void resetBytesWritten() {
        this.bytesWritten = 0L;
    }

    public SplitterException getExceptions() {
        SplitterException e = this.savedException;
        this.savedException = null;
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runThread(Runnable r, String name) {
        OutputStreamSplitter outputStreamSplitter = this;
        synchronized (outputStreamSplitter) {
            while (this.numSenders >= 32) {
                try {
                    this.wait();
                }
                catch (Exception e) {}
            }
            ++this.numSenders;
        }
        ThreadPool.createNew((Runnable)r, (String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() throws IOException {
        OutputStreamSplitter outputStreamSplitter = this;
        synchronized (outputStreamSplitter) {
            --this.numSenders;
            while (this.numSenders != 0) {
                try {
                    this.wait();
                }
                catch (Exception e) {}
            }
            this.notifyAll();
            if (this.savedException != null) {
                if (this.removeOnException) {
                    for (int i = 0; i < this.out.size(); ++i) {
                        if (this.out.get(i) != null) continue;
                        this.out.remove(i);
                        --i;
                    }
                }
                if (!this.saveException) {
                    SplitterException e = this.savedException;
                    this.savedException = null;
                    throw e;
                }
            }
        }
    }

    private class Closer
    implements Runnable {
        int index;

        Closer(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            OutputStreamSplitter.this.doClose(this.index);
            OutputStreamSplitter.this.finish();
        }
    }

    private class Flusher
    implements Runnable {
        int index;

        Flusher(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            OutputStreamSplitter.this.doFlush(this.index);
            OutputStreamSplitter.this.finish();
        }
    }

    private class Sender
    implements Runnable {
        int offset;
        int len;
        byte[] buf;
        int index;

        Sender(byte[] buf, int index, int offset, int len) {
            this.buf = buf;
            this.offset = offset;
            this.len = len;
            this.index = index;
        }

        @Override
        public void run() {
            OutputStreamSplitter.this.doWrite(this.buf, this.offset, this.len, this.index);
            OutputStreamSplitter.this.finish();
        }
    }
}

