/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.DataOutputStream;
import ibis.io.SplitterException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class DataOutputStreamSplitter
extends DataOutputStream {
    private boolean removeOnException = false;
    ArrayList<DataOutputStream> out = new ArrayList();
    int bytesWritten = 0;

    public DataOutputStreamSplitter() {
    }

    public DataOutputStreamSplitter(boolean removeOnException) {
        this();
        this.removeOnException = removeOnException;
    }

    public void add(DataOutputStream s) {
        this.out.add(s);
    }

    public void remove(DataOutputStream s) {
        int i = this.out.indexOf(s);
        if (i == -1) {
            throw new Error("Removing unknown stream from splitter.");
        }
        this.out.remove(i);
    }

    private SplitterException handleException(SplitterException e, IOException newException, int pos) {
        if (e == null) {
            e = new SplitterException();
        }
        e.add(this.out.get(pos), newException);
        if (this.removeOnException) {
            this.out.remove(pos);
        }
        return e;
    }

    @Override
    public void write(int b) throws IOException {
        SplitterException e = null;
        ++this.bytesWritten;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).write(b);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        SplitterException e = null;
        this.bytesWritten += b.length;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).write(b);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        SplitterException e = null;
        this.bytesWritten += len;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).write(b, off, len);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        SplitterException e = null;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).flush();
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void finish() throws IOException {
        SplitterException e = null;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).finish();
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        SplitterException e = null;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).close();
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public boolean finished() throws IOException {
        SplitterException e = null;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                if (this.out.get(i).finished()) continue;
                return false;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
        return true;
    }

    @Override
    public long bytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public void resetBytesWritten() {
        this.bytesWritten = 0;
    }

    @Override
    public void writeArray(boolean[] source, int offset, int length) throws IOException {
        SplitterException e = null;
        this.bytesWritten += length;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeArray(source, offset, length);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeByteBuffer(ByteBuffer b) throws IOException {
        SplitterException e = null;
        this.bytesWritten += b.limit() - b.position();
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeByteBuffer(b);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeArray(byte[] source, int offset, int length) throws IOException {
        this.write(source, offset, length);
    }

    @Override
    public void writeArray(char[] source, int offset, int length) throws IOException {
        SplitterException e = null;
        this.bytesWritten += length * 2;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeArray(source, offset, length);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeArray(double[] source, int offset, int length) throws IOException {
        SplitterException e = null;
        this.bytesWritten += length * 8;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeArray(source, offset, length);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeArray(float[] source, int offset, int length) throws IOException {
        SplitterException e = null;
        this.bytesWritten += length * 4;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeArray(source, offset, length);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeArray(int[] source, int offset, int length) throws IOException {
        SplitterException e = null;
        this.bytesWritten += length * 4;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeArray(source, offset, length);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeArray(long[] source, int offset, int length) throws IOException {
        SplitterException e = null;
        this.bytesWritten += length * 8;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeArray(source, offset, length);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeArray(short[] source, int offset, int length) throws IOException {
        SplitterException e = null;
        this.bytesWritten += length * 2;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeArray(source, offset, length);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        SplitterException e = null;
        ++this.bytesWritten;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeBoolean(value);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeByte(byte value) throws IOException {
        SplitterException e = null;
        ++this.bytesWritten;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeByte(value);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeChar(char value) throws IOException {
        SplitterException e = null;
        this.bytesWritten += 2;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeChar(value);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeDouble(double value) throws IOException {
        SplitterException e = null;
        this.bytesWritten += 8;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeDouble(value);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeFloat(float value) throws IOException {
        SplitterException e = null;
        this.bytesWritten += 4;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeFloat(value);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeInt(int value) throws IOException {
        SplitterException e = null;
        this.bytesWritten += 4;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeInt(value);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeLong(long value) throws IOException {
        SplitterException e = null;
        this.bytesWritten += 8;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeLong(value);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void writeShort(short value) throws IOException {
        SplitterException e = null;
        this.bytesWritten += 2;
        for (int i = 0; i < this.out.size(); ++i) {
            try {
                this.out.get(i).writeShort(value);
                continue;
            }
            catch (IOException e2) {
                e = this.handleException(e, e2, i);
                if (!this.removeOnException) continue;
                --i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public int bufferSize() {
        int min = Integer.MAX_VALUE;
        for (DataOutputStream o : this.out) {
            int sz = o.bufferSize();
            if (sz >= min) continue;
            min = sz;
        }
        return min;
    }
}

