/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.IbisIOException;
import ibis.io.JavaDependantStuff;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ClasspathJavaStuff
extends JavaDependantStuff {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    static Method newObject = null;
    static Method setFieldBoolean = null;
    static Method setFieldByte = null;
    static Method setFieldShort = null;
    static Method setFieldInt = null;
    static Method setFieldLong = null;
    static Method setFieldChar = null;
    static Method setFieldFloat = null;
    static Method setFieldDouble = null;
    static Method setFieldObject = null;
    static boolean available = false;
    private static Dummy dummyObjectInputStream = null;
    private Constructor<?> constructor = null;

    private static Method getMethod(Class<?> cl, String name, Class<?> ... params) throws NoSuchMethodException {
        Method m = cl.getDeclaredMethod(name, params);
        m.setAccessible(true);
        return m;
    }

    ClasspathJavaStuff(Class<?> clazz) {
        super(clazz);
        Class<?> constructorClass;
        if (!available) {
            throw new Error("ClasspathJavaStuff not available");
        }
        for (constructorClass = clazz; constructorClass != null && Serializable.class.isAssignableFrom(constructorClass); constructorClass = constructorClass.getSuperclass()) {
        }
        if (constructorClass != null) {
            try {
                this.constructor = constructorClass.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (this.constructor != null) {
            int constructorModifiers = this.constructor.getModifiers();
            if (Modifier.isPrivate(constructorModifiers)) {
                this.constructor = null;
            } else if (!(Modifier.isPublic(constructorModifiers) || Modifier.isProtected(constructorModifiers) || constructorClass.getPackage().getName().equals(clazz.getPackage().getName()))) {
                this.constructor = null;
            }
        }
    }

    @Override
    Object newInstance() {
        if (this.constructor == null) {
            return null;
        }
        try {
            return newObject.invoke((Object)dummyObjectInputStream, this.clazz, this.constructor);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    void setFieldBoolean(Object ref, String fieldname, boolean d) throws IOException {
        try {
            setFieldBoolean.invoke((Object)this.objectStreamClass.getField(fieldname), ref, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldByte(Object ref, String fieldname, byte d) throws IOException {
        try {
            setFieldByte.invoke((Object)this.objectStreamClass.getField(fieldname), ref, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldChar(Object ref, String fieldname, char d) throws IOException {
        try {
            setFieldChar.invoke((Object)this.objectStreamClass.getField(fieldname), ref, Character.valueOf(d));
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldClass(Object ref, String fieldname, Class<?> d) throws IOException {
        try {
            setFieldObject.invoke((Object)this.objectStreamClass.getField(fieldname), ref, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldDouble(Object ref, String fieldname, double d) throws IOException {
        try {
            setFieldDouble.invoke((Object)this.objectStreamClass.getField(fieldname), ref, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldFloat(Object ref, String fieldname, float d) throws IOException {
        try {
            setFieldFloat.invoke((Object)this.objectStreamClass.getField(fieldname), ref, Float.valueOf(d));
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldInt(Object ref, String fieldname, int d) throws IOException {
        try {
            setFieldInt.invoke((Object)this.objectStreamClass.getField(fieldname), ref, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldLong(Object ref, String fieldname, long d) throws IOException {
        try {
            setFieldLong.invoke((Object)this.objectStreamClass.getField(fieldname), ref, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldObject(Object ref, String fieldname, Object d, String fieldsig) throws IOException {
        try {
            setFieldObject.invoke((Object)this.objectStreamClass.getField(fieldname), ref, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldShort(Object ref, String fieldname, short d) throws IOException {
        try {
            setFieldShort.invoke((Object)this.objectStreamClass.getField(fieldname), ref, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldString(Object ref, String fieldname, String d) throws IOException {
        try {
            setFieldObject.invoke((Object)this.objectStreamClass.getField(fieldname), ref, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    static {
        try {
            dummyObjectInputStream = new Dummy();
            newObject = ClasspathJavaStuff.getMethod(ObjectInputStream.class, "newObject", Class.class, Constructor.class);
            setFieldBoolean = ClasspathJavaStuff.getMethod(ObjectStreamField.class, "setBooleanField", Object.class, Boolean.TYPE);
            setFieldByte = ClasspathJavaStuff.getMethod(ObjectStreamField.class, "setByteField", Object.class, Byte.TYPE);
            setFieldShort = ClasspathJavaStuff.getMethod(ObjectStreamField.class, "setShortField", Object.class, Short.TYPE);
            setFieldInt = ClasspathJavaStuff.getMethod(ObjectStreamField.class, "setIntField", Object.class, Integer.TYPE);
            setFieldLong = ClasspathJavaStuff.getMethod(ObjectStreamField.class, "setLongField", Object.class, Long.TYPE);
            setFieldChar = ClasspathJavaStuff.getMethod(ObjectStreamField.class, "setCharField", Object.class, Character.TYPE);
            setFieldFloat = ClasspathJavaStuff.getMethod(ObjectStreamField.class, "setFloatField", Object.class, Float.TYPE);
            setFieldDouble = ClasspathJavaStuff.getMethod(ObjectStreamField.class, "setDoubleField", Object.class, Double.TYPE);
            setFieldObject = ClasspathJavaStuff.getMethod(ObjectStreamField.class, "setObjectField", Object.class, Object.class);
            available = true;
            logger.info("Classpath java stuff found!");
        }
        catch (Throwable e) {
            logger.info("No Classpath java stuff: got exception", e);
        }
    }

    private static class Dummy
    extends ObjectInputStream {
        protected Dummy() throws IOException, SecurityException {
        }
    }
}

