/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.Conversion;
import ibis.io.DataOutputStream;
import ibis.io.IOProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferedArrayOutputStream
extends DataOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(BufferedArrayOutputStream.class);
    private static final boolean DEBUG = IOProperties.DEBUG;
    private final int BUF_SIZE;
    private OutputStream out;
    private byte[] buffer;
    private int index = 0;
    private long bytes = 0L;
    private Conversion conversion;

    public BufferedArrayOutputStream(OutputStream out, int bufSize) {
        this.out = out;
        this.BUF_SIZE = bufSize;
        this.buffer = new byte[this.BUF_SIZE];
        this.conversion = Conversion.loadConversion(false);
    }

    public BufferedArrayOutputStream(OutputStream out) {
        this(out, IOProperties.BUFFER_SIZE);
    }

    @Override
    public long bytesWritten() {
        return this.bytes + (long)this.index;
    }

    @Override
    public void resetBytesWritten() {
        this.bytes = this.index;
    }

    private void flush(int incr) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("flush(" + incr + ") : " + " " + (this.index + incr >= this.BUF_SIZE) + " " + this.index + ")");
        }
        if (this.index + incr > this.BUF_SIZE) {
            this.bytes += (long)this.index;
            this.out.write(this.buffer, 0, this.index);
            this.index = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        byte b = this.conversion.boolean2byte(value);
        this.flush(1);
        this.buffer[this.index++] = b;
    }

    @Override
    public void writeByte(byte value) throws IOException {
        this.flush(1);
        this.buffer[this.index++] = value;
    }

    @Override
    public void writeChar(char value) throws IOException {
        this.flush(2);
        this.conversion.char2byte(value, this.buffer, this.index);
        this.index += 2;
    }

    @Override
    public void writeShort(short value) throws IOException {
        this.flush(2);
        this.conversion.short2byte(value, this.buffer, this.index);
        this.index += 2;
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.flush(4);
        this.conversion.int2byte(value, this.buffer, this.index);
        this.index += 4;
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.flush(8);
        this.conversion.long2byte(value, this.buffer, this.index);
        this.index += 8;
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.flush(4);
        this.conversion.float2byte(value, this.buffer, this.index);
        this.index += 4;
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.flush(8);
        this.conversion.double2byte(value, this.buffer, this.index);
        this.index += 8;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeArray(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeArray(b, off, len);
    }

    @Override
    public void writeArray(boolean[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(boolean[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(1);
            size = Math.min(this.BUF_SIZE - this.index, len);
            this.conversion.boolean2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size;
        } while ((len -= size) != 0);
    }

    @Override
    public void writeArray(byte[] ref, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(byte[" + off + " ... " + (off + len) + "])");
        }
        if (len > this.BUF_SIZE - this.index) {
            if (this.index > 0) {
                this.bytes += (long)this.index;
                this.out.write(this.buffer, 0, this.index);
                this.index = 0;
            }
            if (len >= this.BUF_SIZE) {
                this.bytes += (long)len;
                this.out.write(ref, off, len);
            } else {
                System.arraycopy(ref, off, this.buffer, 0, len);
                this.index = len;
            }
        } else {
            System.arraycopy(ref, off, this.buffer, this.index, len);
            this.index += len;
        }
    }

    @Override
    public void writeArray(char[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(char[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(2);
            size = Math.min((this.BUF_SIZE - this.index) / 2, len);
            this.conversion.char2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 2;
        } while ((len -= size) != 0);
    }

    @Override
    public void writeArray(short[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(short[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(2);
            size = Math.min((this.BUF_SIZE - this.index) / 2, len);
            this.conversion.short2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 2;
        } while ((len -= size) != 0);
    }

    @Override
    public void writeArray(int[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(int[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(4);
            size = Math.min((this.BUF_SIZE - this.index) / 4, len);
            this.conversion.int2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 4;
        } while ((len -= size) != 0);
    }

    @Override
    public void writeArray(long[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(long[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(8);
            size = Math.min((this.BUF_SIZE - this.index) / 8, len);
            this.conversion.long2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 8;
        } while ((len -= size) != 0);
    }

    @Override
    public void writeArray(float[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(float[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(4);
            size = Math.min((this.BUF_SIZE - this.index) / 4, len);
            this.conversion.float2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 4;
        } while ((len -= size) != 0);
    }

    @Override
    public void writeArray(double[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(double[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(8);
            size = Math.min((this.BUF_SIZE - this.index) / 8, len);
            this.conversion.double2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 8;
        } while ((len -= size) != 0);
    }

    @Override
    public void flush() throws IOException {
        this.flush(this.BUF_SIZE + 1);
        this.out.flush();
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean finished() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public int bufferSize() {
        return this.BUF_SIZE;
    }

    @Override
    public void writeByteBuffer(ByteBuffer value) throws IOException {
        int len = value.limit() - value.position();
        if (len > this.BUF_SIZE - this.index) {
            if (this.index > 0) {
                this.bytes += (long)this.index;
                this.out.write(this.buffer, 0, this.index);
                this.index = 0;
            }
            if (len >= this.BUF_SIZE) {
                if (value.hasArray()) {
                    this.bytes += (long)len;
                    this.out.write(value.array(), value.arrayOffset(), len);
                } else {
                    while (len >= this.BUF_SIZE) {
                        this.bytes += (long)this.BUF_SIZE;
                        value.get(this.buffer, 0, this.BUF_SIZE);
                        this.out.write(this.buffer, 0, this.BUF_SIZE);
                        len -= this.BUF_SIZE;
                    }
                    value.get(this.buffer, 0, len);
                    this.index = len;
                }
            } else {
                value.get(this.buffer, 0, len);
                this.index = len;
            }
        } else {
            value.get(this.buffer, this.index, len);
            this.index += len;
        }
    }
}

