/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.ClasspathJavaStuff;
import ibis.io.DalvikJavaStuff;
import ibis.io.Generator;
import ibis.io.HarmonyJavaStuff;
import ibis.io.IbisNotSerializableException;
import ibis.io.IbisReader;
import ibis.io.IbisSerializationInputStream;
import ibis.io.IbisSerializationOutputStream;
import ibis.io.IbisWriter;
import ibis.io.JavaDependantStuff;
import ibis.io.Serializable;
import ibis.io.SerializationError;
import ibis.io.SunJavaStuff;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AlternativeTypeInfo {
    private static Logger logger = LoggerFactory.getLogger(AlternativeTypeInfo.class);
    private static HashMap<Class<?>, AlternativeTypeInfo> alternativeTypes = new HashMap();
    Class<?> clazz;
    private JavaDependantStuff javaDependantStuff;
    Field[] serializable_fields;
    final IbisWriter writer;
    final IbisReader reader;
    boolean[] fields_final;
    int double_count;
    int long_count;
    int float_count;
    int int_count;
    int short_count;
    int char_count;
    int byte_count;
    int boolean_count;
    int reference_count;
    boolean superSerializable;
    AlternativeTypeInfo alternativeSuperInfo;
    int level;
    ObjectStreamField[] serial_persistent_fields = null;
    boolean hasReadObject;
    boolean hasWriteObject;
    boolean hasReplace;
    boolean isIbisSerializable = false;
    boolean isSerializable = false;
    boolean isExternalizable = false;
    boolean isArray = false;
    boolean isString;
    boolean isClass;
    Generator gen;
    private static FieldComparator fieldComparator = new FieldComparator();
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    Field temporary_field;
    Method temporary_method;

    public String toString() {
        return this.clazz.getName();
    }

    public Object newInstance() {
        return this.getJavaDependantStuff().newInstance();
    }

    public static synchronized AlternativeTypeInfo getAlternativeTypeInfo(Class<?> type) {
        AlternativeTypeInfo t = alternativeTypes.get(type);
        if (t == null) {
            t = new AlternativeTypeInfo(type);
            alternativeTypes.put(type, t);
        }
        return t;
    }

    public static synchronized AlternativeTypeInfo getAlternativeTypeInfo(String classname) throws ClassNotFoundException {
        Class<?> type = null;
        try {
            type = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            type = Thread.currentThread().getContextClassLoader().loadClass(classname);
        }
        return AlternativeTypeInfo.getAlternativeTypeInfo(type);
    }

    private Method getMethod(String name, Class<?>[] paramTypes, Class<?> returnType) {
        try {
            Method method = this.clazz.getDeclaredMethod(name, paramTypes);
            if (method.getReturnType() != returnType) {
                return null;
            }
            if ((method.getModifiers() & 8) != 0) {
                return null;
            }
            if (!method.isAccessible()) {
                this.temporary_method = method;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        AlternativeTypeInfo.this.temporary_method.setAccessible(true);
                        return null;
                    }
                });
            }
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    void invokeWriteObject(Object o, ObjectOutputStream out) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.writeObjectMethod.invoke(o, out);
    }

    void invokeReadObject(Object o, ObjectInputStream in) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.readObjectMethod.invoke(o, in);
    }

    Object invokeReadResolve(Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.readResolveMethod.invoke(o, new Object[0]);
    }

    Object invokeWriteReplace(Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.writeReplaceMethod.invoke(o, new Object[0]);
    }

    private AlternativeTypeInfo(Class<?> clazz) {
        this.clazz = clazz;
        if (SunJavaStuff.available) {
            this.javaDependantStuff = new SunJavaStuff(clazz);
        } else if (HarmonyJavaStuff.available) {
            this.javaDependantStuff = new HarmonyJavaStuff(clazz);
        } else if (DalvikJavaStuff.available) {
            this.javaDependantStuff = new DalvikJavaStuff(clazz);
        } else if (ClasspathJavaStuff.available) {
            this.javaDependantStuff = new ClasspathJavaStuff(clazz);
        }
        try {
            Field field;
            int i;
            this.getSerialPersistentFields();
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                if (java.io.Serializable.class.isAssignableFrom(superClass)) {
                    this.superSerializable = true;
                    this.alternativeSuperInfo = AlternativeTypeInfo.getAlternativeTypeInfo(superClass);
                    this.level = this.alternativeSuperInfo.level + 1;
                } else {
                    this.superSerializable = false;
                    this.level = 1;
                }
            }
            this.writeObjectMethod = this.getMethod("writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
            this.readObjectMethod = this.getMethod("readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
            this.hasWriteObject = this.writeObjectMethod != null;
            this.hasReadObject = this.readObjectMethod != null;
            this.writeReplaceMethod = this.getMethod("writeReplace", new Class[0], Object.class);
            this.readResolveMethod = this.getMethod("readResolve", new Class[0], Object.class);
            this.hasReplace = this.writeReplaceMethod != null;
            Class<?>[] intfs = clazz.getInterfaces();
            for (int i2 = 0; i2 < intfs.length; ++i2) {
                if (!intfs[i2].equals(Serializable.class)) continue;
                this.isIbisSerializable = true;
            }
            this.isSerializable = java.io.Serializable.class.isAssignableFrom(clazz);
            this.isExternalizable = Externalizable.class.isAssignableFrom(clazz);
            this.isArray = clazz.isArray();
            this.isString = clazz == String.class;
            boolean bl = this.isClass = clazz == Class.class;
            if (this.isArray || this.isString || this.isClass) {
                this.gen = null;
            } else {
                Class<?> gen_class = null;
                String name = clazz.getName() + "_ibis_io_Generator";
                try {
                    gen_class = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    try {
                        gen_class = Thread.currentThread().getContextClassLoader().loadClass(name);
                    }
                    catch (Exception e1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Class " + name + " not found!");
                        }
                        this.gen = null;
                    }
                }
                if (gen_class != null) {
                    try {
                        this.gen = (Generator)gen_class.newInstance();
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Could not instantiate " + name);
                        }
                        this.gen = null;
                    }
                }
            }
            Field[] fields = clazz.getDeclaredFields();
            Arrays.sort(fields, fieldComparator);
            int len = fields.length;
            if (this.serial_persistent_fields != null) {
                len = this.serial_persistent_fields.length;
            }
            Field[] double_fields = new Field[len];
            Field[] long_fields = new Field[len];
            Field[] float_fields = new Field[len];
            Field[] int_fields = new Field[len];
            Field[] short_fields = new Field[len];
            Field[] char_fields = new Field[len];
            Field[] byte_fields = new Field[len];
            Field[] boolean_fields = new Field[len];
            Field[] reference_fields = new Field[len];
            if (this.serial_persistent_fields == null) {
                for (i = 0; i < fields.length; ++i) {
                    int modifiers;
                    field = fields[i];
                    if (field == null || ((modifiers = field.getModifiers()) & 0x88) != 0) continue;
                    Class<?> field_type = field.getType();
                    if (!field.isAccessible()) {
                        this.temporary_field = field;
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                AlternativeTypeInfo.this.temporary_field.setAccessible(true);
                                return null;
                            }
                        });
                    }
                    if (field_type.isPrimitive()) {
                        if (field_type == Boolean.TYPE) {
                            boolean_fields[this.boolean_count++] = field;
                            continue;
                        }
                        if (field_type == Character.TYPE) {
                            char_fields[this.char_count++] = field;
                            continue;
                        }
                        if (field_type == Byte.TYPE) {
                            byte_fields[this.byte_count++] = field;
                            continue;
                        }
                        if (field_type == Short.TYPE) {
                            short_fields[this.short_count++] = field;
                            continue;
                        }
                        if (field_type == Integer.TYPE) {
                            int_fields[this.int_count++] = field;
                            continue;
                        }
                        if (field_type == Long.TYPE) {
                            long_fields[this.long_count++] = field;
                            continue;
                        }
                        if (field_type == Float.TYPE) {
                            float_fields[this.float_count++] = field;
                            continue;
                        }
                        if (field_type != Double.TYPE) continue;
                        double_fields[this.double_count++] = field;
                        continue;
                    }
                    reference_fields[this.reference_count++] = field;
                }
            } else {
                for (i = 0; i < this.serial_persistent_fields.length; ++i) {
                    field = this.findField(this.serial_persistent_fields[i]);
                    Class<?> field_type = this.serial_persistent_fields[i].getType();
                    if (field != null && !field.isAccessible()) {
                        this.temporary_field = field;
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                AlternativeTypeInfo.this.temporary_field.setAccessible(true);
                                return null;
                            }
                        });
                    }
                    if (field_type.isPrimitive()) {
                        if (field_type == Boolean.TYPE) {
                            boolean_fields[this.boolean_count++] = field;
                            continue;
                        }
                        if (field_type == Character.TYPE) {
                            char_fields[this.char_count++] = field;
                            continue;
                        }
                        if (field_type == Byte.TYPE) {
                            byte_fields[this.byte_count++] = field;
                            continue;
                        }
                        if (field_type == Short.TYPE) {
                            short_fields[this.short_count++] = field;
                            continue;
                        }
                        if (field_type == Integer.TYPE) {
                            int_fields[this.int_count++] = field;
                            continue;
                        }
                        if (field_type == Long.TYPE) {
                            long_fields[this.long_count++] = field;
                            continue;
                        }
                        if (field_type == Float.TYPE) {
                            float_fields[this.float_count++] = field;
                            continue;
                        }
                        if (field_type != Double.TYPE) continue;
                        double_fields[this.double_count++] = field;
                        continue;
                    }
                    reference_fields[this.reference_count++] = field;
                }
            }
            int size = this.double_count + this.long_count + this.float_count + this.int_count + this.short_count + this.char_count + this.byte_count + this.boolean_count + this.reference_count;
            int index = 0;
            if (size > 0) {
                this.serializable_fields = new Field[size];
                System.arraycopy(double_fields, 0, this.serializable_fields, index, this.double_count);
                System.arraycopy(long_fields, 0, this.serializable_fields, index += this.double_count, this.long_count);
                System.arraycopy(float_fields, 0, this.serializable_fields, index += this.long_count, this.float_count);
                System.arraycopy(int_fields, 0, this.serializable_fields, index += this.float_count, this.int_count);
                System.arraycopy(short_fields, 0, this.serializable_fields, index += this.int_count, this.short_count);
                System.arraycopy(char_fields, 0, this.serializable_fields, index += this.short_count, this.char_count);
                System.arraycopy(byte_fields, 0, this.serializable_fields, index += this.char_count, this.byte_count);
                System.arraycopy(boolean_fields, 0, this.serializable_fields, index += this.byte_count, this.boolean_count);
                System.arraycopy(reference_fields, 0, this.serializable_fields, index += this.boolean_count, this.reference_count);
                this.fields_final = new boolean[size];
                for (int i3 = 0; i3 < size; ++i3) {
                    this.fields_final[i3] = this.serializable_fields[i3] != null ? (this.serializable_fields[i3].getModifiers() & 0x10) != 0 : false;
                }
            } else {
                this.serializable_fields = null;
            }
        }
        catch (Exception e) {
            throw new SerializationError("Cannot initialize serialization info for " + clazz.getName(), e);
        }
        this.writer = this.createWriter();
        this.reader = this.createReader();
    }

    private IbisWriter createWriter() {
        if (this.isArray) {
            return new ArrayWriter();
        }
        if (this.isIbisSerializable) {
            return new IbisSerializableWriter();
        }
        if (this.isExternalizable) {
            return new ExternalizableWriter();
        }
        if (this.isString) {
            return new StringWriter();
        }
        if (this.isClass) {
            return new ClassWriter();
        }
        if (this.clazz.isEnum()) {
            return new EnumWriter();
        }
        if (this.isSerializable) {
            return new SerializableWriter();
        }
        return new NotSerializableWriter();
    }

    private IbisReader createReader() {
        if (this.isArray) {
            return new ArrayReader();
        }
        if (this.gen != null) {
            return new IbisSerializableReader();
        }
        if (this.isExternalizable) {
            return new ExternalizableReader();
        }
        if (this.isString) {
            return new StringReader();
        }
        if (this.isClass) {
            return new ClassReader();
        }
        if (this.clazz.isEnum()) {
            return new EnumReader();
        }
        return new SerializableReader();
    }

    private void getSerialPersistentFields() {
        try {
            Field f = this.clazz.getDeclaredField("serialPersistentFields");
            int mask = 26;
            if ((f.getModifiers() & mask) == mask) {
                if (!f.isAccessible()) {
                    this.temporary_field = f;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            AlternativeTypeInfo.this.temporary_field.setAccessible(true);
                            return null;
                        }
                    });
                }
                this.serial_persistent_fields = (ObjectStreamField[])f.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Field findField(ObjectStreamField of) {
        try {
            return this.clazz.getDeclaredField(of.getName());
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    int getOffset(String name, Class<?> tp) throws IllegalArgumentException {
        block13: {
            int offset;
            block11: {
                block12: {
                    offset = 0;
                    if (!tp.isPrimitive()) break block11;
                    if (this.serial_persistent_fields == null) break block12;
                    for (int i = 0; i < this.serial_persistent_fields.length; ++i) {
                        if (this.serial_persistent_fields[i].getType() != tp) continue;
                        if (name.equals(this.serial_persistent_fields[i].getName())) {
                            return offset;
                        }
                        ++offset;
                    }
                    break block13;
                }
                if (this.serializable_fields == null) break block13;
                for (int i = 0; i < this.serializable_fields.length; ++i) {
                    if (this.serializable_fields[i].getType() != tp) continue;
                    if (name.equals(this.serializable_fields[i].getName())) {
                        return offset;
                    }
                    ++offset;
                }
                break block13;
            }
            if (this.serial_persistent_fields != null) {
                for (int i = 0; i < this.serial_persistent_fields.length; ++i) {
                    if (this.serial_persistent_fields[i].getType().isPrimitive()) continue;
                    if (name.equals(this.serial_persistent_fields[i].getName())) {
                        return offset;
                    }
                    ++offset;
                }
            } else if (this.serializable_fields != null) {
                for (int i = 0; i < this.serializable_fields.length; ++i) {
                    if (this.serializable_fields[i].getType().isPrimitive()) continue;
                    if (name.equals(this.serializable_fields[i].getName())) {
                        return offset;
                    }
                    ++offset;
                }
            }
        }
        throw new IllegalArgumentException("no field named " + name + " with type " + tp);
    }

    static Class<?> getClass(String n) {
        Class<?> c = null;
        try {
            c = Class.forName(n);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationError("Internal error: could not load primitive array type " + n, e);
        }
        return c;
    }

    public JavaDependantStuff getJavaDependantStuff() {
        if (this.javaDependantStuff == null) {
            throw new Error("Unrecognized Java version, ibis serialization not supported. Java version = " + System.getProperty("java.version"));
        }
        return this.javaDependantStuff;
    }

    public void setJavaDependantStuff(JavaDependantStuff javaDependantStuff) {
        this.javaDependantStuff = javaDependantStuff;
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field f1, Field f2) {
            return f1.getName().compareTo(f2.getName());
        }
    }

    private static class SerializableReader
    extends IbisReader {
        private SerializableReader() {
        }

        @Override
        Object readObject(IbisSerializationInputStream in, AlternativeTypeInfo t, int typeHandle) throws IOException, ClassNotFoundException {
            Object obj = in.create_uninitialized_object(t.clazz);
            in.push_current_object(obj, 0);
            try {
                in.alternativeReadObject(t, obj);
            }
            catch (IllegalAccessException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Caught exception, now rethrow as NotSerializableException", (Throwable)e);
                }
                throw new IbisNotSerializableException("handle " + typeHandle, e);
            }
            in.pop_current_object();
            return obj;
        }
    }

    private static class ExternalizableReader
    extends IbisReader {
        private ExternalizableReader() {
        }

        @Override
        Object readObject(IbisSerializationInputStream in, AlternativeTypeInfo t, int typeHandle) throws IOException, ClassNotFoundException {
            Object obj;
            try {
                obj = t.clazz.newInstance();
            }
            catch (Throwable e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Caught exception, now rethrow as ClassNotFound", e);
                }
                throw new ClassNotFoundException("Could not instantiate", e);
            }
            in.addObjectToCycleCheck(obj);
            in.push_current_object(obj, 0);
            ((Externalizable)obj).readExternal(in.getJavaObjectInputStream());
            in.pop_current_object();
            return obj;
        }
    }

    private static class EnumReader
    extends IbisReader {
        private EnumReader() {
        }

        @Override
        Object readObject(IbisSerializationInputStream in, AlternativeTypeInfo t, int typeHandle) throws IOException, ClassNotFoundException {
            Object obj;
            String o = in.readUTF();
            try {
                obj = Enum.valueOf(t.clazz, o);
            }
            catch (Throwable e) {
                throw new IOException("Exception while reading enumeration" + e);
            }
            in.addObjectToCycleCheck(obj);
            return obj;
        }
    }

    private static class ClassReader
    extends IbisReader {
        private ClassReader() {
        }

        @Override
        Object readObject(IbisSerializationInputStream in, AlternativeTypeInfo t, int typeHandle) throws IOException, ClassNotFoundException {
            String o = in.readUTF();
            Class<?> obj = JavaDependantStuff.getClassFromName(o);
            in.addObjectToCycleCheck(obj);
            return obj;
        }
    }

    private static class StringReader
    extends IbisReader {
        private StringReader() {
        }

        @Override
        Object readObject(IbisSerializationInputStream in, AlternativeTypeInfo t, int typeHandle) throws IOException, ClassNotFoundException {
            String o = in.readUTF();
            in.addObjectToCycleCheck(o);
            return o;
        }
    }

    private static class ArrayReader
    extends IbisReader {
        private ArrayReader() {
        }

        @Override
        Object readObject(IbisSerializationInputStream in, AlternativeTypeInfo t, int typeHandle) throws IOException, ClassNotFoundException {
            return in.readArray(t.clazz, typeHandle);
        }
    }

    private static class IbisSerializableReader
    extends IbisReader {
        private IbisSerializableReader() {
        }

        @Override
        Object readObject(IbisSerializationInputStream in, AlternativeTypeInfo t, int typeHandle) throws IOException, ClassNotFoundException {
            return t.gen.generated_newInstance(in);
        }
    }

    private static class NotSerializableWriter
    extends IbisWriter {
        private NotSerializableWriter() {
        }

        @Override
        void writeObject(IbisSerializationOutputStream out, Object ref, AlternativeTypeInfo t, int hashCode, boolean unshared) throws IOException {
            throw new IbisNotSerializableException("Not serializable: " + t.clazz.getName());
        }
    }

    private static class SerializableWriter
    extends IbisWriter {
        private SerializableWriter() {
        }

        @Override
        void writeObject(IbisSerializationOutputStream out, Object ref, AlternativeTypeInfo t, int hashCode, boolean unshared) throws IOException {
            super.writeHeader(out, ref, t, hashCode, unshared);
            out.push_current_object(ref, 0);
            try {
                out.alternativeWriteObject(t, ref);
            }
            catch (IllegalAccessException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Caught exception, rethrow as NotSerializableException", (Throwable)e);
                }
                throw new IbisNotSerializableException("Serializable failed for : " + t.clazz.getName(), e);
            }
            out.pop_current_object();
            IbisSerializationOutputStream.addStatSendObject(ref);
        }
    }

    private class EnumWriter
    extends IbisWriter {
        private EnumWriter() {
        }

        @Override
        void writeObject(IbisSerializationOutputStream out, Object ref, AlternativeTypeInfo t, int hashCode, boolean unshared) throws IOException {
            super.writeHeader(out, ref, t, hashCode, unshared);
            out.writeUTF(((Enum)ref).name());
        }
    }

    private static class ClassWriter
    extends IbisWriter {
        private ClassWriter() {
        }

        @Override
        void writeObject(IbisSerializationOutputStream out, Object ref, AlternativeTypeInfo t, int hashCode, boolean unshared) throws IOException {
            super.writeHeader(out, ref, t, hashCode, unshared);
            out.writeUTF(((Class)ref).getName());
        }
    }

    private static class StringWriter
    extends IbisWriter {
        private StringWriter() {
        }

        @Override
        void writeObject(IbisSerializationOutputStream out, Object ref, AlternativeTypeInfo t, int hashCode, boolean unshared) throws IOException {
            super.writeHeader(out, ref, t, hashCode, unshared);
            out.writeUTF((String)ref);
        }
    }

    private static class ExternalizableWriter
    extends IbisWriter {
        private ExternalizableWriter() {
        }

        @Override
        void writeObject(IbisSerializationOutputStream out, Object ref, AlternativeTypeInfo t, int hashCode, boolean unshared) throws IOException {
            super.writeHeader(out, ref, t, hashCode, unshared);
            out.push_current_object(ref, 0);
            ((Externalizable)ref).writeExternal(out.getJavaObjectOutputStream());
            out.pop_current_object();
        }
    }

    private static class IbisSerializableWriter
    extends IbisWriter {
        private IbisSerializableWriter() {
        }

        @Override
        void writeObject(IbisSerializationOutputStream out, Object ref, AlternativeTypeInfo t, int hashCode, boolean unshared) throws IOException {
            super.writeHeader(out, ref, t, hashCode, unshared);
            ((Serializable)ref).generated_WriteObject(out);
        }
    }

    private static class ArrayWriter
    extends IbisWriter {
        private ArrayWriter() {
        }

        @Override
        void writeObject(IbisSerializationOutputStream out, Object ref, AlternativeTypeInfo t, int hashCode, boolean unshared) throws IOException {
            out.writeArray(ref, t.clazz, unshared);
        }
    }
}

