/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.post;

import de.pleumann.antenna.misc.Conditional;
import de.pleumann.antenna.misc.JadFile;
import de.pleumann.antenna.misc.Utility;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public abstract class PostProcessor
extends Task {
    private boolean verbose = true;
    private Conditional condition;
    private Vector preserve = new Vector();
    private File jarFile;
    private File toJarFile;
    private File jadFile;
    private JadFile jad;
    private Path bootclasspath;
    private Path classpath;
    private Utility utility;

    public void init() {
        super.init();
        this.classpath = new Path(this.getProject(), "");
        this.utility = Utility.getInstance(this.getProject(), this);
        this.condition = new Conditional(this.getProject());
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Object createPreserve() {
        Preserve pre = new Preserve(this.getProject());
        this.preserve.addElement(pre);
        return pre;
    }

    public void setJarfile(File srcFile) {
        this.jarFile = srcFile;
    }

    public void setTojarfile(File destFile) {
        this.toJarFile = destFile;
    }

    public void setJadfile(File file) {
        this.jadFile = file;
    }

    public String getFullClasspath() {
        String cp = this.bootclasspath == null ? this.utility.getMidpApi() : this.bootclasspath.toString();
        if (this.classpath != null && this.classpath.size() > 0) {
            cp = cp + File.pathSeparatorChar + this.classpath;
        }
        return cp;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathref(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setBootclasspath(Path classpath) {
        if (this.bootclasspath == null) {
            this.bootclasspath = classpath;
        } else {
            this.bootclasspath.append(classpath);
        }
    }

    public Path getBootclasspath() {
        return this.bootclasspath;
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootclasspathref(Reference r) {
        this.createBootclasspath().setRefid(r);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public Vector getPreserve() {
        Vector<Preserve> result = new Vector<Preserve>();
        for (int i = 0; i < this.preserve.size(); ++i) {
            Preserve p = (Preserve)this.preserve.elementAt(i);
            if (!p.isActive()) continue;
            result.add(p);
        }
        return result;
    }

    public void setIf(String s) {
        this.condition.setIf(s);
    }

    public void setUnless(String s) {
        this.condition.setUnless(s);
    }

    public boolean isActive() {
        return this.condition.isActive();
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public File getToJarFile() {
        return this.toJarFile;
    }

    public JadFile getJad() throws IOException {
        if (this.jad != null) {
            return this.jad;
        }
        if (this.jadFile != null) {
            this.jad = new JadFile();
            this.jad.load("" + this.jadFile, null);
        }
        return this.jad;
    }

    public Utility getUtility() {
        return this.utility;
    }

    public void updateJad() throws IOException {
        JadFile jad = this.getJad();
        if (jad != null && this.jarFile != null && (this.toJarFile == null || this.jarFile.equals(this.toJarFile))) {
            jad.setValue("MIDlet-Jar-Size", "" + this.jarFile.length());
            this.log("Updating JAD file " + this.jadFile);
            try {
                jad.save("" + this.jadFile, null);
            }
            catch (IOException ex) {
                throw new BuildException("Error processing JAD file", (Throwable)ex);
            }
        }
    }

    public class Preserve
    extends Conditional {
        private String value;

        public Preserve(Project project) {
            super(project);
            this.value = "";
        }

        public void setClass(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

