/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.post;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ClassFile {
    private static final int[] sizes = new int[]{0, 0, 0, 4, 4, 8, 8, 2, 2, 4, 4, 4, 4};
    private Vector classes = new Vector();

    public ClassFile(InputStream input) throws IOException {
        int i;
        DataInputStream data = new DataInputStream(input);
        int[] magic = new int[]{data.readUnsignedByte(), data.readUnsignedByte(), data.readUnsignedByte(), data.readUnsignedByte()};
        if (magic[0] != 202 || magic[1] != 254 || magic[2] != 186 || magic[3] != 190) {
            throw new IOException("Wrong magic - not a class file");
        }
        data.skip(4L);
        int numConstants = data.readUnsignedShort();
        Vector<Entry> entries = new Vector<Entry>();
        entries.add(new Entry(0, new byte[0]));
        for (i = 1; i < numConstants; ++i) {
            int tag = data.readUnsignedByte();
            int size = sizes[tag];
            if (size == 0) {
                size = data.readUnsignedShort();
            }
            byte[] bytes = new byte[size];
            data.readFully(bytes);
            entries.add(new Entry(tag, bytes));
            if (tag != 5 && tag != 6) continue;
            entries.add(new Entry(tag, new byte[0]));
            ++i;
        }
        for (i = 1; i < entries.size(); ++i) {
            Entry entry = (Entry)entries.elementAt(i);
            if (entry.tag != 7) continue;
            int hi = entry.data[0] & 0xFF;
            int lo = entry.data[1] & 0xFF;
            Entry name = (Entry)entries.elementAt(hi << 8 | lo);
            String cls = new String(name.data).replace('/', '.');
            if (cls.startsWith("[")) continue;
            this.classes.addElement(cls);
        }
    }

    public int getRequiredClassCount() {
        return this.classes.size();
    }

    public String getRequiredClass(int index) {
        return (String)this.classes.elementAt(index);
    }

    private class Entry {
        int tag;
        byte[] data;

        Entry(int tag, byte[] data) {
            this.tag = tag;
            this.data = data;
        }
    }
}

