/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.post.PostProcessor;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class WtkPreverify
extends PostProcessor {
    private File srcDir;
    private File destDir;
    private boolean cldc = true;
    private int flags;

    public void setCldc(boolean on) {
        this.cldc = on;
    }

    public void setNonative(boolean b) {
        this.flags = b ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setNofloat(boolean b) {
        this.flags = b ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public void setNofinalize(boolean b) {
        this.flags = b ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void setDestdir(File destDir) {
        if (this.getJarFile() != null) {
            throw new BuildException("Can only preverify JAR or directory, not both.");
        }
        this.destDir = destDir;
    }

    public void setSrcdir(File srcDir) {
        if (this.getJarFile() != null) {
            throw new BuildException("Please use \"tojarfile\" to specify preverified JAR");
        }
        this.srcDir = srcDir;
    }

    public void setJarfile(File srcFile) {
        if (this.srcDir != null) {
            throw new BuildException("Can only preverify JAR or directory, not both.");
        }
        super.setJarfile(srcFile);
    }

    public void setTojarfile(File destFile) {
        if (this.srcDir != null) {
            throw new BuildException("Please use \"destdir\" to specify preverified directory");
        }
        super.setTojarfile(destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (!this.isActive()) {
            return;
        }
        if (this.getJarFile() == null && this.srcDir == null) {
            throw new BuildException("Need a JAR file or a source directory");
        }
        File tmpDir = this.getUtility().getTempDir();
        try {
            try {
                if (this.srcDir != null) {
                    this.getUtility().preverify(this.srcDir, this.destDir, this.getFullClasspath(), this.cldc, this.flags);
                } else {
                    this.getUtility().preverify(this.getJarFile(), tmpDir, this.getFullClasspath(), this.cldc, this.flags);
                    if (this.getToJarFile() == null) {
                        this.setTojarfile(this.getJarFile());
                    }
                    this.getToJarFile().delete();
                    new File(tmpDir, this.getJarFile().getName()).renameTo(this.getToJarFile());
                    this.updateJad();
                }
            }
            finally {
                this.getUtility().delete(tmpDir);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

