/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v2;

import antenna.preprocessor.IPreprocessor;
import antenna.preprocessor.PreprocessorException;
import antenna.preprocessor.v2.PPException;
import antenna.preprocessor.v2.Preprocessor;
import de.pleumann.antenna.misc.Strings;
import de.pleumann.antenna.misc.Utility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.Project;

public class PreprocessorBridge
implements IPreprocessor {
    private Preprocessor m_preprocessor;
    private final Utility m_utility;

    public PreprocessorBridge(Utility utility) {
        this.m_utility = utility;
        Preprocessor.ILineFilter filter = null;
        Preprocessor.ILogger logger = null;
        if (utility != null) {
            final Project project = utility.getProject();
            filter = new Preprocessor.ILineFilter(){

                public String filter(String line) {
                    return project.replaceProperties(line);
                }
            };
            logger = new Preprocessor.ILogger(){

                public void log(String message) {
                    project.log(message);
                }
            };
        }
        this.m_preprocessor = new Preprocessor(logger, filter);
    }

    public void setMode(int mode) {
        this.m_preprocessor.setVerbose((mode & 0x10) != 0);
    }

    public void setFile(File fileName) {
        this.m_preprocessor.setFile(fileName);
    }

    public void setSymbols(String symbols, boolean printSymbols) throws PreprocessorException {
        try {
            this.m_preprocessor.setSymbols(symbols);
            if (printSymbols) {
                this.m_utility.getProject().log("Symbols: " + this.m_preprocessor.getDefines().toString());
            }
        }
        catch (PPException e) {
            throw new PreprocessorException(e.getMessage(), e);
        }
    }

    public boolean preprocess(InputStream in, OutputStream out, String encoding) throws IOException, PreprocessorException {
        try {
            return this.m_preprocessor.preprocess(in, out, encoding);
        }
        catch (PPException e) {
            throw new PreprocessorException(e.getMessage(), e);
        }
    }

    public boolean preprocess(Strings lines, String encoding) throws PreprocessorException, IOException {
        try {
            return this.m_preprocessor.preprocess(lines.getVector(), encoding);
        }
        catch (PPException e) {
            throw new PreprocessorException(e.getMessage(), e);
        }
    }

    public boolean isVerbose() {
        return this.m_preprocessor.isVerbose();
    }
}

