/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v1;

import antenna.preprocessor.PreprocessorException;

class PreprocessorLine {
    public static final String[] types = new String[]{"VISIBLE(0)", "HIDDEN(1)", "DEFINE(2)", "UNDEF(3)", "IFDEF(4)", "IFNDEF(5)", "ELSE(6)", "ENDIF(7)", "ELIFDEF(8)", "ELIFNDEF(9)", "IF(10)", "ELIF(11)", "INCLUDE(12)", "ENDINCLUDE(13)"};
    public static final int TYPE_VISIBLE = 0;
    public static final int TYPE_HIDDEN = 1;
    public static final int TYPE_DEFINE = 2;
    public static final int TYPE_UNDEF = 3;
    public static final int TYPE_IFDEF = 4;
    public static final int TYPE_IFNDEF = 5;
    public static final int TYPE_ELSE = 6;
    public static final int TYPE_ENDIF = 7;
    public static final int TYPE_ELIFDEF = 8;
    public static final int TYPE_ELIFNDEF = 9;
    public static final int TYPE_IF = 10;
    public static final int TYPE_ELIF = 11;
    public static final int TYPE_INCLUDE = 12;
    public static final int TYPE_ENDINCLUDE = 13;
    private String source;
    private int type;
    private String space;
    private String text;
    private String args;

    public PreprocessorLine(String s) throws PreprocessorException {
        this.processLine(s);
    }

    public void processLine(String s) throws PreprocessorException {
        char c;
        int p;
        this.source = s;
        for (p = 0; p < s.length() && ((c = s.charAt(p)) == ' ' || c == '\t'); ++p) {
        }
        this.space = s.substring(0, p);
        if ((s = s.substring(p)).startsWith("//#")) {
            this.type = this.parseCommand(s);
        } else {
            this.type = 0;
            this.text = s;
        }
    }

    public String toString() {
        return types[this.type] + "[" + this.source + "]";
    }

    private int parseCommand(String s) throws PreprocessorException {
        if (s.startsWith("//# ") || s.startsWith("//#\t")) {
            this.text = s.substring(4);
            return 1;
        }
        if (s.equals("//#")) {
            this.text = "";
            return 1;
        }
        int p = s.indexOf(32);
        int q = s.indexOf(9);
        if (q != -1 && q < p || p == -1) {
            p = q;
        }
        if (p != -1) {
            this.text = s.substring(0, p);
            this.args = s.substring(p + 1).trim();
        } else {
            this.text = s;
        }
        if ("//#define".equals(this.text)) {
            return 2;
        }
        if ("//#undef".equals(this.text)) {
            return 3;
        }
        if ("//#ifdef".equals(this.text)) {
            return 4;
        }
        if ("//#ifndef".equals(this.text)) {
            return 5;
        }
        if ("//#elifdef".equals(this.text)) {
            return 8;
        }
        if ("//#elifndef".equals(this.text)) {
            return 9;
        }
        if ("//#else".equals(this.text)) {
            return 6;
        }
        if ("//#endif".equals(this.text)) {
            return 7;
        }
        if ("//#if".equals(this.text)) {
            return 10;
        }
        if ("//#elif".equals(this.text)) {
            return 11;
        }
        if ("//#include".equals(this.text)) {
            return 12;
        }
        if ("//#endinclude".equals(this.text)) {
            return 13;
        }
        throw new PreprocessorException("Unknown directive \"" + this.text + "\"");
    }

    public String getArgs() {
        if (this.args == null) {
            throw new RuntimeException(this.text + " needs an argument");
        }
        return this.args;
    }

    public String getSource() {
        return this.source;
    }

    public String getSpace() {
        return this.space;
    }

    public String getText() {
        return this.text;
    }

    public int getType() {
        return this.type;
    }
}

