/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v1;

import antenna.preprocessor.PreprocessorException;
import antenna.preprocessor.v1.BooleanTokenizer;
import java.util.Hashtable;

class BooleanEvaluator {
    private Hashtable symbols = new Hashtable();

    public BooleanEvaluator(String defines) {
        if (defines != null) {
            defines = defines + ",";
            int p = 0;
            while (p < defines.length()) {
                int q = defines.indexOf(44, p);
                String t = defines.substring(p, q).trim();
                if (t.length() != 0) {
                    this.define(t);
                }
                p = q + 1;
            }
        }
    }

    public void define(String symbol) {
        this.symbols.put(symbol, symbol);
    }

    public void undefine(String symbol) {
        this.symbols.remove(symbol);
    }

    public boolean isDefined(String symbol) {
        return this.symbols.containsKey(symbol);
    }

    private boolean parseFactor(BooleanTokenizer t) throws PreprocessorException {
        boolean result;
        if (t.getTokenType() == 2) {
            t.nextToken();
            result = this.parseExpression(t);
            if (t.getTokenType() != 3) {
                throw new PreprocessorException("\")\" expected");
            }
            t.nextToken();
        } else if (t.getTokenType() == 7) {
            t.nextToken();
            result = !this.parseFactor(t);
        } else if (t.getTokenType() == 1) {
            result = this.isDefined(t.getTokenText());
            t.nextToken();
        } else {
            throw new PreprocessorException("Identifier, \"!\" or \"(\" expected");
        }
        return result;
    }

    private boolean parseTerm(BooleanTokenizer t) throws PreprocessorException {
        boolean result = this.parseFactor(t);
        while (t.getTokenType() == 4) {
            t.nextToken();
            result &= this.parseFactor(t);
        }
        return result;
    }

    private boolean parseExpression(BooleanTokenizer t) throws PreprocessorException {
        boolean result = this.parseTerm(t);
        while (true) {
            if (t.getTokenType() == 5) {
                t.nextToken();
                result |= this.parseTerm(t);
                continue;
            }
            if (t.getTokenType() != 6) break;
            t.nextToken();
            result ^= this.parseTerm(t);
        }
        return result;
    }

    public boolean evaluate(String expression) throws PreprocessorException {
        BooleanTokenizer t = new BooleanTokenizer(expression);
        t.nextToken();
        boolean result = this.parseExpression(t);
        if (t.getTokenType() != 0) {
            throw new PreprocessorException("Syntax error");
        }
        return result;
    }
}

