/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl;

import ibis.ipl.ConnectionFailedException;
import ibis.ipl.IbisIOException;
import ibis.ipl.ReceivePortIdentifier;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ConnectionsFailedException
extends IbisIOException {
    private static final long serialVersionUID = 1L;
    private ArrayList<ConnectionFailedException> failures = new ArrayList();
    private ReceivePortIdentifier[] obtainedConnections;

    public ConnectionsFailedException(String detailMessage) {
        super(detailMessage);
    }

    public ConnectionsFailedException() {
    }

    public void add(ConnectionFailedException exception) {
        this.failures.add(exception);
    }

    public void setObtainedConnections(ReceivePortIdentifier[] receivePortIdentifiers) {
        this.obtainedConnections = (ReceivePortIdentifier[])receivePortIdentifiers.clone();
    }

    public ReceivePortIdentifier[] getObtainedConnections() {
        return (ReceivePortIdentifier[])this.obtainedConnections.clone();
    }

    public ConnectionFailedException[] getFailures() {
        return this.failures.toArray(new ConnectionFailedException[this.failures.size()]);
    }

    @Override
    public String toString() {
        if (this.failures.size() == 0) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append("\n--- START OF CONNECTIONS FAILED EXCEPTION ---\n");
        for (ConnectionFailedException failure : this.failures) {
            result.append("Connection to <");
            if (failure.receivePortIdentifier() != null) {
                result.append(failure.receivePortIdentifier().toString());
            } else {
                result.append(((Object)failure.ibisIdentifier()).toString());
                result.append(", ");
                result.append(failure.receivePortName());
            }
            result.append("> failed: ");
            result.append(failure.getMessage());
            result.append("\n");
            Throwable throwable = failure.getCause();
            if (throwable == null) continue;
            result.append(throwable.getClass().getName());
            result.append(": ");
            String message = throwable.getMessage();
            if (message == null) {
                message = throwable.toString();
            }
            result.append(message);
            result.append("\n");
        }
        result.append("--- END OF CONNECTIONS FAILED EXCEPTION ---\n");
        return result.toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (this.failures.size() == 0) {
            super.printStackTrace(printStream);
            return;
        }
        printStream.println("--- START OF CONNECTIONS FAILED EXCEPTION STACK TRACE ---");
        for (ConnectionFailedException failure : this.failures) {
            if (failure.receivePortIdentifier() != null) {
                printStream.println("Connection to <" + failure.receivePortIdentifier() + "> failed: ");
            } else {
                printStream.println("Connection to <" + failure.ibisIdentifier() + ", " + failure.receivePortName() + "> failed: ");
            }
            printStream.println(failure.getMessage());
            failure.printStackTrace(printStream);
        }
        printStream.println("--- END OF CONNECTIONS FAILED EXCEPTION STACK TRACE ---");
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.failures.size() == 0) {
            super.printStackTrace(printWriter);
            return;
        }
        printWriter.println("--- START OF CONNECTIONS FAILED EXCEPTION STACK TRACE ---");
        for (ConnectionFailedException failure : this.failures) {
            if (failure.receivePortIdentifier() != null) {
                printWriter.println("Connection to <" + failure.receivePortIdentifier() + "> failed: ");
            } else {
                printWriter.println("Connection to <" + failure.ibisIdentifier() + ", " + failure.receivePortName() + "> failed: ");
            }
            printWriter.println(failure.getMessage());
            failure.printStackTrace();
        }
        printWriter.println("--- END OF CONNECTIONS FAILED EXCEPTION STACK TRACE ---");
    }
}

