/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.throughput.mtnio;

import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import test.virtual.throughput.mtnio.DataSource;

class Sender
extends Thread {
    private final DataSource d;
    private final VirtualSocket s;
    private final SocketChannel channel;
    private final ByteBuffer buffer;
    private final ByteBuffer opcode;
    private final ByteBuffer[] message;
    private final int size;

    Sender(DataSource d, VirtualSocket s, DataOutputStream out, DataInputStream in, int size) {
        this.d = d;
        this.s = s;
        this.size = size;
        this.channel = s.getChannel();
        this.opcode = ByteBuffer.allocateDirect(4);
        this.opcode.clear();
        this.buffer = ByteBuffer.allocateDirect(size);
        this.buffer.put(new byte[size]);
        this.buffer.clear();
        this.message = new ByteBuffer[2];
        this.message[0] = this.opcode;
        this.message[1] = this.buffer;
    }

    private void sendOpcode(int value) {
        this.opcode.putInt(value);
        this.opcode.flip();
        try {
            for (int written = 0; written < 4; written += this.channel.write(this.opcode)) {
            }
        }
        catch (Exception e) {
            throw new Error("Failed to write opcode!", e);
        }
        this.opcode.clear();
    }

    private void sendData() {
        int block = this.d.getBlock();
        while (block != -1) {
            try {
                this.opcode.putInt(block);
                this.opcode.flip();
                int written = 0;
                while (written < this.size + 4) {
                    written = (int)((long)written + this.channel.write(this.message));
                }
                this.opcode.clear();
                this.buffer.position(0);
            }
            catch (Exception e) {
                throw new Error("Failed to write data!", e);
            }
            block = this.d.getBlock();
        }
        this.sendOpcode(-1);
    }

    @Override
    public void run() {
        boolean done = this.d.waitForStartOrDone();
        while (!done) {
            this.sendData();
            done = this.d.waitForStartOrDone();
        }
        this.sendOpcode(-2);
        VirtualSocketFactory.close(this.s, this.channel);
    }
}

