/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.throughput.mt;

import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import test.virtual.throughput.mt.DataSource;

class Sender
extends Thread {
    private final DataSource d;
    private final VirtualSocket s;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final byte[] data;

    Sender(DataSource d, VirtualSocket s, DataOutputStream out, DataInputStream in, int size) {
        this.d = d;
        this.s = s;
        this.out = out;
        this.in = in;
        this.data = new byte[size];
    }

    private void sendData() {
        int block = this.d.getBlock();
        while (block != -1) {
            try {
                this.out.writeInt(block);
                this.out.write(this.data);
                this.out.flush();
            }
            catch (Exception e) {
                System.out.println("Failed to write data!" + e);
            }
            block = this.d.getBlock();
        }
        try {
            this.out.writeInt(-1);
            this.out.flush();
        }
        catch (Exception e) {
            System.out.println("Failed to write data!" + e);
        }
    }

    @Override
    public void run() {
        boolean done = this.d.waitForStartOrDone();
        while (!done) {
            this.sendData();
            done = this.d.waitForStartOrDone();
        }
        try {
            this.out.writeInt(-2);
            this.out.flush();
        }
        catch (Exception e) {
            System.out.println("Failed to write data!" + e);
        }
        VirtualSocketFactory.close(this.s, this.out, this.in);
    }
}

