/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.throughput.mt;

import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import test.virtual.throughput.mt.DataSink;
import test.virtual.throughput.mt.DataSource;
import test.virtual.throughput.mt.Receiver;
import test.virtual.throughput.mt.Sender;

public class MTThroughput {
    private static int OPCODE_META = 42;
    private static int OPCODE_DATA = 24;
    private static int DEFAULT_STREAMS = 2;
    private static int DEFAULT_REPEAT = 10;
    private static int DEFAULT_COUNT = 100;
    private static int TIMEOUT = 15000;
    private static int DEFAULT_SIZE = 0x100000;
    private static int count = DEFAULT_COUNT;
    private static int repeat = DEFAULT_REPEAT;
    private static int size = DEFAULT_SIZE;
    private static int streams = DEFAULT_STREAMS;
    private static VirtualSocketFactory sf;
    private static HashMap<String, Object> connectProperties;

    private static void configure(VirtualSocket s) throws SocketException {
        s.setTcpNoDelay(true);
        System.out.println("Configured socket: ");
        System.out.println(" sendbuffer     = " + s.getSendBufferSize());
        System.out.println(" receiverbuffer = " + s.getReceiveBufferSize());
        System.out.println(" no delay       = " + s.getTcpNoDelay());
    }

    private static void createStreamOut(VirtualSocketAddress target, DataSource d, int id, int size) {
        VirtualSocket s = null;
        DataInputStream in = null;
        DataOutputStream out = null;
        try {
            s = sf.createClientSocket(target, TIMEOUT, connectProperties);
            System.out.println("Created DATA connection to " + target);
            MTThroughput.configure(s);
            in = new DataInputStream(s.getInputStream());
            out = new DataOutputStream(s.getOutputStream());
            out.writeInt(OPCODE_DATA);
            out.writeInt(id);
            out.flush();
            new Sender(d, s, out, in, size).start();
        }
        catch (IOException e) {
            VirtualSocketFactory.close(s, out, in);
            System.out.println("Failed to create connection to " + target);
        }
    }

    private static void printPerformance(long time, long size) {
        double tp = 1000.0 * (double)size / (1048576.0 * (double)time);
        double mbit = 8000.0 * (double)size / (1048576.0 * (double)time);
        if (mbit > 1000.0) {
            System.out.printf("Test took %d ms. Througput = %4.1f MByte/s (%3.1f GBit/s)\n", time, tp, mbit /= 1024.0);
        } else {
            System.out.printf("Test took %d ms. Througput = %4.1f MByte/s (%3.1f MBit/s)\n", time, tp, mbit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void client(VirtualSocketAddress target) {
        VirtualSocket s = null;
        DataInputStream in = null;
        DataOutputStream out = null;
        try {
            s = sf.createClientSocket(target, TIMEOUT, connectProperties);
            System.out.println("Created META connection to " + target);
            MTThroughput.configure(s);
            in = new DataInputStream(s.getInputStream());
            out = new DataOutputStream(s.getOutputStream());
            int id = 42;
            out.writeInt(OPCODE_META);
            out.writeInt(size);
            out.writeInt(count);
            out.writeInt(repeat);
            out.writeInt(streams);
            out.writeInt(id);
            out.flush();
            DataSource d = new DataSource();
            for (int i = 0; i < streams; ++i) {
                MTThroughput.createStreamOut(target, d, id, size);
            }
            System.out.println("Starting test");
            for (int r = 0; r < repeat; ++r) {
                long start = System.currentTimeMillis();
                d.set(count);
                in.readInt();
                long end = System.currentTimeMillis();
                MTThroughput.printPerformance(end - start, count * size);
            }
            d.done();
            VirtualSocketFactory.close(s, out, in);
        }
        catch (IOException e) {
            System.out.println("Failed to create connection to " + target);
        }
        finally {
            VirtualSocketFactory.close(s, out, in);
        }
    }

    private static void createStreamIn(VirtualServerSocket ss, DataSink d, int id, int size) {
        try {
            VirtualSocket s = ss.accept();
            System.out.println("Incoming connection from " + s.getRemoteSocketAddress());
            MTThroughput.configure(s);
            DataInputStream in = new DataInputStream(s.getInputStream());
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            int opcode = in.readInt();
            if (opcode != OPCODE_DATA) {
                throw new Error("EEK: sender out of sync (2)!");
            }
            int tmp = in.readInt();
            if (tmp != id) {
                throw new Error("EEK: sender out of sync (3)!");
            }
            new Receiver(d, s, out, in, size).start();
        }
        catch (Exception e) {
            throw new Error("EEK: got exception while accepting! ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void server() throws IOException {
        System.out.println("Creating server");
        VirtualServerSocket ss = sf.createServerSocket(0, 0, connectProperties);
        System.out.println("Created server on " + ss.getLocalSocketAddress());
        while (true) {
            System.out.println("Server waiting for connections");
            VirtualSocket s = null;
            DataInputStream in = null;
            DataOutputStream out = null;
            try {
                s = ss.accept();
                System.out.println("Incoming connection from " + s.getRemoteSocketAddress());
                MTThroughput.configure(s);
                in = new DataInputStream(s.getInputStream());
                out = new DataOutputStream(s.getOutputStream());
                int opcode = in.readInt();
                if (opcode != OPCODE_META) {
                    throw new Error("EEK: sender out of sync!");
                }
                size = in.readInt();
                count = in.readInt();
                repeat = in.readInt();
                streams = in.readInt();
                int id = in.readInt();
                DataSink d = new DataSink();
                for (int i = 0; i < streams; ++i) {
                    MTThroughput.createStreamIn(ss, d, id, size);
                }
                for (int r = 0; r < repeat; ++r) {
                    d.waitForCount(streams);
                    out.writeInt(streams);
                    out.flush();
                }
                System.out.println("done!");
            }
            catch (IOException e) {
                try {
                    throw new Error("Server got exception!", e);
                }
                catch (Throwable throwable) {
                    VirtualSocketFactory.close(s, out, in);
                    throw throwable;
                }
            }
            VirtualSocketFactory.close(s, out, in);
        }
    }

    public static void main(String[] args) throws IOException {
        connectProperties = new HashMap();
        VirtualSocketAddress target = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-target")) {
                target = new VirtualSocketAddress(args[++i]);
                continue;
            }
            if (args[i].equals("-size")) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-count")) {
                count = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-repeat")) {
                repeat = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-streams")) {
                streams = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-buffers")) {
                int size = Integer.parseInt(args[++i]);
                connectProperties.put("sendbuffer", size);
                connectProperties.put("receivebuffer", size);
                continue;
            }
            System.err.println("Unknown option: " + args[i]);
        }
        try {
            sf = VirtualSocketFactory.createSocketFactory(connectProperties, true);
        }
        catch (InitializationException e) {
            System.out.println("Failed to create socketfactory!");
            e.printStackTrace();
            System.exit(1);
        }
        if (target == null) {
            MTThroughput.server();
        } else {
            MTThroughput.client(target);
        }
    }
}

