/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.simple;

import ibis.smartsockets.util.MultiplexStreamFactory;
import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MultiplexTest2 {
    private static final int BLOCK_SIZE = 16384;
    private static final int TOTAL_SIZE = 0xA00000;

    public static void main(String[] args) throws IOException {
        long time;
        DataOutputStream out;
        DataInputStream in;
        MultiplexStreamFactory f;
        VirtualSocket s;
        int senders;
        VirtualSocketFactory sf = null;
        try {
            sf = VirtualSocketFactory.createSocketFactory();
        }
        catch (InitializationException e1) {
            System.out.println("Failed to create socketfactory!");
            e1.printStackTrace();
            System.exit(1);
        }
        if (args.length > 0) {
            System.out.println("I am client");
            VirtualSocketAddress target = new VirtualSocketAddress(args[0]);
            senders = Integer.parseInt(args[1]);
            s = sf.createClientSocket(target, 0, null);
            System.out.println("Created connection to " + target);
            f = new MultiplexStreamFactory(s.getInputStream(), s.getOutputStream());
            in = new DataInputStream(f.getBaseIn());
            out = new DataOutputStream(f.getBaseOut());
            out.writeInt(senders);
            out.flush();
            SenderThread[] threads = new SenderThread[senders];
            System.out.println("Creating " + senders + " streams");
            for (int i = 0; i < senders; ++i) {
                threads[i] = new SenderThread(i, f.createOutputStream(i), 16384, 0xA00000);
            }
            in.read();
            System.out.println("Starting test");
            time = System.currentTimeMillis();
            for (int i = 0; i < senders; ++i) {
                threads[i].start();
            }
        } else {
            System.out.println("I am server");
            VirtualServerSocket ss = sf.createServerSocket(0, 0, null);
            System.out.println("Created server on " + ss.getLocalSocketAddress());
            while (true) {
                int i;
                VirtualSocket s2 = ss.accept();
                System.out.println("Incoming connection from " + s2.getRemoteSocketAddress());
                MultiplexStreamFactory f2 = new MultiplexStreamFactory(s2.getInputStream(), s2.getOutputStream());
                DataInputStream in2 = new DataInputStream(f2.getBaseIn());
                DataOutputStream out2 = new DataOutputStream(f2.getBaseOut());
                int senders2 = in2.readInt();
                System.out.println("Accepting " + senders2 + " senders");
                InputStream[] inputs = new InputStream[senders2];
                int[] readData = new int[senders2];
                for (int i2 = 0; i2 < senders2; ++i2) {
                    inputs[i2] = f2.createInputStream(i2);
                }
                out2.write(42);
                out2.flush();
                System.out.println("Starting test");
                byte[] buffer = new byte[16384];
                int total = 0xA00000 * senders2;
                int size = 0;
                while (size < total) {
                    for (i = 0; i < senders2; ++i) {
                        if (readData[i] >= 0xA00000) continue;
                        int bytes = inputs[i].read(buffer);
                        int n = i;
                        readData[n] = readData[n] + bytes;
                        size += bytes;
                    }
                }
                for (i = 0; i < senders2; ++i) {
                    inputs[i].close();
                }
                out2.write(42);
                out2.flush();
                System.out.println("done");
                out2.close();
                in2.close();
                f2.close();
                s2.close();
            }
        }
        in.read();
        time = System.currentTimeMillis() - time;
        long size = 0xA00000L * (long)senders;
        double sec = (double)time / 1000.0;
        double TP = (double)size / 1048576.0 / sec;
        System.out.println("Send " + size + " bytes using " + senders + " streams in " + sec + " seconds (" + TP + " MB/sec)");
        out.close();
        in.close();
        f.close();
        s.close();
    }

    private static class SenderThread
    extends Thread {
        private final int number;
        private final int total;
        private final byte[] buffer;
        private final OutputStream out;

        SenderThread(int number, OutputStream out, int size, int total) {
            this.number = number;
            this.out = out;
            this.buffer = new byte[size];
            this.total = total;
        }

        @Override
        public void run() {
            try {
                int size = 0;
                while (size < this.total) {
                    if (this.total - size < this.buffer.length) {
                        this.out.write(this.buffer, 0, this.total - size);
                        size += this.total - size;
                    } else {
                        this.out.write(this.buffer);
                        size += this.buffer.length;
                    }
                    this.out.flush();
                }
                System.out.println("Sender " + this.number + " wrote " + size + " bytes.");
                this.out.close();
            }
            catch (Exception e) {
                System.err.println("Sender got exception " + e);
                e.printStackTrace(System.err);
            }
        }
    }
}

