/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.hub;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.smartsockets.virtual.VirtualSocketFactory;

public class DataMessage {
    private VirtualSocketFactory factory;
    private int repeat = 100;
    private int count = 100000;
    private int size = 8192;

    public DataMessage(VirtualSocketFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ServiceLink sl = this.factory.getServiceLink();
            byte[] data = new byte[this.size];
            DirectSocketAddress node = this.factory.getLocalHost();
            DirectSocketAddress hub = this.factory.getLocalHub();
            System.out.println("Sending to " + node + " @ " + hub);
            for (int r = 0; r < this.repeat; ++r) {
                long start = System.currentTimeMillis();
                for (int i = 0; i < this.count; ++i) {
                    sl.sendDataMessage(node, hub, null, data);
                }
                long end = System.currentTimeMillis();
                double MBitsPersec = (double)(this.size * this.count) * 8000.0 / (double)(end - start) / 1000000.0;
                System.out.println("Send " + this.size * this.count + " bytes in " + (end - start) + " ms. (" + MBitsPersec + " MBit/s)");
            }
        }
        catch (Exception e) {
            System.err.println("Oops: " + e);
            e.printStackTrace(System.err);
        }
        finally {
            try {
                this.factory.end();
            }
            catch (Exception exception) {}
        }
        System.out.println("Done!");
    }

    public static void main(String[] args) {
        try {
            VirtualSocketFactory factory = VirtualSocketFactory.createSocketFactory(null, true);
            System.out.println("Created socket factory");
            new DataMessage(factory).run();
        }
        catch (Exception e) {
            System.err.println("Oops: " + e);
            e.printStackTrace(System.err);
        }
    }
}

