/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.ProcessingInstructionTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.dom.DOMAttributeIterator;
import org.apache.commons.jxpath.ri.model.dom.DOMNamespaceIterator;
import org.apache.commons.jxpath.ri.model.dom.DOMNodeIterator;
import org.apache.commons.jxpath.ri.model.dom.NamespacePointer;
import org.apache.commons.jxpath.util.TypeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMNodePointer
extends NodePointer {
    private Node node;
    private Map namespaces;
    private String defaultNamespace;
    private String id;
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    static /* synthetic */ Class class$java$lang$String;

    public DOMNodePointer(Node node, Locale locale) {
        super(null, locale);
        this.node = node;
    }

    public DOMNodePointer(Node node, Locale locale, String id) {
        super(null, locale);
        this.node = node;
        this.id = id;
    }

    public DOMNodePointer(NodePointer parent, Node node) {
        super(parent);
        this.node = node;
    }

    public boolean testNode(NodeTest test) {
        return DOMNodePointer.testNode(this, this.node, test);
    }

    public static boolean testNode(NodePointer pointer, Node node, NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            if (node.getNodeType() != 1) {
                return false;
            }
            QName testName = ((NodeNameTest)test).getNodeName();
            String testLocalName = testName.getName();
            boolean wildcard = testLocalName.equals("*");
            String testPrefix = testName.getPrefix();
            if (wildcard && testPrefix == null) {
                return true;
            }
            if (wildcard || testLocalName.equals(DOMNodePointer.getLocalName(node))) {
                String nodePrefix = DOMNodePointer.getPrefix(node);
                if (DOMNodePointer.equalStrings(testPrefix, nodePrefix)) {
                    return true;
                }
                String testNS = pointer.getNamespaceURI(testPrefix);
                String nodeNS = pointer.getNamespaceURI(nodePrefix);
                return DOMNodePointer.equalStrings(testNS, nodeNS);
            }
        } else {
            if (test instanceof NodeTypeTest) {
                short nodeType = node.getNodeType();
                switch (((NodeTypeTest)test).getNodeType()) {
                    case 1: {
                        return nodeType == 1;
                    }
                    case 2: {
                        return nodeType == 4 || nodeType == 3;
                    }
                    case 3: {
                        return nodeType == 8;
                    }
                    case 4: {
                        return nodeType == 7;
                    }
                }
                return false;
            }
            if (test instanceof ProcessingInstructionTest && node.getNodeType() == 7) {
                String testPI = ((ProcessingInstructionTest)test).getTarget();
                String nodePI = ((ProcessingInstruction)node).getTarget();
                return testPI.equals(nodePI);
            }
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return s1 == null || s1.trim().equals(s2.trim());
    }

    public QName getName() {
        String ln = null;
        String ns = null;
        short type = this.node.getNodeType();
        if (type == 1) {
            ns = DOMNodePointer.getPrefix(this.node);
            ln = DOMNodePointer.getLocalName(this.node);
        } else if (type == 7) {
            ln = ((ProcessingInstruction)this.node).getTarget();
        }
        return new QName(ns, ln);
    }

    public String getNamespaceURI() {
        if (this.node.getNodeType() == 1) {
            return this.getNamespaceURI(this.getName().getPrefix());
        }
        return null;
    }

    public QName getExpandedName() {
        return new QName(this.getNamespaceURI(), this.getName().getName());
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return new DOMNodeIterator(this, test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        return new DOMAttributeIterator(this, name);
    }

    public NodePointer namespacePointer(String prefix) {
        return new NamespacePointer((NodePointer)this, prefix);
    }

    public NodeIterator namespaceIterator() {
        return new DOMNamespaceIterator(this);
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null || prefix.equals("")) {
            return this.getDefaultNamespaceURI();
        }
        if (prefix.equals("xml")) {
            return XML_NAMESPACE_URI;
        }
        if (prefix.equals("xmlns")) {
            return XMLNS_NAMESPACE_URI;
        }
        String namespace = null;
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        } else {
            namespace = (String)this.namespaces.get(prefix);
        }
        if (namespace == null) {
            String qname = "xmlns:" + prefix;
            Node aNode = this.node;
            while (aNode != null) {
                Attr attr;
                if (aNode.getNodeType() == 1 && (attr = ((Element)aNode).getAttributeNode(qname)) != null) {
                    namespace = attr.getValue();
                    break;
                }
                aNode = aNode.getParentNode();
            }
            if (namespace == null || namespace.equals("")) {
                namespace = "<<unknown namespace>>";
            }
        }
        this.namespaces.put(prefix, namespace);
        return namespace;
    }

    public String getDefaultNamespaceURI() {
        if (this.defaultNamespace == null) {
            Node aNode = this.node;
            while (aNode != null) {
                Attr attr;
                if (aNode.getNodeType() == 1 && (attr = ((Element)aNode).getAttributeNode("xmlns")) != null) {
                    this.defaultNamespace = attr.getValue();
                    break;
                }
                aNode = aNode.getParentNode();
            }
        }
        if (this.defaultNamespace == null) {
            this.defaultNamespace = "";
        }
        return this.defaultNamespace.equals("") ? null : this.defaultNamespace;
    }

    public Object getBaseValue() {
        return this.node;
    }

    public Object getImmediateNode() {
        return this.node;
    }

    public boolean isActual() {
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public boolean isLeaf() {
        if (this.node instanceof Element) {
            // empty if block
        }
        return !this.node.hasChildNodes();
    }

    public boolean isLanguage(String lang) {
        String current = this.getLanguage();
        if (current == null) {
            return super.isLanguage(lang);
        }
        return current.toUpperCase().startsWith(lang.toUpperCase());
    }

    protected String getLanguage() {
        Node n = this.node;
        while (n != null) {
            Element e;
            String attr;
            if (n.getNodeType() == 1 && (attr = (e = (Element)n).getAttribute("xml:lang")) != null && !attr.equals("")) {
                return attr;
            }
            n = n.getParentNode();
        }
        return null;
    }

    public void setValue(Object value) {
        if (this.node.getNodeType() == 3 || this.node.getNodeType() == 4) {
            String string = (String)TypeUtils.convert(value, class$java$lang$String == null ? (class$java$lang$String = DOMNodePointer.class$("java.lang.String")) : class$java$lang$String);
            if (string != null && !string.equals("")) {
                this.node.setNodeValue(string);
            } else {
                this.node.getParentNode().removeChild(this.node);
            }
        } else {
            int count;
            NodeList children = this.node.getChildNodes();
            int i = count = children.getLength();
            while (--i >= 0) {
                Node child = children.item(i);
                this.node.removeChild(child);
            }
            if (value instanceof Node) {
                Node valueNode = (Node)value;
                if (valueNode instanceof Element || valueNode instanceof Document) {
                    children = valueNode.getChildNodes();
                    int i2 = 0;
                    while (i2 < children.getLength()) {
                        Node child = children.item(i2);
                        this.node.appendChild(child.cloneNode(true));
                        ++i2;
                    }
                } else {
                    this.node.appendChild(valueNode.cloneNode(true));
                }
            } else {
                String string = (String)TypeUtils.convert(value, class$java$lang$String == null ? (class$java$lang$String = DOMNodePointer.class$("java.lang.String")) : class$java$lang$String);
                if (string != null && !string.equals("")) {
                    Text textNode = this.node.getOwnerDocument().createTextNode(string);
                    this.node.appendChild(textNode);
                }
            }
        }
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        NodeIterator it;
        boolean success;
        if (index == Integer.MIN_VALUE) {
            index = 0;
        }
        if ((success = this.getAbstractFactory(context).createObject(context, this, this.node, name.toString(), index)) && (it = this.childIterator(new NodeNameTest(name), false, null)) != null && it.setPosition(index + 1)) {
            return it.getNodePointer();
        }
        throw new JXPathException("Factory could not create a child node for path: " + this.asPath() + "/" + name + "[" + (index + 1) + "]");
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        NodePointer ptr = this.createChild(context, name, index);
        ptr.setValue(value);
        return ptr;
    }

    public NodePointer createAttribute(JXPathContext context, QName name) {
        if (!(this.node instanceof Element)) {
            return super.createAttribute(context, name);
        }
        Element element = (Element)this.node;
        String prefix = name.getPrefix();
        if (prefix != null) {
            String ns = this.getNamespaceURI(prefix);
            if (ns == null) {
                throw new JXPathException("Unknown namespace prefix: " + prefix);
            }
            element.setAttributeNS(ns, name.toString(), "");
        } else if (!element.hasAttribute(name.getName())) {
            element.setAttribute(name.getName(), "");
        }
        NodeIterator it = this.attributeIterator(name);
        it.setPosition(1);
        return it.getNodePointer();
    }

    public void remove() {
        Node parent = this.node.getParentNode();
        if (parent == null) {
            throw new JXPathException("Cannot remove root DOM node");
        }
        parent.removeChild(this.node);
    }

    public String asPath() {
        if (this.id != null) {
            return "id('" + this.escape(this.id) + "')";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
        }
        switch (this.node.getNodeType()) {
            case 1: {
                if (!(this.parent instanceof DOMNodePointer)) break;
                if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                    buffer.append('/');
                }
                buffer.append(this.getName());
                buffer.append('[');
                buffer.append(this.getRelativePositionByName()).append(']');
                break;
            }
            case 3: 
            case 4: {
                buffer.append("/text()");
                buffer.append('[');
                buffer.append(this.getRelativePositionOfTextNode()).append(']');
                break;
            }
            case 7: {
                String target = ((ProcessingInstruction)this.node).getTarget();
                buffer.append("/processing-instruction('");
                buffer.append(target).append("')");
                buffer.append('[');
                buffer.append(this.getRelativePositionOfPI(target)).append(']');
                break;
            }
        }
        return buffer.toString();
    }

    private String escape(String string) {
        int index = string.indexOf(39);
        while (index != -1) {
            string = string.substring(0, index) + "&apos;" + string.substring(index + 1);
            index = string.indexOf(39);
        }
        index = string.indexOf(34);
        while (index != -1) {
            string = string.substring(0, index) + "&quot;" + string.substring(index + 1);
            index = string.indexOf(34);
        }
        return string;
    }

    private int getRelativePositionByName() {
        int count = 1;
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            String nm;
            if (n.getNodeType() == 1 && (nm = n.getNodeName()).equals(this.node.getNodeName())) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    private int getRelativePositionOfTextNode() {
        int count = 1;
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    private int getRelativePositionOfPI(String target) {
        int count = 1;
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            if (n.getNodeType() == 7 && ((ProcessingInstruction)n).getTarget().equals(target)) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    public int hashCode() {
        return System.identityHashCode(this.node);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DOMNodePointer)) {
            return false;
        }
        DOMNodePointer other = (DOMNodePointer)object;
        return this.node == other.node;
    }

    public static String getPrefix(Node node) {
        String prefix = node.getPrefix();
        if (prefix != null) {
            return prefix;
        }
        String name = node.getNodeName();
        int index = name.lastIndexOf(58);
        if (index == -1) {
            return null;
        }
        return name.substring(0, index);
    }

    public static String getLocalName(Node node) {
        String localName = node.getLocalName();
        if (localName != null) {
            return localName;
        }
        String name = node.getNodeName();
        int index = name.lastIndexOf(58);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    public Object getValue() {
        return this.stringValue(this.node);
    }

    private String stringValue(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 8) {
            String text = ((Comment)node).getData();
            return text == null ? "" : text.trim();
        }
        if (nodeType == 3 || nodeType == 4) {
            String text = node.getNodeValue();
            return text == null ? "" : text.trim();
        }
        if (nodeType == 7) {
            String text = ((ProcessingInstruction)node).getData();
            return text == null ? "" : text.trim();
        }
        NodeList list = node.getChildNodes();
        StringBuffer buf2 = new StringBuffer(16);
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child.getNodeType() == 3) {
                buf2.append(child.getNodeValue());
            } else {
                buf2.append(this.stringValue(child));
            }
            ++i;
        }
        return buf2.toString().trim();
    }

    public Pointer getPointerByID(JXPathContext context, String id) {
        Document document = this.node.getNodeType() == 9 ? (Document)this.node : this.node.getOwnerDocument();
        Element element = document.getElementById(id);
        if (element != null) {
            return new DOMNodePointer(element, this.getLocale(), id);
        }
        return new NullPointer(this.getLocale(), id);
    }

    private AbstractFactory getAbstractFactory(JXPathContext context) {
        AbstractFactory factory = context.getFactory();
        if (factory == null) {
            throw new JXPathException("Factory is not set on the JXPathContext - cannot create path: " + this.asPath());
        }
        return factory;
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        Node node2;
        Node node1 = (Node)pointer1.getBaseValue();
        if (node1 == (node2 = (Node)pointer2.getBaseValue())) {
            return 0;
        }
        short t1 = node1.getNodeType();
        short t2 = node2.getNodeType();
        if (t1 == 2 && t2 != 2) {
            return -1;
        }
        if (t1 != 2 && t2 == 2) {
            return 1;
        }
        if (t1 == 2 && t2 == 2) {
            NamedNodeMap map = ((Node)this.getNode()).getAttributes();
            int length = map.getLength();
            int i = 0;
            while (i < length) {
                Node n = map.item(i);
                if (n == node1) {
                    return -1;
                }
                if (n == node2) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        Node current = this.node.getFirstChild();
        while (current != null) {
            if (current == node1) {
                return -1;
            }
            if (current == node2) {
                return 1;
            }
            current = current.getNextSibling();
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

