/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.samples;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sbbi.upnp.DiscoveryAdvertisement;
import net.sbbi.upnp.DiscoveryEventHandler;
import net.sbbi.upnp.devices.UPNPRootDevice;

public class MyDiscoveryEventsHandler
implements DiscoveryEventHandler {
    private Map devices = new HashMap();

    public void eventSSDPAlive(String usn, String udn, String nt, String maxAge, URL location) {
        System.out.println("Device " + usn + " at " + location + " of type " + nt + " alive");
        if (this.devices.get(usn) == null) {
            UPNPRootDevice device = null;
            try {
                device = new UPNPRootDevice(location, maxAge);
                this.devices.put(usn, device);
                System.out.println("Device " + usn + " added");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public void eventSSDPByeBye(String usn, String udn, String nt) {
        if (this.devices.get(usn) != null) {
            this.devices.remove(usn);
            System.out.println("Device " + usn + " leaves");
        }
    }

    public static void main(String[] args) throws IOException {
        DiscoveryAdvertisement instance = DiscoveryAdvertisement.getInstance();
        MyDiscoveryEventsHandler handler = new MyDiscoveryEventsHandler();
        instance.setDaemon(false);
        instance.registerEvent(0, "upnp:rootdevice", handler);
    }
}

