/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.splice;

import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Map;

public class SplicedVirtualSocket
extends VirtualSocket {
    protected final DirectSocket s;
    protected final OutputStream out;
    protected final InputStream in;

    protected SplicedVirtualSocket(VirtualSocketAddress target, DirectSocket s, OutputStream out, InputStream in, Map<?, ?> p) {
        super(target);
        this.s = s;
        this.out = out;
        this.in = in;
    }

    @Override
    protected void connectionAccepted(int timeout) throws IOException {
        try {
            this.s.setSoTimeout(timeout);
            this.out.write(1);
            this.out.flush();
            this.s.setSoTimeout(0);
        }
        catch (IOException e) {
            DirectSocketFactory.close(this.s, this.out, this.in);
            throw e;
        }
    }

    @Override
    public void connectionRejected(int timeout) {
        try {
            this.s.setSoTimeout(timeout);
            this.out.write(4);
            this.out.flush();
        }
        catch (Exception exception) {
        }
        finally {
            DirectSocketFactory.close(this.s, this.out, null);
        }
    }

    @Override
    public void waitForAccept(int timeout) throws IOException {
        try {
            this.s.setSoTimeout(timeout);
            int result = this.in.read();
            switch (result) {
                case 1: {
                    this.s.setSoTimeout(0);
                    return;
                }
                case 2: {
                    throw new SocketException("Remote port not found");
                }
                case 3: {
                    throw new SocketException("Connection ended up on wrong machine!");
                }
                case 4: {
                    throw new SocketException("Connection rejected");
                }
                case -1: {
                    throw new EOFException("Unexpected EOF while waiting for accept");
                }
            }
            throw new SocketException("Got unknown reply during connect!");
        }
        catch (IOException e) {
            DirectSocketFactory.close(this.s, this.out, this.in);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.s.close();
    }

    @Override
    public SocketChannel getChannel() {
        return this.s.getChannel();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.s.getReceiveBufferSize();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.s.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.s.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.s.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.s.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.s.getTcpNoDelay();
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.s.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.s.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.s.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.s.isOutputShutdown();
    }

    @Override
    public void setReceiveBufferSize(int sz) throws SocketException {
        this.s.setReceiveBufferSize(sz);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.s.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int sz) throws SocketException {
        this.s.setSendBufferSize(sz);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.s.setSoLinger(on, linger);
    }

    @Override
    public void setSoTimeout(int t) throws SocketException {
        this.s.setSoTimeout(t);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.s.setTcpNoDelay(on);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.s.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.s.shutdownOutput();
    }

    @Override
    public String toString() {
        return "SplicedVirtualIbisSocket(" + this.s.toString() + ")";
    }
}

