/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules;

import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.modules.AcceptHandler;
import ibis.smartsockets.virtual.modules.MessagingModule;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public abstract class AbstractDirectModule
extends MessagingModule
implements AcceptHandler {
    public static final byte ACCEPT = 1;
    public static final byte PORT_NOT_FOUND = 2;
    public static final byte CONNECTION_REJECTED = 4;
    public static final byte SERVER_OVERLOAD = 5;
    protected DirectSocketFactory direct;
    private HashMap<Integer, AcceptHandler> handlers = null;

    protected AbstractDirectModule(String name, boolean requiresServiceLink) {
        super(name, requiresServiceLink);
    }

    public synchronized void installAcceptHandler(int port, AcceptHandler h) {
        if (this.handlers == null) {
            this.handlers = new HashMap(1);
        }
        this.handlers.put(port, h);
    }

    private synchronized AcceptHandler findAcceptHandler(int targetPort) {
        if (this.handlers == null) {
            return this;
        }
        AcceptHandler tmp = this.handlers.get(targetPort);
        if (tmp == null) {
            return this;
        }
        return tmp;
    }

    protected abstract VirtualSocket createVirtualSocket(VirtualSocketAddress var1, DirectSocket var2, OutputStream var3, InputStream var4);

    @Override
    public void accept(DirectSocket ds, int targetPort, long time) {
        InputStream in = null;
        OutputStream out = null;
        try {
            out = ds.getOutputStream();
            VirtualServerSocket vss = this.parent.getServerSocket(targetPort);
            if (vss == null) {
                out.write(2);
                out.flush();
                DirectSocketFactory.close(ds, out, null);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.module + ": Connection failed, PORT not found!");
                }
                return;
            }
            in = ds.getInputStream();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.module + ": Connection seems OK, checking if server is willing to accept");
            }
            VirtualSocket vs = this.createVirtualSocket(this.parent.getLocalVirtual(), ds, out, in);
            int accept = vss.incomingConnection(vs);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.module + ": accept = " + accept);
            }
            if (accept != 0) {
                if (accept == -1) {
                    out.write(4);
                } else {
                    out.write(5);
                }
                out.flush();
                DirectSocketFactory.close(ds, out, in);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.module + ": Connection failed for port " + targetPort + ": " + (accept < 0 ? "REFUSED" : "OVERLOAD"));
                }
                return;
            }
        }
        catch (Exception e) {
            this.logger.warn(this.module + ": Got exception during connection setup!", (Throwable)e);
            DirectSocketFactory.close(ds, out, in);
        }
    }

    protected void handleAccept(DirectSocket ds) {
        long start = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.module + ": Got incoming connection on " + ds);
        }
        try {
            ds.setTcpNoDelay(true);
            int targetPort = ds.getUserData();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.module + ": Target port " + targetPort);
            }
            this.findAcceptHandler(targetPort).accept(ds, targetPort, start);
        }
        catch (Exception e) {
            this.logger.warn(this.module + ": Got exception during connection setup!", (Throwable)e);
            DirectSocketFactory.close(ds, null, null);
        }
    }
}

