/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util.ssh;

import ibis.smartsockets.util.ssh.LocalStreamForwarder;
import ibis.smartsockets.util.ssh.SSHUtil;
import java.io.IOException;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class SSHConnection
implements AutoCloseable {
    private ClientSession[] sessions;
    private SSHUtil.Tunnel[] tunnels;
    private final int hops;
    private boolean closed = false;
    private ClientSession session;

    protected SSHConnection(int hops) {
        this.hops = hops;
        this.sessions = new ClientSession[hops];
        this.tunnels = new SSHUtil.Tunnel[hops];
    }

    protected void addHop(int hop, ClientSession session, SSHUtil.Tunnel tunnel) {
        this.sessions[hop] = session;
        this.tunnels[hop] = tunnel;
    }

    protected void setSession(ClientSession session) {
        this.session = session;
    }

    public ClientSession getSession() {
        return this.session;
    }

    public LocalStreamForwarder createLocalStreamForwarder(String host, int port, long timeout) throws IOException {
        ChannelDirectTcpip channel = this.session.createDirectTcpipChannel(null, new SshdSocketAddress(port));
        channel.open().await(timeout);
        return new LocalStreamForwarder(channel);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = this.hops - 1; i >= 0; --i) {
            if (this.tunnels[i] != null) {
                try {
                    this.tunnels[i].close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.sessions[i] == null) continue;
            try {
                this.sessions[i].close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

