/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import ibis.smartsockets.SmartSocketsProperties;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.Hub;
import ibis.smartsockets.util.TypedProperties;
import java.io.IOException;

public class HubStarter {
    private static final int DEFAULT_ACCEPT_PORT = 17878;
    private static Hub h;

    public static void main(String[] args) {
        boolean startRouter = false;
        boolean startHub = true;
        DirectSocketAddress[] hubs = new DirectSocketAddress[args.length];
        int port = 17878;
        int numHubs = 0;
        TypedProperties p = SmartSocketsProperties.getDefaultProperties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-external_router")) {
                startRouter = true;
                continue;
            }
            if (args[i].startsWith("-no-hub")) {
                startHub = false;
                continue;
            }
            if (args[i].equals("-clusters")) {
                if (i + 1 >= args.length) {
                    System.out.println("-clusters option requires parameter!");
                    System.exit(1);
                }
                String clusters = args[++i];
                p.put("smartsockets.hub.clusters", clusters);
                String[] tmp = null;
                try {
                    tmp = p.getStringList("smartsockets.hub.clusters", ",", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tmp != null) continue;
                System.out.println("-clusters option has incorrect parameter: " + clusters);
                System.exit(1);
                continue;
            }
            if (args[i].equals("-port")) {
                if (i + 1 >= args.length) {
                    System.out.println("-port option requires parameter!");
                    System.exit(1);
                }
                port = Integer.parseInt(args[++i]);
                continue;
            }
            try {
                hubs[i] = DirectSocketAddress.getByAddress(args[i]);
                ++numHubs;
                continue;
            }
            catch (Exception e) {
                System.err.println("Skipping hub address: " + args[i]);
                e.printStackTrace(System.err);
            }
        }
        DirectSocketAddress[] tmp = new DirectSocketAddress[numHubs];
        int index = 0;
        for (int i = 0; i < hubs.length; ++i) {
            if (hubs[i] == null) continue;
            tmp[index++] = hubs[i];
        }
        hubs = tmp;
        if (port != 17878 && p.getIntProperty("smartsockets.hub.port", -1) != -1) {
            p.put("smartsockets.hub.port", Integer.toString(port));
        }
        if (startHub) {
            try {
                h = new Hub(p);
                h.addHubs(hubs);
                System.out.println("Hub running on: " + h.getHubAddress());
            }
            catch (IOException e) {
                System.err.println("Oops: failed to start hub");
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
        if (startRouter) {
            DirectSocketAddress adr = null;
            adr = h != null ? h.getHubAddress() : hubs[0];
            if (adr == null) {
                System.err.println("Router requires hub address!");
                System.exit(1);
            }
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

