/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.plugin;

import ibis.smartsockets.plugin.SmartSocketFactory;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;

public class SmartSocket
extends Socket {
    private VirtualSocket s;
    private boolean bound;
    private SocketAddress bindpoint;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean tcpNoDelay = false;
    private boolean solinger = false;
    private boolean soreuse = false;
    private boolean keepalive = false;
    private boolean OOBinline = false;
    private int linger = 0;
    private int timeout = 0;
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;
    private int trafficClass = -1;

    SmartSocket() {
        this.bound = false;
    }

    SmartSocket(VirtualSocket s) {
        this.s = s;
        this.bound = true;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (bindpoint == null) {
            throw new IllegalArgumentException("Bindpoint is null");
        }
        if (!(bindpoint instanceof InetSocketAddress) && !(bindpoint instanceof VirtualSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type!");
        }
        this.bindpoint = bindpoint;
        this.bound = true;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this.isConnected()) {
            this.s.close();
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("The target address is null!");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Negative timeout");
        }
        if (this.isConnected()) {
            throw new SocketException("Already connected!");
        }
        VirtualSocketAddress tmp = null;
        if (!(endpoint instanceof VirtualSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        tmp = (VirtualSocketAddress)endpoint;
        this.s = SmartSocketFactory.getDefault().connect(tmp, timeout, this.properties);
        this.bound = true;
        this.properties = null;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public SocketChannel getChannel() {
        if (this.isClosed() || !this.isConnected()) {
            return null;
        }
        return this.s.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.isClosed() || !this.isConnected()) {
            return null;
        }
        return this.s.getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        return this.s.getInputStream();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        if (this.s == null) {
            return this.keepalive;
        }
        return this.s.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        if (!this.isBound()) {
            return null;
        }
        if (this.s != null) {
            return this.s.getLocalAddress();
        }
        if (this.bindpoint instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.bindpoint).getAddress();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        if (this.s != null) {
            return this.s.getLocalPort();
        }
        if (this.bindpoint instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.bindpoint).getPort();
        }
        if (this.bindpoint instanceof VirtualSocketAddress) {
            return ((VirtualSocketAddress)this.bindpoint).port();
        }
        return -1;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        if (this.s != null) {
            return this.s.getLocalSocketAddress();
        }
        return this.bindpoint;
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        if (this.s == null) {
            return this.OOBinline;
        }
        return this.s.getOOBInline();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        return this.s.getOutputStream();
    }

    @Override
    public int getPort() {
        if (this.s == null) {
            return 0;
        }
        return this.s.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        if (this.s == null) {
            return this.receiveBufferSize;
        }
        return this.s.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (this.s == null) {
            return null;
        }
        return this.s.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        if (this.s == null) {
            return this.soreuse;
        }
        return this.s.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        if (this.s == null) {
            return this.sendBufferSize;
        }
        return this.s.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        if (this.s == null) {
            if (this.solinger) {
                return this.linger;
            }
            return -1;
        }
        return this.s.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        if (this.s == null) {
            return this.timeout;
        }
        return this.s.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        if (this.s == null) {
            return this.tcpNoDelay;
        }
        return this.s.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        if (this.s == null) {
            return this.trafficClass;
        }
        return this.s.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public boolean isClosed() {
        if (this.s != null) {
            return this.s.isClosed();
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this.s != null) {
            return this.s.isConnected();
        }
        return false;
    }

    @Override
    public boolean isInputShutdown() {
        if (this.s != null) {
            return this.s.isInputShutdown();
        }
        return false;
    }

    @Override
    public boolean isOutputShutdown() {
        if (this.s != null) {
            return this.s.isOutputShutdown();
        }
        return false;
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        this.s.sendUrgentData(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        if (this.s != null) {
            this.s.setKeepAlive(on);
        } else {
            this.properties.put("tcp.keepAlive", on);
        }
        this.keepalive = on;
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        if (this.s != null) {
            this.s.setOOBInline(on);
        } else {
            this.properties.put("tcp.OOBinline", on);
        }
        this.OOBinline = on;
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.s != null) {
            this.s.setReceiveBufferSize(size);
        } else {
            this.properties.put("tcp.receiveBufferSize", size);
        }
        this.receiveBufferSize = size;
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        if (this.s != null) {
            this.s.setReuseAddress(on);
        } else {
            this.properties.put("tcp.reuseAddress", on);
        }
        this.soreuse = on;
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        if (this.s != null) {
            this.s.setSendBufferSize(size);
        } else {
            this.properties.put("tcp.sendBufferSize", size);
        }
        this.sendBufferSize = size;
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.s != null) {
            this.s.setSoLinger(on, linger);
        } else {
            this.properties.put("tcp.linger", linger);
        }
        this.solinger = on;
        this.linger = linger;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        if (this.s != null) {
            this.s.setSoTimeout(timeout);
        } else {
            this.properties.put("tcp.timeout", timeout);
        }
        this.timeout = timeout;
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.s != null) {
            this.s.setTcpNoDelay(on);
        } else {
            this.properties.put("tcp.nodelay", on);
        }
        this.tcpNoDelay = on;
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        if (this.s != null) {
            this.s.setTrafficClass(tc);
        } else {
            this.properties.put("tcp.trafficClass", tc);
        }
        this.trafficClass = tc;
    }

    @Override
    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        this.s.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        this.s.shutdownOutput();
    }

    @Override
    public String toString() {
        return "SmartSocket(" + (this.s == null ? "<not connected>" : this.s.toString()) + ")";
    }
}

