/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.state;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.state.HubDescription;
import ibis.smartsockets.hub.state.Selector;
import java.util.LinkedList;

public class DirectionsAsStringSelector
extends Selector {
    private LinkedList<String> good = new LinkedList();
    private LinkedList<String> bad = new LinkedList();
    private LinkedList<String> ugly = new LinkedList();
    private final DirectSocketAddress client;

    public DirectionsAsStringSelector(DirectSocketAddress client) {
        this.client = client;
    }

    @Override
    public boolean needAll() {
        return true;
    }

    @Override
    public void select(HubDescription description) {
        if (description.containsClient(this.client)) {
            if (description.isLocal()) {
                this.good.addFirst(description.hubAddressAsString);
            } else if (description.isReachable()) {
                this.good.addLast(description.hubAddressAsString);
            } else if (description.canReachMe()) {
                this.bad.addLast(description.hubAddressAsString);
            } else {
                HubDescription indirect = description.getIndirection();
                if (indirect != null) {
                    if (indirect.isReachable()) {
                        this.ugly.addFirst(indirect.hubAddressAsString);
                    } else if (indirect.canReachMe()) {
                        this.ugly.addLast(indirect.hubAddressAsString);
                    }
                }
            }
        }
    }

    public LinkedList<String> getResult() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.good);
        result.addAll(this.bad);
        result.addAll(this.ugly);
        return result;
    }
}

