/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.state;

import ibis.smartsockets.direct.DirectSocketAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class ClientDescription {
    final DirectSocketAddress clientAddress;
    private long version = 0L;
    private HashMap<String, String> services;

    public ClientDescription(DirectSocketAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    private ClientDescription(DirectSocketAddress clientAddress, long version, HashMap<String, String> services) {
        this.clientAddress = clientAddress;
        this.version = version;
        this.services = services;
    }

    protected boolean addService(String tag, String info) {
        if (this.services == null) {
            this.services = new HashMap();
        }
        if (this.services.containsKey(tag)) {
            return false;
        }
        this.services.put(tag, info);
        ++this.version;
        return true;
    }

    protected boolean updateService(String tag, String info) {
        if (this.services == null) {
            return false;
        }
        if (!this.services.containsKey(tag)) {
            return false;
        }
        this.services.put(tag, info);
        ++this.version;
        return true;
    }

    protected synchronized boolean removeService(String tag) {
        if (this.services == null) {
            return false;
        }
        if (!this.services.containsKey(tag)) {
            return false;
        }
        this.services.remove(tag);
        ++this.version;
        return true;
    }

    protected boolean containsService(String tag) {
        if (tag == null || tag.length() == 0) {
            return true;
        }
        if (this.services == null) {
            return false;
        }
        return this.services.containsKey(tag);
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("Client(");
        tmp.append(this.clientAddress);
        tmp.append(", ");
        tmp.append(this.version);
        if (this.services != null) {
            for (String key : this.services.keySet()) {
                String val = this.services.get(key);
                tmp.append(", [");
                tmp.append(key);
                tmp.append(",");
                tmp.append(val);
                tmp.append("]");
            }
        }
        tmp.append(")");
        return tmp.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ClientDescription)) {
            return false;
        }
        return this.clientAddress.equals(((ClientDescription)other).clientAddress);
    }

    public int hashCode() {
        return this.clientAddress.hashCode();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.clientAddress.toString());
        out.writeLong(this.version);
        if (this.services == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.services.size());
            for (String key : this.services.keySet()) {
                String value = this.services.get(key);
                if (value == null) {
                    value = "";
                }
                out.writeUTF(key);
                out.writeUTF(value);
            }
        }
    }

    public static ClientDescription read(DataInputStream in) throws IOException {
        DirectSocketAddress adress = DirectSocketAddress.getByAddress(in.readUTF());
        long version = in.readLong();
        int services = in.readInt();
        HashMap<String, String> m = new HashMap<String, String>();
        for (int s = 0; s < services; ++s) {
            m.put(in.readUTF(), in.readUTF());
        }
        return new ClientDescription(adress, version, m);
    }
}

