/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.connections;

import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.Connections;
import ibis.smartsockets.hub.Statistics;
import ibis.smartsockets.hub.StatisticsCallback;
import ibis.smartsockets.hub.connections.BaseConnection;
import ibis.smartsockets.hub.connections.ClientConnection;
import ibis.smartsockets.hub.connections.ClientMessage;
import ibis.smartsockets.hub.connections.HubConnection;
import ibis.smartsockets.hub.connections.MessageForwardingConnectionStatistics;
import ibis.smartsockets.hub.connections.VirtualConnection;
import ibis.smartsockets.hub.connections.VirtualConnectionIndex;
import ibis.smartsockets.hub.connections.VirtualConnections;
import ibis.smartsockets.hub.state.DirectionsSelector;
import ibis.smartsockets.hub.state.HubDescription;
import ibis.smartsockets.hub.state.HubList;
import ibis.smartsockets.hub.state.HubsForClientSelector;
import ibis.smartsockets.util.MalformedAddressException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageForwardingConnection
extends BaseConnection {
    protected static final Logger meslogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.messages");
    protected static final Logger vclogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.connections.virtual");
    protected static final int DEFAULT_CREDITS = 10;
    protected final VirtualConnections virtualConnections;
    protected final VirtualConnectionIndex index;
    private final String name;
    private MessageForwardingConnectionStatistics stats;

    protected MessageForwardingConnection(DirectSocket s, DataInputStream in, DataOutputStream out, Connections connections, HubList hubs, VirtualConnections vcs, boolean master, String name, StatisticsCallback callback, long statisticsInterval) {
        super(s, in, out, connections, hubs, callback, statisticsInterval);
        this.name = name;
        this.virtualConnections = vcs;
        this.index = new VirtualConnectionIndex(master);
        this.stats = new MessageForwardingConnectionStatistics("Connection(" + name + ")");
    }

    private boolean directlyToHub(DirectSocketAddress hub, ClientMessage cm) {
        HubConnection c = this.connections.getHub(hub);
        if (c != null) {
            return c.forwardClientMessage(cm);
        }
        return false;
    }

    private void forwardMessageToHub(HubDescription p, ClientMessage cm) {
        HubDescription p2;
        if (meslogger.isDebugEnabled()) {
            meslogger.debug("Attempting to forward message to hub " + p.hubAddress);
        }
        if (this.directlyToHub(p.hubAddress, cm)) {
            if (meslogger.isDebugEnabled()) {
                meslogger.debug("Succesfully forwarded message to hub " + p.hubAddressAsString + " using direct link");
            }
            ++this.stats.infoMessagesForwarded;
            return;
        }
        if (cm.hopsLeft == 0) {
            if (meslogger.isInfoEnabled()) {
                meslogger.info("Failed to forward message to hub " + p.hubAddressAsString + " and we are not allowed to use an indirection!");
            }
            ++this.stats.infoMessagesDropped;
            return;
        }
        if (meslogger.isDebugEnabled()) {
            meslogger.debug("Failed to forward message to hub " + p.hubAddressAsString + " using direct link, trying indirection");
        }
        if ((p2 = p.getIndirection()) == null) {
            meslogger.warn("Cannot forward message. No route to hub: " + p.hubAddressAsString + " (indirection address is null!)");
            ++this.stats.infoMessagesDropped;
            return;
        }
        if (this.directlyToHub(p2.hubAddress, cm)) {
            if (meslogger.isDebugEnabled()) {
                meslogger.debug("Succesfully forwarded message to hub " + p2.hubAddressAsString + " using direct link");
            }
            ++this.stats.infoMessagesForwarded;
            return;
        }
        if (meslogger.isInfoEnabled()) {
            meslogger.info("Failed to forward message to hub " + p.hubAddressAsString + " or it's indirection " + p2.hubAddressAsString);
        }
        ++this.stats.infoMessagesDropped;
    }

    private boolean deliverLocally(ClientMessage cm) {
        boolean result;
        ClientConnection c = this.connections.getClient(cm.getTarget());
        if (c == null) {
            if (meslogger.isDebugEnabled()) {
                meslogger.debug("Cannot find client address locally: " + cm.getTarget());
            }
            return false;
        }
        if (meslogger.isDebugEnabled()) {
            if (cm.returnToSender) {
                meslogger.debug("Attempting to directly return message to sender " + cm.sourceAsString());
            } else {
                meslogger.debug("Attempting to directly forward message to client " + cm.targetAsString());
            }
        }
        if (result = c.forwardClientMessage(cm)) {
            ++this.stats.infoMessagesDelivered;
        } else {
            ++this.stats.infoMessagesFailed;
        }
        if (meslogger.isDebugEnabled()) {
            if (cm.returnToSender) {
                meslogger.debug("Directly return message to sender " + cm.sourceAsString() + (result ? " succeeded!" : "failed!"));
            } else {
                meslogger.debug("Directly forwarding message to client " + cm.targetAsString() + (result ? " succeeded!" : "failed!"));
            }
        }
        return result;
    }

    private boolean forwardToHub(ClientMessage cm, boolean setHops) {
        DirectSocketAddress hub = cm.getTargetHub();
        if (hub == null) {
            if (meslogger.isDebugEnabled()) {
                meslogger.debug("Target hub not set!");
            }
            return false;
        }
        HubDescription p = this.knownHubs.get(hub);
        if (p == null) {
            if (meslogger.isDebugEnabled()) {
                meslogger.debug("Target hub " + hub + " does not know client " + cm.getTarget());
            }
            return false;
        }
        if (setHops) {
            cm.hopsLeft = p.getHops();
        }
        this.forwardMessageToHub(p, cm);
        if (meslogger.isDebugEnabled()) {
            meslogger.debug("Directly forwarded message to hub: " + hub);
        }
        return true;
    }

    protected void forward(ClientMessage m, boolean setHops) {
        DirectSocketAddress hub;
        ++this.stats.infoMessages;
        this.stats.infoMessagesBytes += m.messageSize();
        if (m.getSourceHub() == null) {
            m.setSourceHub(this.getLocalHub());
        }
        if ((hub = m.getTargetHub()) == null) {
            if (this.deliverLocally(m)) {
                return;
            }
            HubsForClientSelector hss = new HubsForClientSelector(m.getTarget(), false);
            this.knownHubs.select(hss);
            LinkedList<HubDescription> result = hss.getResult();
            if (result.size() == 0) {
                if (m.returnToSender) {
                    if (meslogger.isDebugEnabled()) {
                        meslogger.debug("Cannot return message to sender, since it  has disappeared! (source= " + m.targetAsString() + " target=" + m.sourceAsString());
                    }
                } else {
                    if (meslogger.isDebugEnabled()) {
                        meslogger.debug("Return message to sender, since target is  not known! (source= " + m.sourceAsString() + " target=" + m.targetAsString());
                    }
                    this.returnToSender(m);
                }
                return;
            }
            for (HubDescription h : result) {
                if (setHops) {
                    m.hopsLeft = h.getHops();
                }
                this.forwardMessageToHub(h, m);
            }
        } else if (this.isLocalHub(hub)) {
            if (this.deliverLocally(m)) {
                return;
            }
            this.returnToSender(m);
        } else {
            if (this.forwardToHub(m, setHops)) {
                return;
            }
            this.returnToSender(m);
        }
    }

    private void returnToSender(ClientMessage m) {
        if (m.returnToSender) {
            return;
        }
        m.returnToSender = true;
        this.forward(m, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean forwardClientMessage(ClientMessage m) {
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.writeByte(69);
                m.write(this.out);
                this.out.flush();
            }
            return true;
        }
        catch (Exception e) {
            this.handleDisconnect(e);
            if (meslogger.isDebugEnabled()) {
                meslogger.debug("Forwarding message failed: " + m, (Throwable)e);
            } else {
                meslogger.warn("Forwarding message failed: " + m, (Throwable)e);
            }
            return false;
        }
    }

    protected final void handleCreateVirtual() throws IOException {
        DirectSocketAddress source = DirectSocketAddress.read(this.in);
        DirectSocketAddress sourceHub = DirectSocketAddress.read(this.in);
        DirectSocketAddress target = DirectSocketAddress.read(this.in);
        DirectSocketAddress targetHub = DirectSocketAddress.read(this.in);
        long index = this.in.readLong();
        int timeout = this.in.readInt();
        int port = this.in.readInt();
        int fragment = this.in.readInt();
        int buffer = this.in.readInt();
        if (vclogger.isInfoEnabled()) {
            vclogger.info("VC connection request for: " + index);
        }
        if (vclogger.isDebugEnabled()) {
            vclogger.debug("Creating virtual connection " + source + " -->> " + target);
        }
        this.processVirtualConnect(source, sourceHub, target, targetHub, index, timeout, port, fragment, buffer);
    }

    protected final void handleCloseVirtual() throws IOException {
        long index = this.in.readLong();
        if (vclogger.isInfoEnabled()) {
            vclogger.info("Locally closing VC: " + index);
        }
        this.closeVirtualConnection(index);
    }

    private final void skipBytes(int bytes) throws IOException {
        while (bytes > 0) {
            bytes -= this.in.skipBytes(bytes);
        }
    }

    protected final void handleMessageVirtual() throws IOException {
        long index = this.in.readLong();
        int size = this.in.readInt();
        ++this.stats.messages;
        this.stats.messagesBytes += (long)size;
        String key = this.getUniqueID(index);
        VirtualConnection vc = this.virtualConnections.find(key);
        if (vc == null) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("Lost message! " + index + "[" + size + "] target VC not found!");
            }
            ++this.stats.messagesLost;
            this.skipBytes(size);
            this.forwardVirtualClose(index);
            return;
        }
        if (this == vc.mfc1) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward message " + index + " " + vc.index2 + " (" + vc.index1 + ")");
            }
            this.in.readFully(vc.buffer1, 0, size);
            vc.mfc2.forwardVirtualMessage(vc.index2, vc.buffer1, size);
        } else if (this == vc.mfc2) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward message " + index + " " + vc.index1 + " (" + vc.index2 + ")");
            }
            this.in.readFully(vc.buffer2, 0, size);
            vc.mfc1.forwardVirtualMessage(vc.index1, vc.buffer2, size);
        } else {
            ++this.stats.messagesError;
            this.skipBytes(size);
            vclogger.error("Virtual connection error: forwarder not found, message lost!!!", (Throwable)new Exception());
        }
    }

    protected final void handleMessageVirtualAck() throws IOException {
        long index = this.in.readLong();
        int data = this.in.readInt();
        this.processMessageACK(index, data);
    }

    protected final void handleACKCreateVirtualConnection() throws IOException {
        long index = this.in.readLong();
        int fragment = this.in.readInt();
        int buffer = this.in.readInt();
        this.processVirtualConnectACK(index, fragment, buffer);
    }

    protected final void handleACKACKCreateVirtualConnection() throws IOException {
        long index = this.in.readLong();
        boolean succes = this.in.readBoolean();
        this.processVirtualConnectACKACK(index, succes);
    }

    protected final void handleNACKCreateVirtualConnection() throws IOException {
        long index = this.in.readLong();
        byte reason = this.in.readByte();
        this.processVirtualConnectNACK(index, reason);
    }

    protected final void handleClientMessage() throws IOException {
        ClientMessage cm = new ClientMessage(this.in);
        if (meslogger.isDebugEnabled()) {
            meslogger.debug("Got info message: " + cm);
        }
        this.forward(cm, false);
    }

    private void forwardData(byte[] data) throws UnknownHostException, MalformedAddressException {
    }

    protected final void handleDataMessage() throws IOException {
        int len = this.in.readInt();
        byte[] data = new byte[len];
        this.in.readFully(data);
        if (meslogger.isDebugEnabled()) {
            meslogger.debug("Got data message: [" + data.length + "]");
        }
        try {
            this.forwardData(data);
        }
        catch (Exception e) {
            meslogger.warn("Failed to process data message: [" + data.length + "]", (Throwable)e);
        }
    }

    protected abstract void handleDisconnect(Exception var1);

    protected abstract String getUniqueID(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forwardVirtualConnect(DirectSocketAddress source, DirectSocketAddress sourceHub, DirectSocketAddress target, DirectSocketAddress targetHub, long index, int timeout, int port, int fragment, int buffer) {
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(60);
                DirectSocketAddress.write(source, this.out);
                DirectSocketAddress.write(sourceHub, this.out);
                DirectSocketAddress.write(target, this.out);
                DirectSocketAddress.write(targetHub, this.out);
                this.out.writeLong(index);
                this.out.writeInt(timeout);
                this.out.writeInt(port);
                this.out.writeInt(fragment);
                this.out.writeInt(buffer);
                this.out.flush();
            }
        }
        catch (Exception e) {
            this.handleDisconnect(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forwardVirtualConnectACK(long index, int fragment, int buffer) {
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.writeByte(61);
                this.out.writeLong(index);
                this.out.writeInt(fragment);
                this.out.writeInt(buffer);
                this.out.flush();
            }
        }
        catch (Exception e) {
            this.handleDisconnect(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forwardVirtualConnectACKACK(long index, boolean succes) {
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.writeByte(63);
                this.out.writeLong(index);
                this.out.writeBoolean(succes);
                this.out.flush();
            }
        }
        catch (Exception e) {
            this.handleDisconnect(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forwardVirtualConnectNACK(long index, byte reason) {
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.writeByte(62);
                this.out.writeLong(index);
                this.out.writeByte(reason);
                this.out.flush();
            }
        }
        catch (Exception e) {
            this.handleDisconnect(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forwardVirtualClose(long index) {
        if (vclogger.isInfoEnabled()) {
            vclogger.info("Sending closing connection: " + index);
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(64);
                this.out.writeLong(index);
                this.out.flush();
            }
        }
        catch (Exception e) {
            this.handleDisconnect(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forwardVirtualMessage(long index, byte[] data, int size) {
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(65);
                this.out.writeLong(index);
                this.out.writeInt(size);
                this.out.write(data, 0, size);
                this.out.flush();
            }
        }
        catch (Exception e) {
            this.handleDisconnect(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forwardVirtualMessageAck(long index, int data) {
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(66);
                this.out.writeLong(index);
                this.out.writeInt(data);
                this.out.flush();
            }
        }
        catch (Exception e) {
            this.handleDisconnect(e);
        }
    }

    private void processMessageACK(long index, int data) {
        ++this.stats.messageACK;
        String key = this.getUniqueID(index);
        VirtualConnection vc = this.virtualConnections.find(key);
        if (vc == null) {
            ++this.stats.messageACKLost;
            this.forwardVirtualClose(index);
            return;
        }
        if (this == vc.mfc1) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward connect ACK for 2: " + vc.index2);
            }
            vc.mfc2.forwardVirtualMessageAck(vc.index2, data);
        } else if (this == vc.mfc2) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward connect ACK for 1: " + vc.index1);
            }
            vc.mfc1.forwardVirtualMessageAck(vc.index1, data);
        } else {
            ++this.stats.messageACK_Error;
            vclogger.error("Virtual connection error: forwarder not found!", (Throwable)new Exception());
        }
    }

    private void closeVirtualConnection(long index) {
        ++this.stats.closeTotal;
        String id = this.getUniqueID(index);
        VirtualConnection vc = this.virtualConnections.remove(id);
        if (vc == null) {
            ++this.stats.closeLost;
            if (vclogger.isInfoEnabled()) {
                vclogger.info("Virtual connection " + index + " not found!");
            }
            return;
        }
        if (vclogger.isInfoEnabled()) {
            vclogger.info("Close virtual connection: " + vc);
        }
        if (this == vc.mfc1) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward close for 2: " + vc.index2);
            }
            vc.mfc2.forwardVirtualClose(vc.index2);
        } else if (this == vc.mfc2) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward close for 1: " + vc.index1);
            }
            vc.mfc1.forwardVirtualClose(vc.index1);
        } else {
            ++this.stats.closeError;
            vclogger.error("Virtual connection error: forwarder not found!", (Throwable)new Exception());
        }
    }

    private VirtualConnection createConnection(MessageForwardingConnection mfc1, String id1, long index1, int fragment1) {
        long index2 = this.index.nextIndex();
        String id2 = this.getUniqueID(index2);
        return new VirtualConnection(mfc1, id1, index1, fragment1, this, id2, index2);
    }

    private void processVirtualConnect(DirectSocketAddress source, DirectSocketAddress sourceHub, DirectSocketAddress target, DirectSocketAddress targetHub, long index, int timeout, int port, int fragment, int buffer) {
        ++this.stats.connectionsTotal;
        if (vclogger.isInfoEnabled()) {
            vclogger.info("ANY connection request for: " + index + " to " + target);
        }
        MessageForwardingConnection mf = null;
        ClientConnection tmp = this.connections.getClient(target);
        if (tmp != null) {
            if (tmp == this) {
                this.forwardVirtualConnectNACK(index, (byte)5);
                ++this.stats.connectionsFailed;
                return;
            }
            mf = tmp;
        }
        if (mf == null && targetHub != null && (mf = this.connections.getHub(targetHub)) == null) {
            HubDescription d = this.knownHubs.get(targetHub);
            if (d != null) {
                HubDescription indirect = d.getIndirection();
                if (indirect != null && indirect.haveConnection()) {
                    mf = this.connections.getHub(indirect.hubAddress);
                } else if (vclogger.isInfoEnabled()) {
                    vclogger.info("Failed to find indirection for hub: " + targetHub + " during virtual connection setup (" + source + " -> " + target + ") : " + index);
                }
            } else if (vclogger.isInfoEnabled()) {
                vclogger.info("Failed to find hub: " + targetHub + " during virtual connection setup (" + source + " -> " + target + ") : " + index);
            }
        }
        if (mf == null) {
            DirectionsSelector ds = new DirectionsSelector(target, false);
            this.knownHubs.select(ds);
            LinkedList<DirectSocketAddress> result = ds.getResult();
            if (result.size() > 0) {
                mf = this.connections.getHub(result.get(0));
            }
        }
        if (mf == null) {
            this.forwardVirtualConnectNACK(index, (byte)4);
            ++this.stats.connectionsFailed;
            return;
        }
        String id = this.getUniqueID(index);
        VirtualConnection vc = super.createConnection(this, id, index, fragment);
        this.virtualConnections.register(vc);
        mf.forwardVirtualConnect(source, sourceHub, target, targetHub, vc.index2, timeout, port, fragment, buffer);
    }

    private void processVirtualConnectNACK(long index, byte reason) {
        VirtualConnection vc;
        ++this.stats.connectionsReplies;
        ++this.stats.connectionsNACKs;
        if (vclogger.isDebugEnabled()) {
            vclogger.debug("Got connect NACK: " + index + " " + reason);
        }
        if ((vc = this.virtualConnections.remove(this.getUniqueID(index))) == null) {
            return;
        }
        if (this == vc.mfc1) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward connect NACK for 2: " + vc.index2);
            }
            vc.mfc2.forwardVirtualConnectNACK(vc.index2, reason);
        } else if (this == vc.mfc2) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward connect NACK for 1: " + vc.index1);
            }
            vc.mfc1.forwardVirtualConnectNACK(vc.index1, reason);
        } else {
            ++this.stats.connectionsRepliesError;
            vclogger.error("Virtual connection error: forwarder not found!", (Throwable)new Exception());
        }
    }

    private void processVirtualConnectACK(long index, int fragment, int buffer) {
        String key;
        VirtualConnection vc;
        ++this.stats.connectionsReplies;
        ++this.stats.connectionsACKs;
        if (vclogger.isDebugEnabled()) {
            vclogger.debug("Got connect ACK: " + index + " (" + fragment + ", " + buffer + ")");
        }
        if ((vc = this.virtualConnections.find(key = this.getUniqueID(index))) == null) {
            this.forwardVirtualClose(index);
            ++this.stats.connectionsRepliesLost;
            return;
        }
        vc.setSecondBuffer(fragment);
        if (this == vc.mfc2) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward connect ACK for 1: " + vc.index1);
            }
            vc.mfc1.forwardVirtualConnectACK(vc.index1, fragment, buffer);
        } else {
            ++this.stats.connectionsRepliesError;
            vclogger.error("Virtual connection setup error: got ACK on wrong connection!", (Throwable)new Exception());
        }
    }

    private void processVirtualConnectACKACK(long index, boolean succes) {
        String key;
        VirtualConnection vc;
        ++this.stats.connectionsReplies;
        ++this.stats.connectionsACKs;
        if (vclogger.isDebugEnabled()) {
            vclogger.debug("Got connect ACK ACK: " + index + ")");
        }
        if ((vc = this.virtualConnections.find(key = this.getUniqueID(index))) == null) {
            this.forwardVirtualClose(index);
            ++this.stats.connectionsRepliesLost;
            return;
        }
        if (this == vc.mfc1) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("forward connect ACK ACK for 2: " + vc.index2);
            }
            vc.mfc2.forwardVirtualConnectACKACK(vc.index2, succes);
        } else {
            ++this.stats.connectionsRepliesError;
            vclogger.error("Virtual connection setup error: got ACK ACK on wrong connection!", (Throwable)new Exception());
        }
    }

    protected void closeAllVirtualConnections(String prefix) {
        LinkedList<VirtualConnection> l = this.virtualConnections.removeAll(prefix);
        for (VirtualConnection vc : l) {
            if (this == vc.mfc1) {
                if (vclogger.isInfoEnabled()) {
                    vclogger.info("forward close for 2: " + vc.index2);
                }
                vc.mfc2.forwardVirtualClose(vc.index2);
                ++this.stats.closeTotal;
                continue;
            }
            if (this == vc.mfc2) {
                if (vclogger.isInfoEnabled()) {
                    vclogger.info("forward close for 1: " + vc.index1);
                }
                ++this.stats.closeTotal;
                vc.mfc1.forwardVirtualClose(vc.index1);
                continue;
            }
            ++this.stats.closeError;
            vclogger.warn("Virtual connection error: forwarder not found!", (Throwable)new Exception());
        }
    }

    @Override
    protected synchronized Statistics getStatistics() {
        this.stats.setEndTime();
        MessageForwardingConnectionStatistics tmp = this.stats;
        this.stats = new MessageForwardingConnectionStatistics("Connection(" + this.name + ")");
        return tmp;
    }

    protected abstract boolean handleOpcode(int var1);

    @Override
    protected final boolean runConnection() {
        try {
            int opcode = this.in.read();
            switch (opcode) {
                case -1: 
                case 5: {
                    if (vclogger.isInfoEnabled()) {
                        vclogger.info("Connection got disconnect(" + opcode + ")!");
                    }
                    this.handleDisconnect(null);
                    return false;
                }
                case 69: {
                    if (meslogger.isInfoEnabled()) {
                        meslogger.info("HubConnection got info message!");
                    }
                    this.handleClientMessage();
                    return true;
                }
                case 68: {
                    if (meslogger.isInfoEnabled()) {
                        meslogger.info("HubConnection got data message!");
                    }
                    this.handleDataMessage();
                    return true;
                }
                case 60: {
                    if (meslogger.isInfoEnabled()) {
                        meslogger.info("HubConnection got virtual connect!");
                    }
                    this.handleCreateVirtual();
                    return true;
                }
                case 61: {
                    if (meslogger.isInfoEnabled()) {
                        meslogger.info("HubConnection got virtual connect ACK!");
                    }
                    this.handleACKCreateVirtualConnection();
                    return true;
                }
                case 63: {
                    if (meslogger.isInfoEnabled()) {
                        meslogger.info("HubConnection got virtual connect ACK ACK!");
                    }
                    this.handleACKACKCreateVirtualConnection();
                    return true;
                }
                case 62: {
                    if (meslogger.isInfoEnabled()) {
                        meslogger.info("HubConnection got virtual connect NACK!");
                    }
                    this.handleNACKCreateVirtualConnection();
                    return true;
                }
                case 64: {
                    if (meslogger.isInfoEnabled()) {
                        meslogger.info("HubConnection got virtual reply!");
                    }
                    this.handleCloseVirtual();
                    return true;
                }
                case 65: {
                    if (meslogger.isInfoEnabled()) {
                        meslogger.info("HubConnection got virtual message!");
                    }
                    this.handleMessageVirtual();
                    return true;
                }
                case 66: {
                    if (meslogger.isInfoEnabled()) {
                        meslogger.info("HubConnection got virtual ack!");
                    }
                    this.handleMessageVirtualAck();
                    return true;
                }
            }
            return this.handleOpcode(opcode);
        }
        catch (SocketTimeoutException e) {
            return true;
        }
        catch (Exception e) {
            this.handleDisconnect(e);
            return false;
        }
    }
}

