/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.connections.ClientConnection;
import ibis.smartsockets.hub.connections.HubConnection;
import ibis.smartsockets.hub.connections.MessageForwardingConnection;
import java.util.HashMap;
import java.util.Map;

public class Connections {
    private final Map<DirectSocketAddress, HubConnection> hubs = new HashMap<DirectSocketAddress, HubConnection>();
    private final Map<DirectSocketAddress, ClientConnection> clients = new HashMap<DirectSocketAddress, ClientConnection>();

    public synchronized void put(DirectSocketAddress a, ClientConnection c) {
        this.clients.put(a, c);
    }

    public synchronized void put(DirectSocketAddress a, HubConnection c) {
        this.hubs.put(a, c);
    }

    public synchronized HubConnection getHub(DirectSocketAddress a) {
        return this.hubs.get(a);
    }

    public synchronized ClientConnection getClient(DirectSocketAddress a) {
        return this.clients.get(a);
    }

    public synchronized boolean removeClient(DirectSocketAddress a) {
        return this.clients.remove(a) != null;
    }

    public synchronized boolean removeHub(DirectSocketAddress a) {
        return this.hubs.remove(a) != null;
    }

    public synchronized MessageForwardingConnection getAny(DirectSocketAddress a) {
        HubConnection tmp = this.getHub(a);
        if (tmp != null) {
            return tmp;
        }
        return this.getClient(a);
    }

    public synchronized int numberOfConnections() {
        return this.clients.size() + this.hubs.size();
    }

    public synchronized int numberOfClients() {
        return this.clients.size();
    }

    public synchronized int numberOfHubs() {
        return this.hubs.size();
    }

    public synchronized DirectSocketAddress[] clients() {
        return this.clients.keySet().toArray(new DirectSocketAddress[this.clients.size()]);
    }

    public synchronized DirectSocketAddress[] hubs() {
        return this.hubs.keySet().toArray(new DirectSocketAddress[this.hubs.size()]);
    }
}

