/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.discovery;

import ibis.smartsockets.discovery.Callback;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCallback
implements Callback {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.discovery");
    private final LinkedList<String> messages = new LinkedList();
    private final boolean quitAfterMessage;

    public SimpleCallback(boolean quitAfterMessage) {
        this.quitAfterMessage = quitAfterMessage;
    }

    public synchronized String get(long timeout) {
        long end = System.currentTimeMillis() + timeout;
        long left = timeout;
        while (this.messages.size() == 0) {
            try {
                this.wait(left);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            left = end - System.currentTimeMillis();
            if (timeout <= 0L || left > 0L) continue;
            return null;
        }
        return this.messages.removeFirst();
    }

    @Override
    public synchronized boolean gotMessage(String message) {
        if (message != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Received: \"" + message + "\"");
            }
            this.messages.addLast(message);
            this.notifyAll();
            return !this.quitAfterMessage;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Discarding message: <null>");
        }
        return true;
    }
}

