/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.util.TypedProperties;
import java.util.StringTokenizer;

public class PortRange {
    private Range ranges;
    private int port = -1;

    PortRange(TypedProperties p) {
        String range = p.getProperty("smartsockets.port.range");
        if (range == null || range.length() == 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(range, ",");
        while (tok.hasMoreTokens()) {
            int start;
            int end;
            String t = tok.nextToken();
            int index = t.indexOf(45);
            if (index == -1) {
                start = end = Integer.parseInt(t);
            } else {
                start = Integer.parseInt(t.substring(0, index));
                end = Integer.parseInt(t.substring(index + 1));
            }
            this.add(start, end);
        }
    }

    private void add(int start, int end) {
        Range range = new Range(start, end);
        if (this.ranges == null) {
            this.ranges = range;
            range.next = null;
        } else {
            range.next = this.ranges;
            this.ranges = range;
        }
    }

    int getPort() {
        if (this.ranges == null) {
            return 0;
        }
        if (this.port == -1) {
            this.port = this.ranges.start;
        } else {
            ++this.port;
            if (this.port > this.ranges.end) {
                this.ranges = this.ranges.next;
                this.port = this.ranges.start;
            }
        }
        return this.port;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("[");
        Range r = this.ranges;
        while (r != null) {
            tmp.append(r.toString());
            r = r.next;
            if (r == null) continue;
            tmp.append(",");
        }
        tmp.append("]");
        return tmp.toString();
    }

    static final class Range {
        final int start;
        final int end;
        Range next;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            if (this.start == this.end) {
                return "" + this.start;
            }
            return this.start + "-" + this.end;
        }
    }
}

