/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.direct.DirectSocketAddress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.channels.SocketChannel;

public abstract class DirectSocket {
    protected final InputStream in;
    protected final OutputStream out;
    protected final DirectSocketAddress local;
    protected final DirectSocketAddress remote;
    private int userData;

    DirectSocket(DirectSocketAddress local, DirectSocketAddress remote, InputStream in, OutputStream out) {
        this.local = local;
        this.remote = remote;
        this.in = in;
        this.out = out;
    }

    public int getUserData() {
        return this.userData;
    }

    public void setUserData(int userData) {
        this.userData = userData;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public DirectSocketAddress getLocalAddress() {
        return this.local;
    }

    public DirectSocketAddress getRemoteAddress() {
        return this.remote;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isConnected() {
        return !this.isClosed();
    }

    public abstract int getLocalPort() throws IOException;

    public abstract void close() throws IOException;

    public abstract boolean isClosed();

    public abstract void setReceiveBufferSize(int var1) throws SocketException;

    public abstract int getReceiveBufferSize() throws SocketException;

    public abstract void setSendBufferSize(int var1) throws SocketException;

    public abstract int getSendBufferSize() throws SocketException;

    public abstract void setSoTimeout(int var1) throws SocketException;

    public abstract int getSoTimeout() throws SocketException;

    public abstract void setTcpNoDelay(boolean var1) throws SocketException;

    public abstract boolean getTcpNoDelay() throws SocketException;

    public abstract void setKeepAlive(boolean var1) throws SocketException;

    public abstract boolean getKeepAlive() throws SocketException;

    public abstract SocketChannel getChannel();

    public abstract void setSoLinger(boolean var1, int var2) throws SocketException;

    public abstract int getSoLinger() throws SocketException;

    public abstract void setReuseAddress(boolean var1) throws SocketException;

    public abstract boolean getReuseAddress() throws SocketException;

    public abstract void shutdownInput() throws IOException;

    public abstract boolean isInputShutdown();

    public abstract void shutdownOutput() throws IOException;

    public abstract boolean isOutputShutdown();
}

