/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

public final class Stats {
    private Stats() {
    }

    public static double mean(double[] data) {
        return Stats.mean(data, 0, data.length);
    }

    public static double mean(double[] data, int off, int len) {
        double total = 0.0;
        for (int i = off; i < off + len; ++i) {
            total += data[i];
        }
        if (len == 0) {
            return 0.0;
        }
        return total / (double)len;
    }

    public static double stdDev(double[] data) {
        return Stats.stdDev(data, 0, data.length);
    }

    public static double stdDev(double[] data, int off, int len) {
        double mean = Stats.mean(data, off, len);
        double sum = 0.0;
        for (int i = off; i < off + len; ++i) {
            double v = data[i] - mean;
            sum += v * v;
        }
        if (len <= 1) {
            return 0.0;
        }
        return Math.sqrt(sum / (double)(len - 1));
    }

    public static double mbs(double bytes, double millis) {
        return Stats.round(bytes / millis * 1000.0 / 1048576.0);
    }

    public static double mbs(double bytes, double[] millis, int off, int len) {
        double mean = Stats.mean(millis, off, len);
        return Stats.mbs(bytes, mean);
    }

    public static double round(double v) {
        return Math.ceil(v * 100.0) / 100.0;
    }

    public static double stdDevError(double[] data, int off, int len) {
        double mean = Stats.mean(data, off, len);
        double stdDev = Stats.stdDev(data, off, len);
        return Stats.round(stdDev / mean * 100.0);
    }
}

