/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import ibis.util.Monitor;
import java.io.PrintStream;

public final class ConditionVariable {
    private Monitor lock;
    private final boolean INTERRUPTIBLE;
    static long waits;
    static long timed_waits;
    static long signals;
    static long bcasts;

    ConditionVariable(Monitor lock, boolean interruptible) {
        this.lock = lock;
        this.INTERRUPTIBLE = interruptible;
    }

    ConditionVariable(Monitor lock) {
        this(lock, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cv_wait() throws InterruptedException {
        this.lock.checkImOwner();
        if (Monitor.STATISTICS) {
            ++waits;
        }
        try {
            ConditionVariable conditionVariable = this;
            synchronized (conditionVariable) {
                this.lock.unlock();
                if (this.INTERRUPTIBLE) {
                    this.wait();
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean cv_wait(long timeout) throws InterruptedException {
        this.lock.checkImOwner();
        if (Monitor.STATISTICS) {
            ++timed_waits;
        }
        boolean timedOut = false;
        try {
            ConditionVariable conditionVariable = this;
            synchronized (conditionVariable) {
                long now = System.currentTimeMillis();
                this.lock.unlock();
                if (this.INTERRUPTIBLE) {
                    this.wait(timeout);
                } else {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                timedOut = System.currentTimeMillis() - now >= timeout;
            }
        }
        finally {
            this.lock.lock();
        }
        return timedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cv_signal() {
        this.lock.checkImOwner();
        if (Monitor.STATISTICS) {
            ++signals;
        }
        ConditionVariable conditionVariable = this;
        synchronized (conditionVariable) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cv_bcast() {
        this.lock.checkImOwner();
        if (Monitor.STATISTICS) {
            ++bcasts;
        }
        ConditionVariable conditionVariable = this;
        synchronized (conditionVariable) {
            this.notifyAll();
        }
    }

    public static void report(PrintStream out) {
        if (Monitor.STATISTICS) {
            out.println("Condition variables: wait " + waits + " timed wait " + timed_waits + " signal " + signals + " bcast " + bcasts);
        }
    }
}

