/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.impl.Ibis;

public class RegistryEventHandlerWrapper
implements RegistryEventHandler {
    private final RegistryEventHandler handler;
    private final Ibis ibis;

    public RegistryEventHandlerWrapper(RegistryEventHandler h, Ibis i) {
        this.handler = h;
        this.ibis = i;
    }

    public void died(IbisIdentifier corpse) {
        if (this.handler != null) {
            this.handler.died(corpse);
        }
        this.ibis.died(corpse);
    }

    public void electionResult(String electionName, IbisIdentifier winner) {
        if (this.handler != null) {
            this.handler.electionResult(electionName, winner);
        }
    }

    public void gotSignal(String signal, IbisIdentifier source) {
        if (this.handler != null) {
            this.handler.gotSignal(signal, source);
        }
    }

    public void joined(IbisIdentifier joinedIbis) {
        if (this.handler != null) {
            this.handler.joined(joinedIbis);
        }
    }

    public void left(IbisIdentifier leftIbis) {
        if (this.handler != null) {
            this.handler.left(leftIbis);
        }
        this.ibis.left(leftIbis);
    }

    public void poolClosed() {
        if (this.handler != null) {
            this.handler.poolClosed();
        }
    }

    public void poolTerminated(IbisIdentifier source) {
        if (this.handler != null) {
            this.handler.poolTerminated(source);
        }
    }
}

