/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.io.SerializationInput;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.ReceivePort;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.ReceivePortConnectionInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public class ReadMessage
implements ibis.ipl.ReadMessage {
    protected SerializationInput in;
    protected ReceivePortConnectionInfo info;
    protected boolean isFinished = false;
    protected long before;
    protected long sequenceNr = -1L;
    protected boolean inUpcall = false;
    protected boolean finishCalledFromUpcall = false;

    public ReadMessage(SerializationInput in, ReceivePortConnectionInfo info) {
        this.in = in;
        this.info = info;
        this.before = info.bytesRead();
    }

    public ReceivePort localPort() {
        return this.info.port;
    }

    public void setInUpcall(boolean val) {
        this.inUpcall = val;
    }

    public boolean getInUpcall() {
        return this.inUpcall;
    }

    public boolean finishCalledInUpcall() {
        return this.finishCalledFromUpcall;
    }

    public long bytesRead() {
        long after = this.info.bytesRead();
        return after - this.before;
    }

    public int remaining() throws IOException {
        return -1;
    }

    public int size() throws IOException {
        return -1;
    }

    public ReceivePortConnectionInfo getInfo() {
        return this.info;
    }

    public void setInfo(ReceivePortConnectionInfo info) {
        this.info = info;
    }

    protected final void checkNotFinished() throws IOException {
        if (this.isFinished) {
            throw new IOException("Operating on a message that was already finished");
        }
    }

    public SendPortIdentifier origin() {
        return this.info.origin;
    }

    protected int available() throws IOException {
        this.checkNotFinished();
        return this.in.available();
    }

    public boolean readBoolean() throws IOException {
        this.checkNotFinished();
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        this.checkNotFinished();
        return this.in.readByte();
    }

    public char readChar() throws IOException {
        this.checkNotFinished();
        return this.in.readChar();
    }

    public short readShort() throws IOException {
        this.checkNotFinished();
        return this.in.readShort();
    }

    public int readInt() throws IOException {
        this.checkNotFinished();
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        this.checkNotFinished();
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        this.checkNotFinished();
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        this.checkNotFinished();
        return this.in.readDouble();
    }

    public String readString() throws IOException {
        this.checkNotFinished();
        return this.in.readString();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        this.checkNotFinished();
        return this.in.readObject();
    }

    public void readArray(boolean[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(byte[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(char[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(short[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(int[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(long[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(float[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(double[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(Object[] destination) throws IOException, ClassNotFoundException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(boolean[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(byte[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(char[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(short[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(int[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(long[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(float[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(double[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(Object[] destination, int offset, int size) throws IOException, ClassNotFoundException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void setSequenceNumber(long s) {
        this.sequenceNr = s;
    }

    public long sequenceNumber() {
        if (!this.info.port.type.hasCapability("communication.numbered")) {
            throw new IbisConfigurationException("No COMMUNICATION_NUMBERED specified in port type");
        }
        return this.sequenceNr;
    }

    public long finish() throws IOException {
        this.checkNotFinished();
        this.in.clear();
        this.isFinished = true;
        if (this.inUpcall) {
            this.finishCalledFromUpcall = true;
            this.getInfo().upcallCalledFinish();
        }
        long after = this.info.bytesRead();
        long retval = after - this.before;
        this.before = after;
        this.info.port.finishMessage(this, retval);
        return retval;
    }

    public void finish(IOException e) {
        if (this.isFinished) {
            return;
        }
        if (this.inUpcall) {
            this.finishCalledFromUpcall = true;
        }
        this.info.port.finishMessage(this, e);
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished(boolean val) {
        this.isFinished = val;
        if (!this.isFinished) {
            this.before = this.info.bytesRead();
            this.finishCalledFromUpcall = false;
        }
    }

    public void readByteBuffer(ByteBuffer value) throws IOException, ReadOnlyBufferException {
        this.checkNotFinished();
        this.in.readByteBuffer(value);
    }
}

