/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.ipl.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class IbisIdentifier
implements ibis.ipl.IbisIdentifier {
    private static final long serialVersionUID = 3654888190542934889L;
    public final ibis.ipl.impl.Location location;
    public final String pool;
    private final byte[] implementationData;
    private final byte[] registryData;
    private final String id;
    private final byte[] tag;
    private transient byte[] codedForm;

    public IbisIdentifier(String id, byte[] implementationData, byte[] registryData, ibis.ipl.impl.Location location, String pool, byte[] tag) {
        this.id = id;
        this.implementationData = implementationData;
        this.registryData = registryData;
        this.location = location;
        this.pool = pool;
        this.tag = tag;
        this.codedForm = this.computeCodedForm();
    }

    public IbisIdentifier(byte[] codedForm) throws IOException {
        this(codedForm, 0, codedForm.length);
    }

    public IbisIdentifier(byte[] codedForm, int offset, int size) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(codedForm, offset, size)));
    }

    public IbisIdentifier(DataInput dis) throws IOException {
        this.location = new ibis.ipl.impl.Location(dis);
        this.pool = dis.readUTF();
        int implementationSize = dis.readInt();
        if (implementationSize < 0) {
            this.implementationData = null;
        } else {
            this.implementationData = new byte[implementationSize];
            dis.readFully(this.implementationData);
        }
        int registrySize = dis.readInt();
        if (registrySize < 0) {
            this.registryData = null;
        } else {
            this.registryData = new byte[registrySize];
            dis.readFully(this.registryData);
        }
        this.id = dis.readUTF();
        int tagSize = dis.readInt();
        if (tagSize < 0) {
            this.tag = null;
        } else {
            this.tag = new byte[tagSize];
            dis.readFully(this.tag);
        }
        this.codedForm = this.computeCodedForm();
    }

    public byte[] toBytes() {
        if (this.codedForm == null) {
            this.codedForm = this.computeCodedForm();
        }
        return (byte[])this.codedForm.clone();
    }

    private byte[] computeCodedForm() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            this.location.writeTo(dos);
            dos.writeUTF(this.pool);
            if (this.implementationData == null) {
                dos.writeInt(-1);
            } else {
                dos.writeInt(this.implementationData.length);
                dos.write(this.implementationData);
            }
            if (this.registryData == null) {
                dos.writeInt(-1);
            } else {
                dos.writeInt(this.registryData.length);
                dos.write(this.registryData);
            }
            dos.writeUTF(this.id);
            if (this.tag == null) {
                dos.writeInt(-1);
            } else {
                dos.writeInt(this.tag.length);
                dos.write(this.tag);
            }
            dos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void writeTo(DataOutput dos) throws IOException {
        if (this.codedForm == null) {
            this.codedForm = this.computeCodedForm();
        }
        dos.write(this.codedForm);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        IbisIdentifier other = (IbisIdentifier)o;
        return other.id.equals(this.id) && other.pool.equals(this.pool);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "(Ibis " + this.id + ", location " + this.location + ")";
    }

    public String name() {
        return "Ibis " + this.id;
    }

    public Location location() {
        return this.location;
    }

    public String poolName() {
        return this.pool;
    }

    public byte[] tag() {
        return this.tag;
    }

    public String tagAsString() {
        if (this.tag == null) {
            return null;
        }
        try {
            return new String(this.tag, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("could not convert tag to string", e);
        }
    }

    public byte[] getImplementationData() {
        return this.implementationData;
    }

    public byte[] getRegistryData() {
        return this.registryData;
    }

    public int compareTo(ibis.ipl.IbisIdentifier c) {
        if (c instanceof IbisIdentifier) {
            IbisIdentifier other = (IbisIdentifier)c;
            int cmp = this.pool.compareTo(other.pool);
            if (cmp == 0 && (cmp = this.location.compareTo(other.location)) == 0) {
                return this.id.compareTo(other.id);
            }
            return cmp;
        }
        return this.getClass().getName().compareTo(c.getClass().getName());
    }

    public String getID() {
        return this.id;
    }
}

