/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class DragNodeUI
extends TGAbstractDragUI {
    public Point dragOffs;

    public DragNodeUI(TGPanel tgp) {
        super(tgp);
    }

    public void preActivate() {
        if (this.dragOffs == null) {
            this.dragOffs = new Point(0, 0);
        }
    }

    public void preDeactivate() {
    }

    public void mousePressed(MouseEvent e) {
        Node mouseOverN = this.tgPanel.getMouseOverN();
        Point mousePos = e != null ? e.getPoint() : new Point((int)mouseOverN.drawx, (int)mouseOverN.drawy);
        if (mouseOverN != null) {
            this.tgPanel.setDragNode(mouseOverN);
            this.dragOffs.setLocation((int)(mouseOverN.drawx - (double)mousePos.x), (int)(mouseOverN.drawy - (double)mousePos.y));
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.tgPanel.setDragNode(null);
        this.tgPanel.repaintAfterMove();
        this.tgPanel.startDamper();
    }

    public synchronized void mouseDragged(MouseEvent e) {
        Node dragNode = this.tgPanel.getDragNode();
        dragNode.drawx = e.getX() + this.dragOffs.x;
        dragNode.drawy = e.getY() + this.dragOffs.y;
        this.tgPanel.updatePosFromDraw(dragNode);
        this.tgPanel.repaintAfterMove();
        this.tgPanel.stopDamper();
        e.consume();
    }
}

