/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.jclouds.domain.Location;
import org.jclouds.domain.MutableResourceMetadata;
import org.jclouds.domain.ResourceMetadata;

public class MutableResourceMetadataImpl<T extends Enum<T>>
implements MutableResourceMetadata<T> {
    private T type;
    private String id;
    private String name;
    private Location location;
    private URI uri;
    private Map<String, String> userMetadata;

    public MutableResourceMetadataImpl() {
        this.userMetadata = Maps.newLinkedHashMap();
    }

    public MutableResourceMetadataImpl(ResourceMetadata<T> from) {
        this.type = from.getType();
        this.id = from.getProviderId();
        this.name = from.getName();
        this.location = from.getLocation();
        this.uri = from.getUri();
        this.userMetadata = from.getUserMetadata();
    }

    @Override
    public int compareTo(ResourceMetadata<T> o) {
        if (this.getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProviderId() {
        return this.id;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setType(T type) {
        this.type = type;
    }

    @Override
    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").omitNullValues().add("id", (Object)this.id).add("location", (Object)this.location).add("name", (Object)this.name).add("type", this.getType()).add("uri", (Object)this.uri).add("userMetadata", this.userMetadata);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.location, this.name, this.type, this.uri});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutableResourceMetadata)) {
            return false;
        }
        MutableResourceMetadata other = (MutableResourceMetadata)obj;
        return Objects.equal((Object)this.id, (Object)other.getProviderId()) && Objects.equal((Object)this.location, (Object)other.getLocation()) && Objects.equal((Object)this.name, (Object)other.getName()) && Objects.equal(this.type, other.getType()) && Objects.equal((Object)this.uri, (Object)other.getUri());
    }
}

