/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile;

import ibis.compile.BCELClassInfo;
import ibis.compile.ByteCodeWrapper;
import ibis.compile.ClassInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class BCELWrapper
implements ByteCodeWrapper {
    private HashMap<String, BCELClassInfo> javaClasses = new HashMap();

    public BCELWrapper(List<String> args) {
    }

    @Override
    public ClassInfo getInfo(Object o) {
        JavaClass cl = (JavaClass)o;
        String name = cl.getClassName();
        BCELClassInfo e = this.javaClasses.get(name);
        if (e == null) {
            e = new BCELClassInfo(cl);
            this.javaClasses.put(name, e);
        }
        e.setClassObject(cl);
        return e;
    }

    @Override
    public ClassInfo parseClassFile(String fileName) throws IOException {
        ClassParser parser = new ClassParser(fileName);
        JavaClass cl = parser.parse();
        Repository.addClass((JavaClass)cl);
        String name = cl.getClassName();
        BCELClassInfo e = this.javaClasses.get(name);
        if (e == null) {
            e = new BCELClassInfo(cl);
            this.javaClasses.put(name, e);
        }
        e.setClassObject(cl);
        Repository.addClass((JavaClass)cl);
        return e;
    }

    @Override
    public ClassInfo parseInputStream(InputStream in, String fileName) throws IOException {
        JavaClass cl = new ClassParser(in, fileName).parse();
        in.close();
        Repository.addClass((JavaClass)cl);
        String name = cl.getClassName();
        BCELClassInfo e = this.javaClasses.get(name);
        if (e == null) {
            e = new BCELClassInfo(cl);
            this.javaClasses.put(name, e);
        }
        e.setClassObject(cl);
        Repository.addClass((JavaClass)cl);
        return e;
    }
}

