/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import ibis.io.rewriter.JMERewriterConstants;
import ibis.io.rewriter.SerializationInfo;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

class JMESerializationInfo
extends SerializationInfo
implements JMERewriterConstants {
    static boolean isJMESpecialCase(JavaClass clazz) {
        String className = clazz.getClassName();
        return "java.lang.Object".equals(className) || "java.lang.Boolean".equals(className) || "java.lang.Byte".equals(className) || "java.lang.Short".equals(className) || "java.lang.Integer".equals(className) || "java.lang.Long".equals(className) || "java.lang.Float".equals(className) || "java.lang.Double".equals(className) || "java.lang.Character".equals(className);
    }

    static boolean isJMESerializable(JavaClass clazz) {
        try {
            return Repository.implementationOf((JavaClass)clazz, (String)"ibis.io.jme.Serializable");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    static boolean isJMERewritten(JavaClass clazz) {
        try {
            return Repository.implementationOf((JavaClass)clazz, (String)"ibis.io.jme.JMESerializable");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    static boolean isJMEExternalizable(JavaClass clazz) {
        try {
            return Repository.implementationOf((JavaClass)clazz, (String)"ibis.io.jme.Externalizable");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    static boolean hasJMESerialPersistentFields(Field[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.getName().equals("serialPersistentFields") || !f.isFinal() || !f.isStatic() || !f.isPrivate() || !f.getSignature().equals(TYPE_LIBIS_IO_JME_OBJECT_STREAM_FIELD)) continue;
            return true;
        }
        return false;
    }

    static boolean hasJMEConstructor(JavaClass cl) {
        Method[] clMethods = cl.getMethods();
        for (int i = 0; i < clMethods.length; ++i) {
            if (!clMethods[i].getName().equals("<init>") || !clMethods[i].getSignature().equals("(Libis/io/jme/ObjectInputStream;)V")) continue;
            return true;
        }
        return false;
    }

    JMESerializationInfo(String wn, String rn, String frn, Type t, boolean primitive) {
        super(wn, rn, frn, t, primitive);
    }
}

