/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import ibis.io.rewriter.CodeGenerator;
import ibis.io.rewriter.IOGenerator;
import ibis.io.rewriter.JMERewriterConstants;
import ibis.io.rewriter.JMESerializationInfo;
import ibis.io.rewriter.RewriterConstants;
import ibis.io.rewriter.SerializationInfo;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWITCH;
import org.apache.bcel.generic.Type;

class JMECodeGenerator
extends CodeGenerator
implements RewriterConstants,
JMERewriterConstants {
    boolean super_is_jme_serializable;
    boolean super_is_jme_special_case;
    boolean super_is_jme_rewritten;
    boolean super_has_jme_constructor;
    boolean is_jme_externalizable;
    boolean is_jme_abstract;
    boolean has_jme_serial_persistent_fields;

    public static JavaClass lookupClass(String name) {
        try {
            return Repository.lookupClass((String)name);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Warning: class " + name + " not found");
            return null;
        }
    }

    JMECodeGenerator(IOGenerator generator, JavaClass cl) {
        super(generator, cl);
        this.super_is_jme_special_case = JMESerializationInfo.isJMESpecialCase(this.super_class);
        this.super_is_jme_serializable = JMESerializationInfo.isJMESerializable(this.super_class);
        this.super_is_jme_rewritten = JMESerializationInfo.isJMERewritten(this.super_class);
        this.is_jme_externalizable = JMESerializationInfo.isJMEExternalizable(cl);
        this.is_jme_abstract = cl.isAbstract();
        this.super_has_jme_constructor = JMESerializationInfo.hasJMEConstructor(this.super_class);
        this.has_jme_serial_persistent_fields = JMESerializationInfo.hasJMESerialPersistentFields(this.fields);
        if (generator.isVerbose()) {
            System.out.println("Code Generator: " + cl.getClassName() + " sijs: " + this.super_is_jme_serializable + " sijr: " + this.super_is_jme_rewritten);
        }
    }

    private Instruction createGeneratedWriteObjectInvocation(String name, short invmode) {
        return this.factory.createInvoke(name, "generated_JME_WriteObject", (Type)Type.VOID, jme_output_stream_arrtp, invmode);
    }

    private Instruction createGeneratedDefaultReadObjectInvocation(String name, InstructionFactory fac, short invmode) {
        return fac.createInvoke(name, "generated_JME_DefaultReadObject", (Type)Type.VOID, new Type[]{jme_input_stream, Type.INT}, invmode);
    }

    private Instruction createInitInvocation(String name, InstructionFactory f) {
        return f.createInvoke(name, "<init>", (Type)Type.VOID, jme_input_stream_arrtp, (short)183);
    }

    private Instruction createGeneratedDefaultWriteObjectInvocation(String name) {
        return this.factory.createInvoke(name, "generated_JME_DefaultWriteObject", (Type)Type.VOID, new Type[]{jme_output_stream, Type.INT}, (short)183);
    }

    private int getClassDepth(JavaClass cl) {
        if (cl.getClassName().equals("java.lang.Object") || !JMESerializationInfo.isJMESerializable(cl)) {
            return 0;
        }
        return 1 + this.getClassDepth(JMECodeGenerator.lookupClass(cl.getSuperclassName()));
    }

    @Override
    void generateEmptyMethods() {
        if (this.generator.isVerbose()) {
            System.out.println("  Generating empty methods for class : " + this.classname);
            System.out.println("    " + this.classname + " implements java.io.jme.Serializable -> adding " + "ibis.io.jme.JMESerializable");
        }
        this.gen.addInterface("ibis.io.jme.JMESerializable");
        InstructionList il = new InstructionList();
        il.append((Instruction)new RETURN());
        int flags = 1 | (this.gen.isFinal() ? 16 : 0);
        MethodGen write_method = new MethodGen(flags, (Type)Type.VOID, jme_output_stream_arrtp, new String[]{"os"}, "generated_JME_WriteObject", this.classname, il, this.constantpool);
        write_method.addException("java.io.IOException");
        this.gen.addMethod(write_method.getMethod());
        il = new InstructionList();
        il.append((Instruction)new RETURN());
        MethodGen default_write_method = new MethodGen(flags, (Type)Type.VOID, new Type[]{jme_output_stream, Type.INT}, new String[]{"os", "lvl"}, "generated_JME_DefaultWriteObject", this.classname, il, this.constantpool);
        default_write_method.addException("java.io.IOException");
        this.gen.addMethod(default_write_method.getMethod());
        il = new InstructionList();
        il.append((Instruction)new RETURN());
        MethodGen default_read_method = new MethodGen(flags, (Type)Type.VOID, new Type[]{jme_input_stream, Type.INT}, new String[]{"os", "lvl"}, "generated_JME_DefaultReadObject", this.classname, il, this.constantpool);
        default_read_method.addException("java.io.IOException");
        default_read_method.addException("java.lang.ClassNotFoundException");
        this.gen.addMethod(default_read_method.getMethod());
        if (this.is_jme_externalizable || !this.super_is_jme_serializable || this.generator.forceGeneratedCalls() || this.super_has_jme_constructor) {
            il = new InstructionList();
            il.append((Instruction)new RETURN());
            MethodGen read_cons = new MethodGen(1, (Type)Type.VOID, jme_input_stream_arrtp, new String[]{"is"}, "<init>", this.classname, il, this.constantpool);
            read_cons.addException("java.io.IOException");
            read_cons.addException("java.lang.ClassNotFoundException");
            this.gen.addMethod(read_cons.getMethod());
        } else if (SerializationInfo.hasReadObject(this.methods)) {
            il = new InstructionList();
            il.append((Instruction)new RETURN());
            MethodGen readobjectWrapper = new MethodGen(1, (Type)Type.VOID, jme_input_stream_arrtp, new String[]{"is"}, "$readObjectWrapper$", this.classname, il, this.constantpool);
            readobjectWrapper.addException("java.io.IOException");
            readobjectWrapper.addException("java.lang.ClassNotFoundException");
            this.gen.addMethod(readobjectWrapper.getMethod());
        }
        JavaClass newclazz = this.gen.getJavaClass();
        this.generator.replace(this.clazz, newclazz);
        this.clazz = newclazz;
    }

    private InstructionList writeInstructions(Field field) {
        String field_sig = field.getSignature();
        Type field_type = Type.getType((String)field_sig);
        SerializationInfo info = SerializationInfo.getSerializationInfo(field_type);
        Type t = info.tp;
        InstructionList temp = new InstructionList();
        if (!info.primitive) {
            t = Type.getType((String)field_sig);
        }
        temp.append((Instruction)new ALOAD(1));
        temp.append((Instruction)new ALOAD(0));
        temp.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), t, (short)180));
        temp.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectOutputStream", info.write_name, (Type)Type.VOID, info.param_tp_arr, (short)182));
        return temp;
    }

    private InstructionList readInstructions(Field field, boolean from_constructor) {
        String field_sig = field.getSignature();
        Type field_type = Type.getType((String)field_sig);
        SerializationInfo info = SerializationInfo.getSerializationInfo(field_type);
        Type t = info.tp;
        InstructionList temp = new InstructionList();
        if (!info.primitive) {
            t = Type.getType((String)field_sig);
        }
        if (from_constructor || !field.isFinal()) {
            temp.append((Instruction)new ALOAD(0));
            temp.append((Instruction)new ALOAD(1));
            temp.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", info.read_name, info.tp, Type.NO_ARGS, (short)182));
            if (!info.primitive) {
                temp.append((Instruction)this.factory.createCheckCast((ReferenceType)t));
            }
            temp.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), t, (short)181));
        } else {
            Type[] typeArray;
            temp.append((Instruction)new ALOAD(1));
            temp.append((Instruction)new ALOAD(0));
            int ind = this.constantpool.addString(field.getName());
            temp.append((Instruction)new LDC(ind));
            ind = this.constantpool.addString(this.classname);
            temp.append((Instruction)new LDC(ind));
            if (!info.primitive) {
                int ind2 = this.constantpool.addString(field_sig);
                temp.append((Instruction)new LDC(ind2));
            }
            String string = info.final_read_name;
            if (info.primitive) {
                Type[] typeArray2 = new Type[3];
                typeArray2[0] = Type.OBJECT;
                typeArray2[1] = Type.STRING;
                typeArray = typeArray2;
                typeArray2[2] = Type.STRING;
            } else {
                Type[] typeArray3 = new Type[4];
                typeArray3[0] = Type.OBJECT;
                typeArray3[1] = Type.STRING;
                typeArray3[2] = Type.STRING;
                typeArray = typeArray3;
                typeArray3[3] = Type.STRING;
            }
            temp.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", string, (Type)Type.VOID, typeArray, (short)182));
        }
        return temp;
    }

    private String writeCallName(String name) {
        return "writeArray" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private InstructionList writeReferenceField(Field field) {
        Type field_type = Type.getType((String)field.getSignature());
        InstructionList write_il = new InstructionList();
        boolean isfinal = false;
        boolean isarray = false;
        JavaClass field_class = null;
        String basicname = null;
        if (this.generator.isVerbose()) {
            System.out.println("    writing reference field " + field.getName() + " of type " + field_type.getSignature());
        }
        if (field_type instanceof ObjectType) {
            field_class = JMECodeGenerator.lookupClass(((ObjectType)field_type).getClassName());
            if (field_class != null && field_class.isFinal()) {
                isfinal = true;
            }
        } else if (field_type instanceof ArrayType) {
            isarray = true;
            Type el_type = ((ArrayType)field_type).getElementType();
            if (el_type instanceof ObjectType) {
                field_class = JMECodeGenerator.lookupClass(((ObjectType)el_type).getClassName());
                if (field_class != null && field_class.isFinal()) {
                    isfinal = true;
                }
            } else if (el_type instanceof BasicType) {
                basicname = el_type.toString();
            }
        }
        if (basicname != null || isfinal && (JMESerializationInfo.hasJMEConstructor(field_class) || JMESerializationInfo.isJMESerializable(field_class) && this.generator.forceGeneratedCalls())) {
            write_il.append((Instruction)new ACONST_NULL());
            write_il.append((Instruction)new ALOAD(1));
            write_il.append((Instruction)this.factory.createFieldAccess("ibis.io.jme.ObjectOutputStream", "replacer", (Type)new ObjectType("ibis.io.Replacer"), (short)180));
            IF_ACMPEQ replacertest = new IF_ACMPEQ(null);
            write_il.append((BranchInstruction)replacertest);
            write_il.append(this.writeInstructions(field));
            GOTO toEnd = new GOTO(null);
            write_il.append((BranchInstruction)toEnd);
            replacertest.setTarget(write_il.append((Instruction)new ALOAD(1)));
            write_il.append((Instruction)new ALOAD(0));
            write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
            if (basicname != null) {
                write_il.append((Instruction)this.factory.createFieldAccess("ibis.io.jme.Constants", "TYPE_" + basicname.toUpperCase(), (Type)Type.INT, (short)178));
                write_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectOutputStream", "writeKnownArrayHeader", (Type)Type.INT, new Type[]{Type.OBJECT, Type.INT}, (short)182));
            } else {
                write_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectOutputStream", "writeKnownObjectHeader", (Type)Type.INT, new Type[]{Type.OBJECT}, (short)182));
            }
            write_il.append((Instruction)new ISTORE(2));
            write_il.append((Instruction)new ILOAD(2));
            write_il.append((Instruction)new ICONST(1));
            IF_ICMPNE ifcmp = new IF_ICMPNE(null);
            write_il.append((BranchInstruction)ifcmp);
            if (isarray) {
                write_il.append((Instruction)new ALOAD(1));
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                write_il.append((Instruction)new ARRAYLENGTH());
                write_il.append((Instruction)new DUP());
                write_il.append((Instruction)new ISTORE(4));
                write_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectOutputStream", "writeInt", (Type)Type.VOID, new Type[]{Type.INT}, (short)182));
                if (basicname != null) {
                    write_il.append((Instruction)new ALOAD(1));
                    write_il.append((Instruction)new ALOAD(0));
                    write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    write_il.append((Instruction)new ICONST(0));
                    write_il.append((Instruction)new ILOAD(4));
                    write_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectOutputStream", this.writeCallName(basicname), (Type)Type.VOID, new Type[]{field_type, Type.INT, Type.INT}, (short)182));
                } else {
                    write_il.append((Instruction)new ICONST(0));
                    write_il.append((Instruction)new ISTORE(3));
                    GOTO gto = new GOTO(null);
                    write_il.append((BranchInstruction)gto);
                    InstructionHandle loop_body_start = write_il.append((Instruction)new ALOAD(1));
                    write_il.append((Instruction)new ALOAD(0));
                    write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    write_il.append((Instruction)new ILOAD(3));
                    write_il.append((Instruction)new AALOAD());
                    write_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectOutputStream", "writeKnownObjectHeader", (Type)Type.INT, new Type[]{Type.OBJECT}, (short)182));
                    write_il.append((Instruction)new ISTORE(2));
                    write_il.append((Instruction)new ILOAD(2));
                    write_il.append((Instruction)new ICONST(1));
                    IF_ICMPNE ifcmp1 = new IF_ICMPNE(null);
                    write_il.append((BranchInstruction)ifcmp1);
                    write_il.append((Instruction)new ALOAD(0));
                    write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    write_il.append((Instruction)new ILOAD(3));
                    write_il.append((Instruction)new AALOAD());
                    write_il.append((Instruction)new ALOAD(1));
                    write_il.append(this.createGeneratedWriteObjectInvocation(field_class.getClassName(), (short)182));
                    ifcmp1.setTarget(write_il.append((Instruction)new IINC(3, 1)));
                    gto.setTarget(write_il.append((Instruction)new ILOAD(4)));
                    write_il.append((Instruction)new ILOAD(3));
                    write_il.append((BranchInstruction)new IF_ICMPGT(loop_body_start));
                }
            } else {
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                write_il.append((Instruction)new ALOAD(1));
                write_il.append(this.createGeneratedWriteObjectInvocation(field_class.getClassName(), (short)182));
            }
            InstructionHandle target = write_il.append((Instruction)new NOP());
            ifcmp.setTarget(target);
            toEnd.setTarget(target);
        } else {
            write_il.append(this.writeInstructions(field));
        }
        return write_il;
    }

    private InstructionList serialPersistentWrites(MethodGen write_gen) {
        FieldInstruction persistent_field_access = this.factory.createFieldAccess(this.classname, "serialPersistentFields", (Type)new ArrayType((Type)new ObjectType("ibis.io.jme.ObjectStreamField"), 1), (short)178);
        InstructionList write_il = new InstructionList();
        int[] case_values = new int[]{66, 67, 68, 70, 73, 74, 83, 90};
        InstructionHandle[] case_handles = new InstructionHandle[case_values.length];
        GOTO[] gotos = new GOTO[case_values.length + 1];
        for (int i = 0; i < gotos.length; ++i) {
            gotos[i] = new GOTO(null);
        }
        write_il.append((Instruction)new SIPUSH(0));
        write_il.append((Instruction)new ISTORE(2));
        GOTO gto = new GOTO(null);
        write_il.append((BranchInstruction)gto);
        InstructionHandle loop_body_start = write_il.append((Instruction)persistent_field_access);
        write_il.append((Instruction)new ILOAD(2));
        write_il.append((Instruction)new AALOAD());
        write_il.append((Instruction)this.factory.createInvoke("java.io.ObjectStreamField", "getName", (Type)Type.STRING, Type.NO_ARGS, (short)182));
        write_il.append((Instruction)new ASTORE(3));
        InstructionHandle begin_try = write_il.append((CompoundInstruction)new PUSH(this.constantpool, this.classname));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.Class", "forName", java_lang_class_type, new Type[]{Type.STRING}, (short)184));
        write_il.append((Instruction)new ALOAD(3));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.Class", "getField", (Type)new ObjectType("java.lang.reflect.Field"), new Type[]{Type.STRING}, (short)182));
        write_il.append((Instruction)new ASTORE(4));
        write_il.append((Instruction)persistent_field_access);
        write_il.append((Instruction)new ILOAD(2));
        write_il.append((Instruction)new AALOAD());
        write_il.append((Instruction)this.factory.createInvoke("java.io.ObjectStreamField", "getTypeCode", (Type)Type.CHAR, Type.NO_ARGS, (short)182));
        case_handles[0] = write_il.append((Instruction)new ALOAD(1));
        write_il.append((Instruction)new ALOAD(4));
        write_il.append((Instruction)new ALOAD(0));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getBoolean", (Type)Type.BOOLEAN, new Type[]{Type.OBJECT}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeBoolean", (Type)Type.VOID, new Type[]{Type.BOOLEAN}, (short)182));
        write_il.append((BranchInstruction)gotos[0]);
        case_handles[1] = write_il.append((Instruction)new ALOAD(1));
        write_il.append((Instruction)new ALOAD(4));
        write_il.append((Instruction)new ALOAD(0));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getChar", (Type)Type.CHAR, new Type[]{Type.OBJECT}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeChar", (Type)Type.VOID, new Type[]{Type.INT}, (short)182));
        write_il.append((BranchInstruction)gotos[1]);
        case_handles[2] = write_il.append((Instruction)new ALOAD(1));
        write_il.append((Instruction)new ALOAD(4));
        write_il.append((Instruction)new ALOAD(0));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getDouble", (Type)Type.DOUBLE, new Type[]{Type.OBJECT}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeDouble", (Type)Type.VOID, new Type[]{Type.DOUBLE}, (short)182));
        write_il.append((BranchInstruction)gotos[2]);
        case_handles[3] = write_il.append((Instruction)new ALOAD(1));
        write_il.append((Instruction)new ALOAD(4));
        write_il.append((Instruction)new ALOAD(0));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getFloat", (Type)Type.FLOAT, new Type[]{Type.OBJECT}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeFloat", (Type)Type.VOID, new Type[]{Type.FLOAT}, (short)182));
        write_il.append((BranchInstruction)gotos[3]);
        case_handles[4] = write_il.append((Instruction)new ALOAD(1));
        write_il.append((Instruction)new ALOAD(4));
        write_il.append((Instruction)new ALOAD(0));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getInt", (Type)Type.INT, new Type[]{Type.OBJECT}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeInt", (Type)Type.VOID, new Type[]{Type.INT}, (short)182));
        write_il.append((BranchInstruction)gotos[4]);
        case_handles[5] = write_il.append((Instruction)new ALOAD(1));
        write_il.append((Instruction)new ALOAD(4));
        write_il.append((Instruction)new ALOAD(0));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getLong", (Type)Type.LONG, new Type[]{Type.OBJECT}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeLong", (Type)Type.VOID, new Type[]{Type.LONG}, (short)182));
        write_il.append((BranchInstruction)gotos[5]);
        case_handles[6] = write_il.append((Instruction)new ALOAD(1));
        write_il.append((Instruction)new ALOAD(4));
        write_il.append((Instruction)new ALOAD(0));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getShort", (Type)Type.SHORT, new Type[]{Type.OBJECT}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeShort", (Type)Type.VOID, new Type[]{Type.INT}, (short)182));
        write_il.append((BranchInstruction)gotos[6]);
        case_handles[7] = write_il.append((Instruction)new ALOAD(1));
        write_il.append((Instruction)new ALOAD(4));
        write_il.append((Instruction)new ALOAD(0));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getBoolean", (Type)Type.BOOLEAN, new Type[]{Type.OBJECT}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeBoolean", (Type)Type.VOID, new Type[]{Type.BOOLEAN}, (short)182));
        write_il.append((BranchInstruction)gotos[7]);
        InstructionHandle default_handle = write_il.append((Instruction)new ALOAD(1));
        write_il.append((Instruction)new ALOAD(4));
        write_il.append((Instruction)new ALOAD(0));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "get", (Type)Type.OBJECT, new Type[]{Type.OBJECT}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationOutputStream", "writeObject", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
        BranchHandle end_try = write_il.append((BranchInstruction)gotos[8]);
        write_il.insert(case_handles[0], (CompoundInstruction)new SWITCH(case_values, case_handles, default_handle));
        InstructionHandle handler = write_il.append((Instruction)new ASTORE(6));
        write_il.append((Instruction)this.factory.createNew("java.io.IOException"));
        write_il.append((Instruction)new DUP());
        write_il.append((Instruction)this.factory.createNew("java.lang.StringBuffer"));
        write_il.append((Instruction)new DUP());
        write_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        write_il.append((CompoundInstruction)new PUSH(this.constantpool, "Could not write field "));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}, (short)182));
        write_il.append((Instruction)new ALOAD(3));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "toString", (Type)Type.STRING, Type.NO_ARGS, (short)182));
        write_il.append((Instruction)this.factory.createInvoke("java.io.IOException", "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        write_il.append((Instruction)new ATHROW());
        InstructionHandle gotos_target = write_il.append((Instruction)new IINC(2, 1));
        for (int i = 0; i < gotos.length; ++i) {
            gotos[i].setTarget(gotos_target);
        }
        InstructionHandle loop_test = write_il.append((Instruction)new ILOAD(2));
        write_il.append((Instruction)persistent_field_access);
        gto.setTarget(loop_test);
        write_il.append((Instruction)new ARRAYLENGTH());
        write_il.append((BranchInstruction)new IF_ICMPLT(loop_body_start));
        write_gen.addExceptionHandler(begin_try, (InstructionHandle)end_try, handler, new ObjectType("java.lang.Exception"));
        return write_il;
    }

    private InstructionList generateDefaultWrites(MethodGen write_gen) {
        Type field_type;
        Field field;
        int i;
        InstructionList write_il = new InstructionList();
        if (this.has_jme_serial_persistent_fields) {
            return this.serialPersistentWrites(write_gen);
        }
        for (i = 0; i < this.fields.length; ++i) {
            field = this.fields[i];
            if (field.isStatic() || field.isTransient() || !((field_type = Type.getType((String)field.getSignature())) instanceof BasicType)) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    writing basic field " + field.getName() + " of type " + field.getSignature());
            }
            write_il.append(this.writeInstructions(field));
        }
        for (i = 0; i < this.fields.length; ++i) {
            field = this.fields[i];
            if (field.isStatic() || field.isTransient() || !((field_type = Type.getType((String)field.getSignature())) instanceof ReferenceType)) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    writing field " + field.getName() + " of type " + field.getSignature());
            }
            if (!field_type.equals((Object)Type.STRING) && !field_type.equals((Object)java_lang_class_type)) {
                write_il.append(this.writeReferenceField(field));
                continue;
            }
            write_il.append(this.writeInstructions(field));
        }
        return write_il;
    }

    private String readCallName(String name) {
        return "readArray" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private InstructionList readReferenceField(Field field, boolean from_constructor) {
        Type field_type = Type.getType((String)field.getSignature());
        InstructionList read_il = new InstructionList();
        boolean isfinal = false;
        boolean isarray = false;
        JavaClass field_class = null;
        String basicname = null;
        if (this.generator.isVerbose()) {
            System.out.println("    reading reference field " + field.getName() + " of type " + field_type.getSignature());
        }
        if (field_type instanceof ObjectType) {
            field_class = JMECodeGenerator.lookupClass(((ObjectType)field_type).getClassName());
            if (field_class != null && field_class.isFinal()) {
                isfinal = true;
            }
        } else if (field_type instanceof ArrayType) {
            isarray = true;
            Type el_type = ((ArrayType)field_type).getElementType();
            if (el_type instanceof ObjectType) {
                field_class = JMECodeGenerator.lookupClass(((ObjectType)el_type).getClassName());
                if (field_class != null && field_class.isFinal()) {
                    isfinal = true;
                }
            } else if (el_type instanceof BasicType) {
                basicname = el_type.toString();
            }
        }
        if (basicname != null || isfinal && (JMESerializationInfo.hasJMEConstructor(field_class) || JMESerializationInfo.isJMESerializable(field_class) && this.generator.forceGeneratedCalls())) {
            read_il.append((Instruction)new ALOAD(1));
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "readKnownTypeHeader", (Type)Type.INT, Type.NO_ARGS, (short)182));
            read_il.append((Instruction)new ISTORE(2));
            read_il.append((Instruction)new ILOAD(2));
            read_il.append((Instruction)new ICONST(-1));
            IF_ICMPNE ifcmp = new IF_ICMPNE(null);
            read_il.append((BranchInstruction)ifcmp);
            if (isarray) {
                if (basicname != null) {
                    String callname = this.readCallName(basicname);
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", callname, field_type, Type.NO_ARGS, (short)182));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)181));
                } else {
                    Type el_type = ((ArrayType)field_type).getElementType();
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "readInt", (Type)Type.INT, Type.NO_ARGS, (short)182));
                    read_il.append((Instruction)new DUP());
                    read_il.append((Instruction)new ISTORE(3));
                    read_il.append(this.factory.createNewArray(el_type, (short)1));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)181));
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "addObjectToCycleCheck", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
                    read_il.append((Instruction)new ICONST(0));
                    read_il.append((Instruction)new ISTORE(4));
                    GOTO gto1 = new GOTO(null);
                    read_il.append((BranchInstruction)gto1);
                    InstructionHandle loop_body_start = read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "readKnownTypeHeader", (Type)Type.INT, Type.NO_ARGS, (short)182));
                    read_il.append((Instruction)new ISTORE(2));
                    read_il.append((Instruction)new ILOAD(2));
                    read_il.append((Instruction)new ICONST(-1));
                    IF_ICMPNE ifcmp1 = new IF_ICMPNE(null);
                    read_il.append((BranchInstruction)ifcmp1);
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    read_il.append((Instruction)new ILOAD(4));
                    read_il.append((Instruction)this.factory.createNew((ObjectType)el_type));
                    read_il.append((Instruction)new DUP());
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append(this.createInitInvocation(field_class.getClassName(), this.factory));
                    read_il.append((Instruction)new AASTORE());
                    GOTO gto2 = new GOTO(null);
                    read_il.append((BranchInstruction)gto2);
                    InstructionHandle cmp_goto2 = read_il.append((Instruction)new ILOAD(2));
                    ifcmp1.setTarget(cmp_goto2);
                    read_il.append((Instruction)new ICONST(0));
                    IF_ICMPEQ ifcmpeq2 = new IF_ICMPEQ(null);
                    read_il.append((BranchInstruction)ifcmpeq2);
                    read_il.append((Instruction)new ALOAD(0));
                    read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)180));
                    read_il.append((Instruction)new ILOAD(4));
                    read_il.append((Instruction)new ALOAD(1));
                    read_il.append((Instruction)new ILOAD(2));
                    read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "getObjectFromCycleCheck", (Type)Type.OBJECT, new Type[]{Type.INT}, (short)182));
                    read_il.append((Instruction)this.factory.createCheckCast((ReferenceType)el_type));
                    read_il.append((Instruction)new AASTORE());
                    InstructionHandle target2 = read_il.append((Instruction)new NOP());
                    ifcmpeq2.setTarget(target2);
                    gto2.setTarget(target2);
                    read_il.append((Instruction)new IINC(4, 1));
                    gto1.setTarget(read_il.append((Instruction)new ILOAD(3)));
                    read_il.append((Instruction)new ILOAD(4));
                    read_il.append((BranchInstruction)new IF_ICMPGT(loop_body_start));
                }
            } else {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)this.factory.createNew((ObjectType)field_type));
                read_il.append((Instruction)new DUP());
                read_il.append((Instruction)new ALOAD(1));
                read_il.append(this.createInitInvocation(field_class.getClassName(), this.factory));
                read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)181));
            }
            GOTO gto = new GOTO(null);
            read_il.append((BranchInstruction)gto);
            InstructionHandle cmp_goto = read_il.append((Instruction)new ILOAD(2));
            ifcmp.setTarget(cmp_goto);
            read_il.append((Instruction)new ICONST(0));
            IF_ICMPEQ ifcmpeq = new IF_ICMPEQ(null);
            read_il.append((BranchInstruction)ifcmpeq);
            read_il.append((Instruction)new ALOAD(0));
            read_il.append((Instruction)new ALOAD(1));
            read_il.append((Instruction)new ILOAD(2));
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "getObjectFromCycleCheck", (Type)Type.OBJECT, new Type[]{Type.INT}, (short)182));
            read_il.append((Instruction)this.factory.createCheckCast((ReferenceType)field_type));
            read_il.append((Instruction)this.factory.createFieldAccess(this.classname, field.getName(), field_type, (short)181));
            InstructionHandle target = read_il.append((Instruction)new NOP());
            ifcmpeq.setTarget(target);
            gto.setTarget(target);
        } else {
            read_il.append(this.readInstructions(field, from_constructor));
        }
        return read_il;
    }

    private InstructionHandle generateReadField(String tpname, Type tp, InstructionList read_il, GOTO gto, boolean from_constructor) {
        if (from_constructor || !this.has_final_fields) {
            InstructionHandle h = read_il.append((Instruction)new ALOAD(4));
            read_il.append((Instruction)new ALOAD(0));
            read_il.append((Instruction)new ALOAD(1));
            if (tpname.equals("")) {
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "readObject", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
            } else {
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "read" + tpname, tp, Type.NO_ARGS, (short)182));
            }
            read_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "set" + tpname, (Type)Type.VOID, new Type[]{Type.OBJECT, tp}, (short)182));
            read_il.append((BranchInstruction)gto);
            return h;
        }
        InstructionHandle h = read_il.append((Instruction)new ILOAD(5));
        read_il.append((CompoundInstruction)new PUSH(this.constantpool, 16));
        read_il.append((Instruction)new IAND());
        IFEQ eq = new IFEQ(null);
        read_il.append((BranchInstruction)eq);
        read_il.append((Instruction)new ALOAD(1));
        read_il.append((Instruction)new ALOAD(0));
        read_il.append((Instruction)new ALOAD(3));
        if (tpname.equals("")) {
            read_il.append((Instruction)new ALOAD(4));
            read_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getType", (Type)new ObjectType("java.lang.Class"), Type.NO_ARGS, (short)182));
            read_il.append((Instruction)this.factory.createInvoke("java.lang.Class", "getName", (Type)Type.STRING, Type.NO_ARGS, (short)182));
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "readFieldObject", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING, Type.STRING}, (short)182));
        } else {
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "readField" + tpname, (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)182));
        }
        GOTO gto2 = new GOTO(null);
        read_il.append((BranchInstruction)gto2);
        eq.setTarget(read_il.append((Instruction)new ALOAD(4)));
        read_il.append((Instruction)new ALOAD(0));
        read_il.append((Instruction)new ALOAD(1));
        if (tpname.equals("")) {
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "readObject", tp, Type.NO_ARGS, (short)182));
        } else {
            read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "read" + tpname, tp, Type.NO_ARGS, (short)182));
        }
        read_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "set" + tpname, (Type)Type.VOID, new Type[]{Type.OBJECT, tp}, (short)182));
        gto2.setTarget((InstructionHandle)read_il.append((BranchInstruction)gto));
        return h;
    }

    private InstructionList serialPersistentReads(boolean from_constructor, MethodGen read_gen) {
        FieldInstruction persistent_field_access = this.factory.createFieldAccess(this.classname, "serialPersistentFields", (Type)new ArrayType((Type)new ObjectType("java.io.ObjectStreamField"), 1), (short)178);
        InstructionList read_il = new InstructionList();
        int[] case_values = new int[]{66, 67, 68, 70, 73, 74, 83, 90};
        InstructionHandle[] case_handles = new InstructionHandle[case_values.length];
        GOTO[] gotos = new GOTO[case_values.length + 1];
        for (int i = 0; i < gotos.length; ++i) {
            gotos[i] = new GOTO(null);
        }
        read_il.append((Instruction)new SIPUSH(0));
        read_il.append((Instruction)new ISTORE(2));
        GOTO gto = new GOTO(null);
        read_il.append((BranchInstruction)gto);
        InstructionHandle loop_body_start = read_il.append((Instruction)persistent_field_access);
        read_il.append((Instruction)new ILOAD(2));
        read_il.append((Instruction)new AALOAD());
        read_il.append((Instruction)this.factory.createInvoke("java.io.ObjectStreamField", "getName", (Type)Type.STRING, Type.NO_ARGS, (short)182));
        read_il.append((Instruction)new ASTORE(3));
        InstructionHandle begin_try = read_il.append((CompoundInstruction)new PUSH(this.constantpool, this.classname));
        read_il.append((Instruction)this.factory.createInvoke("java.lang.Class", "forName", java_lang_class_type, new Type[]{Type.STRING}, (short)184));
        read_il.append((Instruction)new ALOAD(3));
        read_il.append((Instruction)this.factory.createInvoke("java.lang.Class", "getField", (Type)new ObjectType("java.lang.reflect.Field"), new Type[]{Type.STRING}, (short)182));
        read_il.append((Instruction)new ASTORE(4));
        if (!from_constructor && this.has_final_fields) {
            read_il.append((Instruction)new ALOAD(4));
            read_il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Field", "getModifiers", (Type)Type.INT, Type.NO_ARGS, (short)182));
            read_il.append((Instruction)new ISTORE(5));
        }
        read_il.append((Instruction)persistent_field_access);
        read_il.append((Instruction)new ILOAD(2));
        read_il.append((Instruction)new AALOAD());
        read_il.append((Instruction)this.factory.createInvoke("java.io.ObjectStreamField", "getTypeCode", (Type)Type.CHAR, Type.NO_ARGS, (short)182));
        case_handles[0] = this.generateReadField("Byte", (Type)Type.BYTE, read_il, gotos[0], from_constructor);
        case_handles[1] = this.generateReadField("Char", (Type)Type.CHAR, read_il, gotos[1], from_constructor);
        case_handles[2] = this.generateReadField("Double", (Type)Type.DOUBLE, read_il, gotos[2], from_constructor);
        case_handles[3] = this.generateReadField("Float", (Type)Type.FLOAT, read_il, gotos[3], from_constructor);
        case_handles[4] = this.generateReadField("Int", (Type)Type.INT, read_il, gotos[4], from_constructor);
        case_handles[5] = this.generateReadField("Long", (Type)Type.LONG, read_il, gotos[5], from_constructor);
        case_handles[6] = this.generateReadField("Short", (Type)Type.SHORT, read_il, gotos[6], from_constructor);
        case_handles[7] = this.generateReadField("Boolean", (Type)Type.BOOLEAN, read_il, gotos[7], from_constructor);
        InstructionHandle default_handle = this.generateReadField("", (Type)Type.OBJECT, read_il, gotos[8], from_constructor);
        InstructionHandle end_try = read_il.getEnd();
        read_il.insert(case_handles[0], (CompoundInstruction)new SWITCH(case_values, case_handles, default_handle));
        InstructionHandle handler = read_il.append((Instruction)new ASTORE(6));
        read_il.append((Instruction)this.factory.createNew("java.io.IOException"));
        read_il.append((Instruction)new DUP());
        read_il.append((Instruction)this.factory.createNew("java.lang.StringBuffer"));
        read_il.append((Instruction)new DUP());
        read_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        read_il.append((CompoundInstruction)new PUSH(this.constantpool, "Could not read field "));
        read_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}, (short)182));
        read_il.append((Instruction)new ALOAD(3));
        read_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}, (short)182));
        read_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "toString", (Type)Type.STRING, Type.NO_ARGS, (short)182));
        read_il.append((Instruction)this.factory.createInvoke("java.io.IOException", "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        read_il.append((Instruction)new ATHROW());
        InstructionHandle gotos_target = read_il.append((Instruction)new IINC(2, 1));
        for (int i = 0; i < gotos.length; ++i) {
            gotos[i].setTarget(gotos_target);
        }
        InstructionHandle loop_test = read_il.append((Instruction)new ILOAD(2));
        read_il.append((Instruction)persistent_field_access);
        gto.setTarget(loop_test);
        read_il.append((Instruction)new ARRAYLENGTH());
        read_il.append((BranchInstruction)new IF_ICMPLT(loop_body_start));
        read_gen.addExceptionHandler(begin_try, end_try, handler, new ObjectType("java.lang.Exception"));
        return read_il;
    }

    private InstructionList generateDefaultReads(boolean from_constructor, MethodGen read_gen) {
        Type field_type;
        Field field;
        int i;
        InstructionList read_il = new InstructionList();
        if (this.has_jme_serial_persistent_fields) {
            return this.serialPersistentReads(from_constructor, read_gen);
        }
        for (i = 0; i < this.fields.length; ++i) {
            field = this.fields[i];
            if (field.isStatic() || field.isTransient() || !((field_type = Type.getType((String)field.getSignature())) instanceof BasicType)) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    writing basic field " + field.getName() + " of type " + field_type.getSignature());
            }
            read_il.append(this.readInstructions(field, from_constructor));
        }
        for (i = 0; i < this.fields.length; ++i) {
            field = this.fields[i];
            if (field.isStatic() || field.isTransient()) continue;
            field_type = Type.getType((String)field.getSignature());
            if (this.generator.isVerbose()) {
                System.out.println("    writing field " + field.getName() + " of type " + field.getSignature());
            }
            if (!(field_type instanceof ReferenceType)) continue;
            if (!field_type.equals((Object)Type.STRING) && !field_type.equals((Object)java_lang_class_type)) {
                read_il.append(this.readReferenceField(field, from_constructor));
                continue;
            }
            read_il.append(this.readInstructions(field, from_constructor));
        }
        return read_il;
    }

    private JavaClass generateInstanceGenerator() {
        if (this.generator.isVerbose()) {
            System.out.println("  Generating InstanceGenerator class for " + this.classname);
        }
        String name = this.classname + "_ibis_io_Generator";
        ObjectType class_type = new ObjectType(this.classname);
        String classfilename = name.substring(name.lastIndexOf(46) + 1) + ".class";
        ClassGen iogenGen = new ClassGen(name, "ibis.io.jme.Generator", classfilename, 49, null);
        InstructionFactory iogenFactory = new InstructionFactory(iogenGen);
        InstructionList il = new InstructionList();
        if (!this.is_jme_externalizable && this.super_is_jme_serializable && !this.super_has_jme_constructor && !this.generator.forceGeneratedCalls()) {
            il.append((Instruction)new ALOAD(1));
            int ind = iogenGen.getConstantPool().addString(this.classname);
            il.append((Instruction)new LDC(ind));
            il.append((Instruction)iogenFactory.createInvoke("ibis.io.jme.ObjectInputStream", "create_uninitialized_object", (Type)Type.OBJECT, new Type[]{Type.STRING}, (short)182));
            il.append((Instruction)iogenFactory.createCheckCast((ReferenceType)class_type));
            il.append((Instruction)new ASTORE(2));
            il.append((Instruction)new ALOAD(1));
            il.append((Instruction)new ALOAD(2));
            ind = iogenGen.getConstantPool().addString(this.super_classname);
            il.append((Instruction)new LDC(ind));
            il.append((Instruction)iogenFactory.createInvoke("ibis.io.jme.ObjectInputStream", "readSerializableObject", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)182));
            if (JMESerializationInfo.hasReadObject(this.methods)) {
                il.append((Instruction)new ALOAD(2));
                il.append((Instruction)new ALOAD(1));
                il.append((Instruction)iogenFactory.createInvoke(this.classname, "$readObjectWrapper$", (Type)Type.VOID, ibis_input_stream_arrtp, (short)182));
            } else {
                int dpth = this.getClassDepth(this.clazz);
                il.append((Instruction)new ALOAD(2));
                il.append((Instruction)new ALOAD(1));
                il.append((Instruction)new SIPUSH((short)dpth));
                il.append(this.createGeneratedDefaultReadObjectInvocation(this.classname, iogenFactory, (short)182));
            }
            il.append((Instruction)new ALOAD(2));
        } else {
            il.append((Instruction)iogenFactory.createNew(class_type));
            il.append((Instruction)new DUP());
            il.append((Instruction)new ALOAD(1));
            il.append(this.createInitInvocation(this.classname, iogenFactory));
        }
        il.append((Instruction)new ARETURN());
        MethodGen method = new MethodGen(17, (Type)Type.OBJECT, jme_input_stream_arrtp, new String[]{"is"}, "generated_newInstance", name, il, iogenGen.getConstantPool());
        method.setMaxStack(3);
        method.setMaxLocals();
        method.addException("java.io.IOException");
        method.addException("java.lang.ClassNotFoundException");
        iogenGen.addMethod(method.getMethod());
        il = new InstructionList();
        il.append((Instruction)new ALOAD(0));
        il.append((Instruction)iogenFactory.createInvoke("ibis.io.jme.Generator", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append((Instruction)new RETURN());
        method = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, null, "<init>", name, il, iogenGen.getConstantPool());
        method.setMaxStack(1);
        method.setMaxLocals();
        iogenGen.addMethod(method.getMethod());
        il = new InstructionList();
        il.append((Instruction)new ACONST_NULL());
        il.append((Instruction)new ASTORE(3));
        il.append((Instruction)new ILOAD(2));
        InstructionHandle done = il.append((Instruction)new ALOAD(3));
        il.append((Instruction)new ARETURN());
        ConstantPoolGen cp = iogenGen.getConstantPool();
        InstructionHandle[] handles = new InstructionHandle[5];
        int i = 0;
        String arrayName = this.classname;
        do {
            handles[i++] = il.insert(done, (Instruction)new ILOAD(1));
            int index = cp.addClass(arrayName);
            if (this.generator.isVerbose()) {
                System.out.println("Added : " + arrayName + " : " + index + " to cp.");
            }
            il.insert(done, (Instruction)new ANEWARRAY(index));
            il.insert(done, (Instruction)new ASTORE(3));
            if (handles[handles.length - 1] == null) {
                il.insert(done, (BranchInstruction)new GOTO(done));
            }
            if (!arrayName.startsWith("[")) {
                arrayName = "L" + arrayName + ";";
            }
            arrayName = "[" + arrayName;
            if (!this.generator.isVerbose()) continue;
            System.out.println("Generating " + arrayName);
        } while (handles[handles.length - 1] == null);
        int[] values = new int[]{1, 2, 3, 4, 5};
        il.insert(handles[0], (CompoundInstruction)new SWITCH(values, handles, done));
        method = new MethodGen(1, Type.getType(Object[].class), new Type[]{Type.INT, Type.INT}, new String[]{"len", "dimension"}, "new_array", name, il, iogenGen.getConstantPool());
        method.setMaxStack(1);
        method.setMaxLocals(4);
        iogenGen.addMethod(method.getMethod());
        return iogenGen.getJavaClass();
    }

    @Override
    void generateCode() {
        if (this.generator.isVerbose()) {
            System.out.println("  Generating method code class for class : " + this.classname);
            System.out.println("    Number of fields " + this.fields.length);
        }
        int dpth = this.getClassDepth(this.clazz);
        this.fillInGeneratedDefaultWriteObjectMethod(dpth);
        this.fillInGeneratedDefaultReadObjectMethod(dpth);
        this.fillInGeneratedWriteObjectMethod(dpth);
        this.fillInGeneratedReadObjectMethod(dpth);
        this.clazz = this.gen.getJavaClass();
        Repository.removeClass((String)this.classname);
        Repository.addClass((JavaClass)this.clazz);
        JavaClass instgen = null;
        if (!this.is_jme_abstract) {
            instgen = this.generateInstanceGenerator();
            Repository.addClass((JavaClass)instgen);
        }
        this.generator.markRewritten(this.clazz, instgen);
    }

    private void fillInGeneratedReadObjectMethod(int dpth) {
        MethodGen mgen = null;
        int index = -1;
        InstructionList read_il = null;
        if (this.is_jme_externalizable || this.super_has_jme_constructor || !this.super_is_jme_serializable || this.generator.forceGeneratedCalls()) {
            read_il = new InstructionList();
            if (this.is_jme_externalizable) {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)this.factory.createInvoke(this.classname, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
            } else if (!this.super_is_jme_serializable) {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)this.factory.createInvoke(this.super_classname, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
            } else {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new ALOAD(1));
                read_il.append(this.createInitInvocation(this.super_classname, this.factory));
            }
            if (this.is_jme_externalizable || !this.super_is_jme_serializable) {
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "addObjectToCycleCheck", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
            }
            int read_cons_index = JMESerializationInfo.findMethod(this.methods, "<init>", "(Libis/io/jme/ObjectInputStream;)V");
            mgen = new MethodGen(this.methods[read_cons_index], this.classname, this.constantpool);
            index = read_cons_index;
        } else if (JMESerializationInfo.hasReadObject(this.methods)) {
            int read_wrapper_index = JMESerializationInfo.findMethod(this.methods, "$readObjectWrapper$", "(Libis/io/jme/ObjectInputStream;)V");
            mgen = new MethodGen(this.methods[read_wrapper_index], this.classname, this.constantpool);
            read_il = new InstructionList();
            index = read_wrapper_index;
        }
        if (read_il != null) {
            if (this.is_jme_externalizable || JMESerializationInfo.hasReadObject(this.methods)) {
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new SIPUSH((short)dpth));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "push_current_object", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.INT}, (short)182));
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "getJavaObjectInputStream", (Type)sun_input_stream, Type.NO_ARGS, (short)182));
                if (this.is_jme_externalizable) {
                    read_il.append((Instruction)this.factory.createInvoke(this.classname, "readExternal", (Type)Type.VOID, new Type[]{new ObjectType("java.io.ObjectInput")}, (short)182));
                } else {
                    read_il.append((Instruction)this.factory.createInvoke(this.classname, "readObject", (Type)Type.VOID, new Type[]{sun_input_stream}, (short)183));
                }
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.IbisSerializationInputStream", "pop_current_object", (Type)Type.VOID, Type.NO_ARGS, (short)182));
            } else {
                read_il.append(this.generateDefaultReads(true, mgen));
            }
            read_il.append(mgen.getInstructionList());
            mgen.setInstructionList(read_il);
            mgen.setMaxStack(MethodGen.getMaxStack((ConstantPoolGen)this.constantpool, (InstructionList)read_il, (CodeExceptionGen[])mgen.getExceptionHandlers()));
            mgen.setMaxLocals();
            this.gen.setMethodAt(mgen.getMethod(), index);
        }
    }

    private void fillInGeneratedWriteObjectMethod(int dpth) {
        int write_method_index = JMESerializationInfo.findMethod(this.methods, "generated_JME_WriteObject", "(Libis/io/jme/ObjectOutputStream;)V");
        InstructionList write_il = new InstructionList();
        MethodGen write_gen = new MethodGen(this.methods[write_method_index], this.classname, this.constantpool);
        if (!this.is_jme_externalizable && (this.super_is_jme_serializable || this.generator.forceGeneratedCalls() && this.super_is_jme_rewritten)) {
            write_il.append((Instruction)new ALOAD(0));
            write_il.append((Instruction)new ALOAD(1));
            write_il.append(this.createGeneratedWriteObjectInvocation(this.super_classname, (short)183));
        }
        if (this.is_jme_externalizable || JMESerializationInfo.hasWriteObject(this.methods)) {
            write_il.append((Instruction)new ALOAD(1));
            write_il.append((Instruction)new ALOAD(0));
            write_il.append((Instruction)new SIPUSH((short)dpth));
            write_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectOutputStream", "push_current_object", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.INT}, (short)182));
            write_il.append(this.createGeneratedWriteObjectInvocation(this.clazz.getClassName(), (short)182));
            write_il.append((Instruction)new ALOAD(1));
            write_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectOutputStream", "pop_current_object", (Type)Type.VOID, Type.NO_ARGS, (short)182));
        } else if (!this.super_is_jme_serializable && !this.super_is_jme_special_case) {
            System.err.println("Class: " + this.clazz.getClassName() + " marked ibis.io.jme.Serializable but superclass is not serializable! Use Externalizable if the superclass can not be marked the same.");
            write_il.append((Instruction)new ALOAD(0));
            write_il.append((Instruction)this.factory.createNew("ibis.io.jme.NotSerializableException"));
            write_il.append((Instruction)new DUP());
            write_il.append((Instruction)this.factory.createNew("java.lang.StringBuffer"));
            write_il.append((Instruction)new DUP());
            write_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
            write_il.append((CompoundInstruction)new PUSH(this.constantpool, "Superclass Not Serializable: " + this.clazz.getClassName()));
            write_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}, (short)182));
            write_il.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "toString", (Type)Type.STRING, Type.NO_ARGS, (short)182));
            write_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.NotSerializableException", "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
            write_il.append((Instruction)new ATHROW());
        } else {
            write_il.append(this.generateDefaultWrites(write_gen));
        }
        write_gen = new MethodGen(this.methods[write_method_index], this.classname, this.constantpool);
        write_il.append(write_gen.getInstructionList());
        write_gen.setInstructionList(write_il);
        write_gen.setMaxStack(MethodGen.getMaxStack((ConstantPoolGen)this.constantpool, (InstructionList)write_il, (CodeExceptionGen[])write_gen.getExceptionHandlers()));
        write_gen.setMaxLocals();
        this.gen.setMethodAt(write_gen.getMethod(), write_method_index);
    }

    private void fillInGeneratedDefaultWriteObjectMethod(int dpth) {
        int default_write_method_index = JMESerializationInfo.findMethod(this.methods, "generated_JME_DefaultWriteObject", "(Libis/io/jme/ObjectOutputStream;I)V");
        MethodGen write_gen = new MethodGen(this.methods[default_write_method_index], this.classname, this.constantpool);
        InstructionList write_il = new InstructionList();
        InstructionHandle end = write_gen.getInstructionList().getStart();
        write_il.append((Instruction)new ILOAD(2));
        write_il.append((Instruction)new SIPUSH((short)dpth));
        IF_ICMPNE ifcmpne = new IF_ICMPNE(null);
        write_il.append((BranchInstruction)ifcmpne);
        write_il.append(this.generateDefaultWrites(write_gen));
        write_il.append((BranchInstruction)new GOTO(end));
        if (this.super_is_jme_serializable || this.super_is_jme_rewritten) {
            InstructionHandle i = write_il.append((Instruction)new ILOAD(2));
            ifcmpne.setTarget(i);
            write_il.append((Instruction)new SIPUSH((short)dpth));
            write_il.append((BranchInstruction)new IF_ICMPGT(end));
            if (this.super_is_jme_serializable || this.super_is_jme_rewritten || this.generator.forceGeneratedCalls()) {
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)new ALOAD(1));
                write_il.append((Instruction)new ILOAD(2));
                write_il.append(this.createGeneratedDefaultWriteObjectInvocation(this.super_classname));
            } else {
                write_il.append((Instruction)new ALOAD(1));
                write_il.append((Instruction)new ALOAD(0));
                write_il.append((Instruction)new ILOAD(2));
                write_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectOutputStream", "defaultWriteSerializableObject", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.INT}, (short)182));
            }
        } else {
            ifcmpne.setTarget(end);
        }
        write_il.append(write_gen.getInstructionList());
        write_gen.setInstructionList(write_il);
        write_gen.setMaxStack(MethodGen.getMaxStack((ConstantPoolGen)this.constantpool, (InstructionList)write_il, (CodeExceptionGen[])write_gen.getExceptionHandlers()));
        write_gen.setMaxLocals();
        this.gen.setMethodAt(write_gen.getMethod(), default_write_method_index);
    }

    private void fillInGeneratedDefaultReadObjectMethod(int dpth) {
        int default_read_method_index = JMESerializationInfo.findMethod(this.methods, "generated_JME_DefaultReadObject", "(Libis/io/jme/ObjectInputStream;I)V");
        MethodGen read_gen = new MethodGen(this.methods[default_read_method_index], this.classname, this.constantpool);
        InstructionList read_il = new InstructionList();
        InstructionHandle end = read_gen.getInstructionList().getStart();
        read_il.append((Instruction)new ILOAD(2));
        read_il.append((Instruction)new SIPUSH((short)dpth));
        IF_ICMPNE ifcmpne = new IF_ICMPNE(null);
        read_il.append((BranchInstruction)ifcmpne);
        read_il.append(this.generateDefaultReads(false, read_gen));
        read_il.append((BranchInstruction)new GOTO(end));
        if (this.super_is_jme_serializable || this.super_is_jme_rewritten) {
            InstructionHandle i = read_il.append((Instruction)new ILOAD(2));
            ifcmpne.setTarget(i);
            read_il.append((Instruction)new SIPUSH((short)dpth));
            read_il.append((BranchInstruction)new IF_ICMPGT(end));
            if (this.super_is_jme_serializable || this.generator.forceGeneratedCalls()) {
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)new ILOAD(2));
                read_il.append(this.createGeneratedDefaultReadObjectInvocation(this.super_classname, this.factory, (short)183));
            } else {
                read_il.append((Instruction)new ALOAD(1));
                read_il.append((Instruction)new ALOAD(0));
                read_il.append((Instruction)new ILOAD(2));
                read_il.append((Instruction)this.factory.createInvoke("ibis.io.jme.ObjectInputStream", "defaultReadSerializableObject", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.INT}, (short)182));
            }
        } else {
            ifcmpne.setTarget(end);
        }
        read_il.append(read_gen.getInstructionList());
        read_gen.setInstructionList(read_il);
        read_gen.setMaxStack(MethodGen.getMaxStack((ConstantPoolGen)this.constantpool, (InstructionList)read_il, (CodeExceptionGen[])read_gen.getExceptionHandlers()));
        read_gen.setMaxLocals();
        this.gen.setMethodAt(read_gen.getMethod(), default_read_method_index);
    }
}

