/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.IbisIOException;
import ibis.io.JavaDependantStuff;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class SunJavaStuff
extends JavaDependantStuff {
    private static Method newInstance = null;
    private static Object unsafe = null;
    private static Method unsafeObjectFieldOffsetMethod;
    private static Method unsafePutDoubleMethod;
    private static Method unsafePutLongMethod;
    private static Method unsafePutFloatMethod;
    private static Method unsafePutIntMethod;
    private static Method unsafePutShortMethod;
    private static Method unsafePutCharMethod;
    private static Method unsafePutBooleanMethod;
    private static Method unsafePutByteMethod;
    private static Method unsafePutObjectMethod;
    static boolean available;

    SunJavaStuff(Class<?> clazz) {
        super(clazz);
        if (!available) {
            throw new Error("SunJavaStuff not available");
        }
    }

    @Override
    public void setFieldDouble(Object ref, String fieldname, double d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutDoubleMethod.invoke(unsafe, ref, key, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldLong(Object ref, String fieldname, long d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutLongMethod.invoke(unsafe, ref, key, d);
            return;
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldFloat(Object ref, String fieldname, float d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutFloatMethod.invoke(unsafe, ref, key, Float.valueOf(d));
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldInt(Object ref, String fieldname, int d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutIntMethod.invoke(unsafe, ref, key, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldShort(Object ref, String fieldname, short d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutShortMethod.invoke(unsafe, ref, key, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldChar(Object ref, String fieldname, char d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutCharMethod.invoke(unsafe, ref, key, Character.valueOf(d));
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldByte(Object ref, String fieldname, byte d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutByteMethod.invoke(unsafe, ref, key, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldBoolean(Object ref, String fieldname, boolean d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutBooleanMethod.invoke(unsafe, ref, key, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldString(Object ref, String fieldname, String d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutObjectMethod.invoke(unsafe, ref, key, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldClass(Object ref, String fieldname, Class<?> d) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutObjectMethod.invoke(unsafe, ref, key, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    public void setFieldObject(Object ref, String fieldname, Object d, String fieldsig) throws IOException {
        try {
            Field f = this.clazz.getDeclaredField(fieldname);
            if (d != null && !f.getType().isInstance(d)) {
                throw new IbisIOException("wrong field type");
            }
            Object key = unsafeObjectFieldOffsetMethod.invoke(unsafe, f);
            unsafePutObjectMethod.invoke(unsafe, ref, key, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    @Override
    Object newInstance() {
        try {
            return newInstance.invoke((Object)this.objectStreamClass, (Object[])null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        available = false;
        try {
            newInstance = ObjectStreamClass.class.getDeclaredMethod("newInstance", new Class[0]);
            newInstance.setAccessible(true);
            Class<?> cl = Class.forName("java.io.ObjectStreamClass$FieldReflector");
            Field uf = cl.getDeclaredField("unsafe");
            uf.setAccessible(true);
            unsafe = uf.get(null);
            cl = unsafe.getClass();
            unsafeObjectFieldOffsetMethod = cl.getMethod("objectFieldOffset", Field.class);
            unsafePutDoubleMethod = cl.getMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
            unsafePutLongMethod = cl.getMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
            unsafePutFloatMethod = cl.getMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
            unsafePutIntMethod = cl.getMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
            unsafePutShortMethod = cl.getMethod("putShort", Object.class, Long.TYPE, Short.TYPE);
            unsafePutCharMethod = cl.getMethod("putChar", Object.class, Long.TYPE, Character.TYPE);
            unsafePutByteMethod = cl.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
            unsafePutBooleanMethod = cl.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            unsafePutObjectMethod = cl.getMethod("putObject", Object.class, Long.TYPE, Object.class);
            available = true;
        }
        catch (Throwable e) {
            logger.info("Sun Java Stuff not available", e);
        }
    }
}

